/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.common.CollectionFun;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/introspection/RegularIntrospectionTask;", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseName", "", "elementsToRefresh", "", "Lcom/intellij/database/util/ObjectPath;", "(Ljava/lang/String;Ljava/util/Collection;)V", "containsDatabaseItself", "", "getContainsDatabaseItself", "()Z", "containsDatabaseItselfCalculated", "containsDatabaseItselfValue", "getElementsToRefresh", "()Ljava/util/Collection;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "toString", "intellij.database.core.impl"})
public class RegularIntrospectionTask
extends DefiniteIntrospectionTask {
    @NotNull
    private final Collection<ObjectPath> elementsToRefresh;
    private boolean containsDatabaseItselfValue;
    private boolean containsDatabaseItselfCalculated;

    @Override
    public byte getTaskTypeOrder() {
        return 8;
    }

    @NotNull
    public final Collection<ObjectPath> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public RegularIntrospectionTask(@NotNull String databaseName, @NotNull Collection<? extends ObjectPath> elementsToRefresh2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(elementsToRefresh2, (String)"elementsToRefresh");
        super(databaseName, null);
        this.elementsToRefresh = elementsToRefresh2;
    }

    public final boolean getContainsDatabaseItself() {
        if (!this.containsDatabaseItselfCalculated) {
            this.containsDatabaseItselfValue = CollectionFun.containsElements((Iterable)this.elementsToRefresh, (Function1)new Function1<ObjectPath, Boolean>(this){
                final /* synthetic */ RegularIntrospectionTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ObjectPath it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.DATABASE) && Intrinsics.areEqual((Object)it2.name, (Object)this.this$0.getDatabaseName());
                }
            });
            this.containsDatabaseItselfCalculated = true;
        }
        return this.containsDatabaseItselfValue;
    }

    @NotNull
    public String toString() {
        int n = this.elementsToRefresh.size();
        StringBuilder b2 = new StringBuilder(n * 32);
        b2.append("Regular introspect ").append(n).append(" element(s) ").append(this.getDatabaseDisplayName()).append(':');
        for (ObjectPath e2 : this.elementsToRefresh) {
            b2.append("\n\t\t+ ").append(e2.toString());
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

