/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.common.StringFun;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/introspection/Impactees;", "", "alteredObjects", "", "Lcom/intellij/database/util/ObjectPath;", "droppedObjects", "(Ljava/util/Set;Ljava/util/Set;)V", "allObjects", "getAllObjects", "()Ljava/util/Set;", "hasObjects", "", "()Z", "toString", "", "Companion", "intellij.database.core.impl"})
public final class Impactees {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Set<ObjectPath> alteredObjects;
    @JvmField
    @NotNull
    public final Set<ObjectPath> droppedObjects;
    @JvmField
    @NotNull
    public static final Impactees EMPTY = new Impactees(SetsKt.emptySet(), SetsKt.emptySet());

    public Impactees(@NotNull Set<? extends ObjectPath> alteredObjects, @NotNull Set<? extends ObjectPath> droppedObjects) {
        Intrinsics.checkNotNullParameter(alteredObjects, (String)"alteredObjects");
        Intrinsics.checkNotNullParameter(droppedObjects, (String)"droppedObjects");
        this.alteredObjects = alteredObjects;
        this.droppedObjects = droppedObjects;
    }

    @NotNull
    public final Set<ObjectPath> getAllObjects() {
        return SetsKt.plus(this.alteredObjects, (Iterable)this.droppedObjects);
    }

    @JvmName(name="hasObjects")
    public final boolean hasObjects() {
        return !((Collection)this.alteredObjects).isEmpty() || !((Collection)this.droppedObjects).isEmpty();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)this.alteredObjects).isEmpty()) {
            $this$toString_u24lambda_u240.append(this.alteredObjects.size()).append(" altered objects:");
            for (ObjectPath o2 : this.alteredObjects) {
                $this$toString_u24lambda_u240.append("\n\t+ ").append(o2);
            }
        }
        if (!((Collection)this.droppedObjects).isEmpty()) {
            StringFun.appendSuffixIfNo($this$toString_u24lambda_u240, '\n');
            $this$toString_u24lambda_u240.append(this.droppedObjects.size()).append(" dropped objects:");
            for (ObjectPath o2 : this.droppedObjects) {
                $this$toString_u24lambda_u240.append(o2);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/introspection/Impactees$Companion;", "", "()V", "EMPTY", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

