/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.util.common.NumberFun;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/introspection/FragmentIntrospectionTask;", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseName", "", "schemaName", "belongingAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "fragments", "", "Lcom/intellij/database/introspection/FamilyFragment;", "checkForDroppedObjects", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/introspection/BelongingAreaKind;Ljava/util/Collection;Z)V", "getBelongingAreaKind", "()Lcom/intellij/database/introspection/BelongingAreaKind;", "getCheckForDroppedObjects", "()Z", "getFragments", "()Ljava/util/Collection;", "namesCount", "", "getNamesCount", "()I", "getSchemaName", "()Ljava/lang/String;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "toString", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nIntrospectionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrospectionTask.kt\ncom/intellij/database/introspection/FragmentIntrospectionTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1#2:358\n*E\n"})
public final class FragmentIntrospectionTask
extends DefiniteIntrospectionTask {
    @NotNull
    private final String schemaName;
    @NotNull
    private final BelongingAreaKind belongingAreaKind;
    @NotNull
    private final Collection<FamilyFragment> fragments;
    private final boolean checkForDroppedObjects;
    private final int namesCount;

    public FragmentIntrospectionTask(@NotNull String databaseName, @NotNull String schemaName, @NotNull BelongingAreaKind belongingAreaKind, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        int n;
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Intrinsics.checkNotNullParameter((Object)((Object)belongingAreaKind), (String)"belongingAreaKind");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        super(databaseName, null);
        this.schemaName = schemaName;
        this.belongingAreaKind = belongingAreaKind;
        this.fragments = fragments2;
        this.checkForDroppedObjects = checkForDroppedObjects;
        Iterable iterable = this.fragments;
        FragmentIntrospectionTask fragmentIntrospectionTask = this;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        FamilyFragment f = (FamilyFragment)iterator.next();
        boolean bl = false;
        int n3 = f.getSize();
        while (iterator.hasNext()) {
            FamilyFragment f2 = (FamilyFragment)iterator.next();
            $i$a$-maxOf-FragmentIntrospectionTask$namesCount$1 = false;
            int n4 = f2.getSize();
            if (n3 >= n4) continue;
            n3 = n4;
        }
        fragmentIntrospectionTask.namesCount = n = n3;
    }

    @NotNull
    public final String getSchemaName() {
        return this.schemaName;
    }

    @NotNull
    public final BelongingAreaKind getBelongingAreaKind() {
        return this.belongingAreaKind;
    }

    @NotNull
    public final Collection<FamilyFragment> getFragments() {
        return this.fragments;
    }

    public final boolean getCheckForDroppedObjects() {
        return this.checkForDroppedObjects;
    }

    @Override
    public byte getTaskTypeOrder() {
        return 12;
    }

    public final int getNamesCount() {
        return this.namesCount;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.fragments.size();
        $this$toString_u24lambda_u241.append("Introspect ");
        $this$toString_u24lambda_u241.append(NumberFun.toStringWithUnits(n, "fragment"));
        $this$toString_u24lambda_u241.append(" with ");
        $this$toString_u24lambda_u241.append(NumberFun.toStringWithUnits(this.namesCount, "name"));
        switch (WhenMappings.$EnumSwitchMapping$0[this.belongingAreaKind.ordinal()]) {
            case 1: {
                $this$toString_u24lambda_u241.append(" in the ROOT (using database " + this.getDatabaseName() + ")");
                break;
            }
            case 2: {
                $this$toString_u24lambda_u241.append(" in the DATABASE " + this.getDatabaseName());
                break;
            }
            case 3: {
                $this$toString_u24lambda_u241.append(" in the SCHEMA name " + this.getDatabaseName() + "/" + this.schemaName);
            }
        }
        $this$toString_u24lambda_u241.append(": ");
        for (FamilyFragment f : this.fragments) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u241.append('\n'), (String)"append(...)");
            $this$toString_u24lambda_u241.append("\t- fragment of ");
            int n3 = f.getNames().size();
            String string = f.getKind().code();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code(...)");
            $this$toString_u24lambda_u241.append(NumberFun.toStringWithUnits(n3, string));
            $this$toString_u24lambda_u241.append(": ");
            CollectionsKt.joinTo$default((Iterable)f.getNames(), (Appendable)$this$toString_u24lambda_u241, null, null, null, (int)0, null, null, (int)126, null);
        }
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u241.append("\twith checking for dropped objects: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = stringBuilder2;
        StringBuilder stringBuilder4 = stringBuilder3.append(this.checkForDroppedObjects ? "yes" : "no");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BelongingAreaKind.values().length];
            try {
                nArray[BelongingAreaKind.A_ROOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BelongingAreaKind.A_DATABASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BelongingAreaKind.A_SCHEMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

