/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.diff.ObjectWrapper;
import com.intellij.database.diff.TableDiffBuilder;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TableDiffAdapter {
    private static ObjectWrapper.HasherAndComparator<Object> getValueHasher(final @NotNull DataGrid grid) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(0);
        }
        final GridCellEditorHelper editorHelper = GridCellEditorHelper.get((CoreGrid)grid);
        return new ObjectWrapper.HasherAndComparator<Object>(){

            @Override
            public boolean equals(Object a, Object b2) {
                return editorHelper.areValuesEqual(a, b2, (CoreGrid)grid);
            }

            @Override
            public int hash(Object v2) {
                return DbImplUtil.valueHashCode(v2);
            }
        };
    }

    public static TableDiffBuilder.Data adapt(@NotNull TableDiffEditor.DiffTablePanel grid1, @NotNull Iterable<ModelIndex<GridRow>> skippedRows1, @NotNull Iterable<ModelIndex<GridColumn>> skippedCols1, @NotNull TableDiffEditor.DiffTablePanel grid2, @NotNull Iterable<ModelIndex<GridRow>> skippedRows2, @NotNull Iterable<ModelIndex<GridColumn>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator, @NotNull Couple<? extends List<Integer>> skippedCols, @NotNull Couple<? extends List<Integer>> skippedRows) {
        if (grid1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(1);
        }
        if (skippedRows1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(2);
        }
        if (skippedCols1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(3);
        }
        if (grid2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(4);
        }
        if (skippedRows2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(5);
        }
        if (skippedCols2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            TableDiffAdapter.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            TableDiffAdapter.$$$reportNull$$$0(8);
        }
        if (skippedCols == null) {
            TableDiffAdapter.$$$reportNull$$$0(9);
        }
        if (skippedRows == null) {
            TableDiffAdapter.$$$reportNull$$$0(10);
        }
        TableDiffBuilder.TableData data1 = TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, (List)skippedRows.first, (List)skippedCols.first);
        TableDiffBuilder.TableData data2 = TableDiffAdapter.adapt(grid2, skippedRows2, skippedCols2, (List)skippedRows.second, (List)skippedCols.second);
        return new TableDiffBuilder.Data((Couple<TableDiffBuilder.TableData>)Couple.of((Object)data1, (Object)data2), settings, indicator);
    }

    @NotNull
    private static TableDiffBuilder.TableData adapt(@NotNull TableDiffEditor.DiffTablePanel grid, @NotNull Iterable<ModelIndex<GridRow>> skippedRows, @NotNull Iterable<ModelIndex<GridColumn>> skippedCols, List<Integer> skippedVisRows, List<Integer> skippedVisCols) {
        Object row;
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(11);
        }
        if (skippedRows == null) {
            TableDiffAdapter.$$$reportNull$$$0(12);
        }
        if (skippedCols == null) {
            TableDiffAdapter.$$$reportNull$$$0(13);
        }
        ArrayList<Object> columns2 = new ArrayList<Object>();
        ArrayList<Object> values2 = new ArrayList<Object>();
        List cols2 = TableDiffAdapter.difference((DataGrid)grid, grid.getVisibleColumns().asIterable(), skippedCols);
        List rows = TableDiffAdapter.difference((DataGrid)grid, grid.getVisibleRows().asIterable(), skippedRows);
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ObjectWrapper.HasherAndComparator<Object> hasher = TableDiffAdapter.getValueHasher((DataGrid)grid);
        if (!grid.getResultView().isTransposed()) {
            for (ModelIndex col : cols2) {
                columns2.add((ColumnDescriptor)model2.getColumn(col));
            }
        } else {
            for (ModelIndex r : rows) {
                row = (GridRow)model2.getRow(r);
                columns2.add(new DataConsumer.Column(row == null ? 0 : row.getRowNum(), "", 1111, "", Object.class.getName()));
            }
        }
        for (JBIterable band : TableDiffAdapter.iterateCells(rows, cols2, !grid.getResultView().isTransposed())) {
            row = new ArrayList();
            for (Pair cell : band) {
                row.add(new ObjectWrapper<Object>(model2.getValueAt((ModelIndex)cell.first, (ModelIndex)cell.second), hasher));
            }
            values2.add(row);
        }
        TableDiffAdapter.generateSkipped((DataGrid)grid, rows, model2.getRowCount(), !grid.getResultView().isTransposed() ? skippedVisRows : skippedVisCols);
        TableDiffAdapter.generateSkipped((DataGrid)grid, cols2, model2.getColumnCount(), grid.getResultView().isTransposed() ? skippedVisRows : skippedVisCols);
        return new TableDiffBuilder.TableData(columns2, values2);
    }

    private static <T> void generateSkipped(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> ids, int count, @NotNull List<Integer> skipped) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(14);
        }
        if (ids == null) {
            TableDiffAdapter.$$$reportNull$$$0(15);
        }
        if (skipped == null) {
            TableDiffAdapter.$$$reportNull$$$0(16);
        }
        IntOpenHashSet existing = new IntOpenHashSet();
        for (ModelIndex<T> index2 : ids) {
            existing.add(index2.toView((CoreGrid)grid).asInteger());
        }
        for (int i2 = 0; i2 < count; ++i2) {
            if (existing.contains(i2)) continue;
            skipped.add(i2);
        }
    }

    private static JBIterable<JBIterable<Pair<ModelIndex<GridRow>, ModelIndex<GridColumn>>>> iterateCells(Iterable<ModelIndex<GridRow>> rows, Iterable<ModelIndex<GridColumn>> cols2, boolean rowWise) {
        if (rowWise) {
            return JBIterable.from(rows).transform(row -> TableDiffAdapter.iterateRowCells((ModelIndex<GridRow>)row, cols2));
        }
        return JBIterable.from(cols2).transform(col -> TableDiffAdapter.iterateColumnCells((ModelIndex<GridColumn>)col, rows));
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<GridRow>, ModelIndex<GridColumn>>> iterateColumnCells(ModelIndex<GridColumn> col, Iterable<ModelIndex<GridRow>> rows) {
        JBIterable jBIterable = JBIterable.from(rows).transform(row -> Pair.create((Object)row, (Object)col));
        if (jBIterable == null) {
            TableDiffAdapter.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<Pair<ModelIndex<GridRow>, ModelIndex<GridColumn>>> iterateRowCells(ModelIndex<GridRow> row, Iterable<ModelIndex<GridColumn>> cols2) {
        JBIterable jBIterable = JBIterable.from(cols2).transform(col -> Pair.create((Object)row, (Object)col));
        if (jBIterable == null) {
            TableDiffAdapter.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    private static <T> List<ModelIndex<T>> difference(@NotNull DataGrid grid, @NotNull Iterable<ModelIndex<T>> visible, @NotNull Iterable<ModelIndex<T>> skipped) {
        if (grid == null) {
            TableDiffAdapter.$$$reportNull$$$0(19);
        }
        if (visible == null) {
            TableDiffAdapter.$$$reportNull$$$0(20);
        }
        if (skipped == null) {
            TableDiffAdapter.$$$reportNull$$$0(21);
        }
        ArrayList<ModelIndex<T>> res2 = new ArrayList<ModelIndex<T>>();
        IntOpenHashSet sset = new IntOpenHashSet();
        for (ModelIndex<T> index2 : skipped) {
            sset.add(index2.asInteger());
        }
        for (ModelIndex<T> index2 : visible) {
            if (sset.contains(index2.asInteger())) continue;
            res2.add(index2);
        }
        res2.sort(Comparator.comparingInt(o2 -> o2.toView((CoreGrid)grid).asInteger()));
        return res2;
    }

    public static TableDiffBuilder.TableDiffResult process(@NotNull TableDiffEditor.DiffTablePanel grid1, @NotNull Iterable<ModelIndex<GridRow>> skippedRows1, @NotNull Iterable<ModelIndex<GridColumn>> skippedCols1, @NotNull TableDiffEditor.DiffTablePanel grid2, @NotNull Iterable<ModelIndex<GridRow>> skippedRows2, @NotNull Iterable<ModelIndex<GridColumn>> skippedCols2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator) {
        if (grid1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(22);
        }
        if (skippedRows1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(23);
        }
        if (skippedCols1 == null) {
            TableDiffAdapter.$$$reportNull$$$0(24);
        }
        if (grid2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(25);
        }
        if (skippedRows2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(26);
        }
        if (skippedCols2 == null) {
            TableDiffAdapter.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            TableDiffAdapter.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            TableDiffAdapter.$$$reportNull$$$0(29);
        }
        Couple skippedCols = Couple.of((Object)new IntArrayList(), (Object)new IntArrayList());
        Couple skippedRows = Couple.of((Object)new IntArrayList(), (Object)new IntArrayList());
        TableDiffBuilder.TableDiffResult subRes = TableDiffBuilder.process(TableDiffAdapter.adapt(grid1, skippedRows1, skippedCols1, grid2, skippedRows2, skippedCols2, settings, indicator, (Couple<? extends List<Integer>>)skippedCols, (Couple<? extends List<Integer>>)skippedRows));
        return subRes.recover((Couple<? extends List<Integer>>)skippedCols, (Couple<? extends List<Integer>>)skippedRows);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid1";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows1";
                break;
            }
            case 3: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols1";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid2";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows2";
                break;
            }
            case 6: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols2";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCols";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRows";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipped";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffAdapter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffAdapter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateColumnCells";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateRowCells";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValueHasher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adapt";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateSkipped";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18 -> new IllegalStateException(string);
        };
    }
}

