/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.sql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.sqlite.sql.SqliteTokens;
import com.intellij.database.dialects.sqlite.sql.SqliteTypes;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteDialect
extends SqlLanguageDialectBase {
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    private SqliteDialect() {
        super("SQLite");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(SqliteTokens.class);
        if (tokensHelper == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SQLITE;
        if (dbms == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "json", "json", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        if (!strict && type2 == ObjectKind.PACKAGE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            PsiElement p2 = place == null ? null : place.getParent();
            PsiElement pp = p2 == null ? null : p2.getParent();
            return place == null || pp instanceof SqlFunctionCallTableExpressionImpl;
        }
        return type2 == ObjectKind.VIRTUAL_TABLE && expectedTypes.contains(ObjectKind.TABLE) || !strict && type2 == ObjectKind.PACKAGE && expectedTypes.contains(ObjectKind.TABLE);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_SQLITE_MASTER.name, resolve2) && !processor2.executeTarget((DasSymbol)LazyData.RE_SQLITE_MASTER, (DasType)SqlTableTypeBase.EMPTY_TABLE, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (processor2.isExpected(ObjectKind.COLUMN)) {
            DasTypeSystemBase typeSystem = this.getTypeSystem();
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_OID, typeSystem.getIntType(), name2, place, resolve2, processor2, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_ROWID, typeSystem.getIntType(), name2, place, resolve2, processor2, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_ROWID2, typeSystem.getIntType(), name2, place, resolve2, processor2, true, false)) {
                return false;
            }
        }
        if (processor2.isExpected(ObjectKind.COLLATION) && place instanceof SqlReferenceExpression) {
            for (ReservedEntity function2 : LazyData.COLLATE_FUNCTIONS.values()) {
                if (SqliteDialect.processReservedEntitiesWithTypeSimple(function2, DasTypeSystemBase.REFERENCE, name2, place, resolve2, processor2, false, false)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.processExcludedRefInInsertConflict(name2, place, resolve2, processor2, LazyData.RE_EXCLUDED)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type2) {
        T types2 = super.getParentDbTypes(result2, type2);
        if (type2 == ObjectKind.ROUTINE) {
            types2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        return types2;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type2) {
        return type2 != ObjectKind.PACKAGE && super.shallResolve(o2, type2);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource2, ObjectName @Nullable [] dsNames) {
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, TreePatternUtils.create(Arrays.asList(ObjectName.plain("main"), ObjectName.plain("temp")), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern2) {
        if (pattern2 == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern2, dsNames, Arrays.asList(ObjectName.plain("main"), ObjectName.plain("temp")), true, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        return treePattern;
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/sql/SqliteDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/sql/SqliteDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqliteTypes.SQLITE_MATCH, SqliteTypes.SQLITE_REGEXP, SqliteTypes.SQLITE_GLOB, SqlTokens.SQL_OP_EQEQ, SqliteTypes.SQLITE_ISNULL, SqliteTypes.SQLITE_NOTNULL);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQLITE_DOT_END})});
        static final Map<String, ReservedEntity> COLLATE_FUNCTIONS = SqlDialectImplUtilCore.buildEntities(Dbms.SQLITE, ObjectKind.COLLATION, "nocase", "rtrim", "binary");
        static final ReservedEntity RE_SQLITE_MASTER = new ReservedEntity(Dbms.SQLITE, "sqlite_master", ObjectKind.TABLE);
        static final ReservedEntity RE_OID = new ReservedEntity(Dbms.SQLITE, "OID", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWID = new ReservedEntity(Dbms.SQLITE, "ROWID", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWID2 = new ReservedEntity(Dbms.SQLITE, "_ROWID_", ObjectKind.COLUMN);
        static final ReservedEntity RE_EXCLUDED = new ReservedEntity(Dbms.POSTGRES, "excluded", ObjectKind.TABLE);

        LazyData() {
        }
    }
}

