/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SFlakeRawPlanData
extends RawPlanData {
    MetaNode root;

    @Override
    public void load(@NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, boolean run2) {
        if (connection2 == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(1);
        }
        this.root = null;
        Int2ObjectOpenHashMap objects2 = new Int2ObjectOpenHashMap();
        SFlakeRawPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>((Int2ObjectMap)objects2){
            final /* synthetic */ Int2ObjectMap val$objects;
            {
                this.val$objects = int2ObjectMap;
            }

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                s2.noisy().execute("EXPLAIN USING TABULAR " + statement2, SFlakeRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    while (rs.next()) {
                        Object id = rs.getObject(2);
                        if (id == null) continue;
                        String parents2 = rs.getString(3);
                        int[] parentIds = SFlakeRawPlanData.toIntArray(parents2);
                        MetaNode node2 = new MetaNode(((Number)id).intValue(), parentIds, rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), (Number)rs.getObject(8), (Number)rs.getObject(9), (Number)rs.getObject(10));
                        this.val$objects.put(node2.id, (Object)node2);
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
        this.root = SFlakeRawPlanData.finish((Int2ObjectMap<MetaNode>)objects2);
    }

    private static int[] toIntArray(String s2) {
        if (s2 == null || s2.length() < 2) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        IntArrayList res2 = new IntArrayList();
        int idx = 1;
        while (idx != -1) {
            int nx = s2.indexOf(44, idx);
            String item = s2.substring(idx, nx == -1 ? s2.length() - 1 : nx).trim();
            if (!item.isEmpty()) {
                res2.add(Integer.parseInt(item));
            }
            idx = nx == -1 ? -1 : nx + 1;
        }
        return res2.toIntArray();
    }

    private static MetaNode finish(Int2ObjectMap<MetaNode> objects2) {
        objects2.values().forEach(n -> {
            for (int parentId : n.parents) {
                if (parentId == -1) continue;
                MetaNode parent2 = (MetaNode)objects2.get(parentId);
                if (parent2.children == null) {
                    parent2.children = new ArrayList<MetaNode>();
                }
                parent2.children.add((MetaNode)n);
            }
        });
        MetaNode root2 = (MetaNode)objects2.get(0);
        for (MetaNode node2 : ((JBTreeTraverser)JBTreeTraverser.from(n -> n.children).withRoot((Object)root2)).traverse()) {
            if (node2.children == null) continue;
            node2.children.sort(Comparator.comparingInt(n -> n.id));
        }
        return root2;
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(2);
        }
        Int2ObjectOpenHashMap objects2 = new Int2ObjectOpenHashMap();
        for (String line : dump2.split("\\r?\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 9);
            MetaNode node2 = new MetaNode(Integer.parseInt((String)split.get(0)), ArrayUtil.toIntArray((Collection)ContainerUtil.mapNotNull((Object[])((String)split.get(1)).split(","), s2 -> s2.isEmpty() ? null : Integer.valueOf(Integer.parseInt(s2)))), (String)split.get(2), (String)split.get(3), (String)split.get(4), (String)split.get(5), "null".equals(split.get(6)) ? null : Integer.valueOf((String)split.get(6)), "null".equals(split.get(7)) ? null : Integer.valueOf((String)split.get(7)), "null".equals(split.get(8)) ? null : Integer.valueOf((String)split.get(8)));
            objects2.put(node2.id, (Object)node2);
        }
        this.root = SFlakeRawPlanData.finish((Int2ObjectMap<MetaNode>)objects2);
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (MetaNode n3 : ((JBTreeTraverser)JBTreeTraverser.from(n -> n.children).withRoot((Object)this.root)).traverse().unique()) {
            sb.append(n3.id).append("\t").append(StringUtil.join((int[])n3.parents, (String)",")).append("\t").append(n3.tp).append("\t").append(n3.objects).append("\t").append(n3.alias).append("\t").append(n3.expressions).append("\t").append(n3.partitionsTotal).append("\t").append(n3.partitionsAssigned).append("\t").append(n3.bytesAssigned).append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/snowflake/plan/SFlakeRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MetaNode {
        final int id;
        final int[] parents;
        final String tp;
        final String objects;
        final String alias;
        final String expressions;
        final Number partitionsTotal;
        final Number partitionsAssigned;
        final Number bytesAssigned;
        List<MetaNode> children;

        public MetaNode(int id, int[] parents2, String tp, String objects2, String alias, String expressions2, Number partitionsTotal, Number partitionsAssigned, Number bytesAssigned) {
            this.id = id;
            this.parents = parents2;
            this.tp = tp;
            this.objects = objects2;
            this.alias = alias;
            this.expressions = expressions2;
            this.partitionsTotal = partitionsTotal;
            this.partitionsAssigned = partitionsAssigned;
            this.bytesAssigned = bytesAssigned;
        }
    }
}

