/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.postgresbase.types.PgBaseTypeSystem;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/postgresbase/types/Pg83TypeSystem;", "Lcom/intellij/database/dialects/postgresbase/types/PgBaseTypeSystem;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "createSequenceType", "Lcom/intellij/sql/psi/SqlTableType;", "element", "Lcom/intellij/psi/PsiElement;", "obj", "getDefinitionType", "Lcom/intellij/database/types/DasType;", "definition", "Lcom/intellij/sql/psi/SqlTypedDefinition;", "usage", "intellij.database.dialects.postgresbase"})
public final class Pg83TypeSystem
extends PgBaseTypeSystem {
    public Pg83TypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public DasType getDefinitionType(@NotNull SqlTypedDefinition definition2, @Nullable PsiElement usage) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        PsiElement psiElement = usage;
        int usageOffset = psiElement != null ? psiElement.getTextOffset() : Integer.MAX_VALUE;
        DasType dasType = definition2.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (DasTypeUtilsKt.is(dasType2, DasTypeCategory.RECORD) && PgDialectBase.inPl((PsiElement)definition2)) {
            SqlBlockStatementImpl block = (SqlBlockStatementImpl)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)definition2), SqlBlockStatementImpl.class);
            Query query = block == null ? ReferencesSearch.search((PsiElement)((PsiElement)definition2)) : ReferencesSearch.search((PsiElement)((PsiElement)definition2), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)block)));
            Intrinsics.checkNotNull((Object)query);
            Query search = query;
            Ref.ObjectRef targetUsage = new Ref.ObjectRef();
            search.forEach(arg_0 -> Pg83TypeSystem.getDefinitionType$lambda$0(targetUsage, usageOffset, arg_0));
            PsiElement foundUsage = (PsiElement)targetUsage.element;
            if (foundUsage instanceof SqlSelectIntoClause) {
                DasType type2;
                SqlReturningClause returningClause;
                SqlQueryExpression query2;
                SqlQueryExpression sqlQueryExpression = query2 = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)foundUsage, SqlQueryExpression.class);
                if (sqlQueryExpression != null) {
                    DasType dasType3 = sqlQueryExpression.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
                    return dasType3;
                }
                SqlReturningClause sqlReturningClause = returningClause = (SqlReturningClause)PsiTreeUtil.getParentOfType((PsiElement)foundUsage, SqlReturningClause.class);
                DasType dasType4 = type2 = (DasType)(sqlReturningClause != null ? sqlReturningClause.getDasType() : null);
                if (dasType4 != null) {
                    return dasType4;
                }
            } else if (foundUsage instanceof SqlBinaryExpression) {
                SqlExpression right;
                SqlExpression sqlExpression = right = ((SqlBinaryExpression)foundUsage).getROperand();
                if (sqlExpression != null) {
                    DasType dasType5 = sqlExpression.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType5, (String)"getDasType(...)");
                    return dasType5;
                }
            } else if (foundUsage instanceof SqlSetAssignment) {
                SqlExpression right;
                SqlElement sqlElement = ((SqlSetAssignment)foundUsage).getRValue();
                SqlExpression sqlExpression = right = sqlElement instanceof SqlExpression ? (SqlExpression)sqlElement : null;
                if (right != null) {
                    DasType dasType6 = right.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType6, (String)"getDasType(...)");
                    return dasType6;
                }
            }
        }
        return super.getDefinitionType(definition2, usage);
    }

    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element2, @Nullable PsiElement obj2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Object[] objectArray = new SqlImplUtil.Column[]{SqlDialectImplUtilCore.col(element2, obj2, "sequence_name", this.getStringType()), SqlDialectImplUtilCore.col(element2, obj2, "last_value", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "start_value", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "increment_by", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "max_value", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "min_value", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "cache_value", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "long_cnt", this.getIntType()), SqlDialectImplUtilCore.col(element2, obj2, "is_cycled", this.getBooleanType()), SqlDialectImplUtilCore.col(element2, obj2, "is_called", this.getBooleanType())};
        SqlTableType sqlTableType = SqlImplUtil.createType(CollectionsKt.listOf((Object[])objectArray), element2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
        return sqlTableType;
    }

    private static final boolean getDefinitionType$lambda$0(Ref.ObjectRef $targetUsage, int $usageOffset, PsiReference ref2) {
        Intrinsics.checkNotNullParameter((Object)$targetUsage, (String)"$targetUsage");
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        PsiElement psiElement = ref2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element2 = psiElement;
        PsiElement parent2 = element2.getParent();
        if (parent2 instanceof SqlSelectIntoClause || parent2 instanceof SqlSetAssignment && ((SqlSetAssignment)parent2).getLValue() == element2) {
            $targetUsage.element = parent2;
        } else if (parent2 instanceof SqlBinaryExpression) {
            SqlExpression sqlExpression = ((SqlBinaryExpression)parent2).getLOperand();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
            SqlExpression operand = sqlExpression;
            IElementType sign = ((SqlBinaryExpression)parent2).getOpSign();
            if (operand == element2 && (sign == SqlCommonTokens.SQL_OP_ASSIGN || sign == SqlCommonTokens.SQL_OP_EQ)) {
                $targetUsage.element = parent2;
            }
        }
        int offset = element2.getTextOffset();
        return offset < $usageOffset;
    }
}

