/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.database.model.DasRoutine;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PgRoutineKind {
    PG_FUNCTION('F', DasRoutine.Kind.FUNCTION, false),
    PG_PROCEDURE('P', DasRoutine.Kind.PROCEDURE, false),
    PG_TRIGGER('T', DasRoutine.Kind.FUNCTION, true),
    PG_EVENT_TRIGGER('V', DasRoutine.Kind.FUNCTION, true);

    public final char code;
    public final DasRoutine.Kind basicKind;
    public final boolean isTrigger;

    private PgRoutineKind(char code, DasRoutine.Kind basicKind, boolean isTrigger) {
        this.code = code;
        this.basicKind = basicKind;
        this.isTrigger = isTrigger;
    }

    @Nullable
    public static PgRoutineKind of(char code) {
        return switch (code) {
            case 'F', 'f' -> PG_FUNCTION;
            case 'P', 'p' -> PG_PROCEDURE;
            case 'T', 't' -> PG_TRIGGER;
            case 'V', 'v' -> PG_EVENT_TRIGGER;
            default -> null;
        };
    }

    @NotNull
    public String exportValue() {
        String string = Character.toString(this.code);
        if (string == null) {
            PgRoutineKind.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PgRoutineKind importValue(@NotNull String str) {
        String s2;
        if (str == null) {
            PgRoutineKind.$$$reportNull$$$0(1);
        }
        if ((s2 = str.trim().toLowerCase(Locale.ROOT)).length() >= 4 && s2.startsWith("pg")) {
            s2 = s2.substring(3);
        }
        if (s2.length() == 1) {
            return PgRoutineKind.of(str.charAt(0));
        }
        if (s2.contains("event")) {
            return PG_EVENT_TRIGGER;
        }
        if (s2.contains("trigger")) {
            return PG_TRIGGER;
        }
        if (s2.contains("pro")) {
            return PG_PROCEDURE;
        }
        if (s2.contains("fun")) {
            return PG_FUNCTION;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/model/properties/PgRoutineKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "exportValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/model/properties/PgRoutineKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

