/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OraUtils {
    OraUtils() {
    }

    @Nullable
    static DatabaseConnection getConnection(DataRequest.Context context) {
        if (context.producer instanceof JdbcEngine) {
            return ((JdbcEngine)context.producer).getCurrentConnectionIfReady();
        }
        return null;
    }

    @NotNull
    static List<String> queryForStrings(@NotNull DatabaseConnection connection2, @NotNull String query, int @NotNull [] placeholders, String ... params2) throws SQLException {
        if (connection2 == null) {
            OraUtils.$$$reportNull$$$0(0);
        }
        if (query == null) {
            OraUtils.$$$reportNull$$$0(1);
        }
        if (placeholders == null) {
            OraUtils.$$$reportNull$$$0(2);
        }
        if (params2 == null) {
            OraUtils.$$$reportNull$$$0(3);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StatementParameters parameters2 = new StatementParameters().placeholdersOffsets(placeholders);
        for (String param : params2) {
            parameters2 = parameters2.text(param);
        }
        SmartStatements.poweredBy(connection2).parameterized(Configuration.sourced(SmartStatementSource.SYSTEM)).noisy().execute(parameters2.asData(query), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rset -> {
            while (rset.next()) {
                result2.add(rset.getString(1));
            }
        })));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            OraUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "queryForStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryForStrings";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

