/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.oracle.ObjectInfo;
import com.intellij.database.dialects.oracle.OraStatementAnalysis;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0014"}, d2={"catalogName", "", "Lcom/intellij/sql/psi/SqlDefinition;", "getCatalogName", "(Lcom/intellij/sql/psi/SqlDefinition;)Ljava/lang/String;", "Lcom/intellij/sql/psi/SqlNameElement;", "(Lcom/intellij/sql/psi/SqlNameElement;)Ljava/lang/String;", "getOracleTypeLikeConditionFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "parseAffectedObjectInfo", "Lcom/intellij/database/dialects/oracle/ObjectInfo;", "text", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "parseStatementForAffectedObjectInfo", "element", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.dialects.oracle"})
@JvmName(name="OraStatementAnalysis")
@SourceDebugExtension(value={"SMAP\nOraStatementAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraStatementAnalysis.kt\ncom/intellij/database/dialects/oracle/OraStatementAnalysis\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n179#2,2:100\n*S KotlinDebug\n*F\n+ 1 OraStatementAnalysis.kt\ncom/intellij/database/dialects/oracle/OraStatementAnalysis\n*L\n29#1:100,2\n*E\n"})
public final class OraStatementAnalysis {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ObjectInfo parseAffectedObjectInfo(@NotNull String text2, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Object v3;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
            SqlPsiFacade psiFacade2 = sqlPsiFacade;
            SqlFile sqlFile = psiFacade2.createROFile(dialect, (CharSequence)text2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"createROFile(...)");
            SqlFile psiFile = sqlFile;
            List list = psiFile.getDdl();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDdl(...)");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)parseAffectedObjectInfo.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ObjectInfo it2 = (ObjectInfo)element$iv;
                boolean bl = false;
                if (!(it2 != null)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private static final ObjectInfo parseStatementForAffectedObjectInfo(SqlElement element2) {
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
        ObjectKind kind = objectKind;
        String schemaName = null;
        String objectName = null;
        SqlElement sqlElement = element2;
        if (sqlElement instanceof SqlCreateStatement) {
            SqlExpression q2;
            ObjectKind objectKind2 = ((SqlCreateStatement)element2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getKind(...)");
            kind = objectKind2;
            objectName = OraStatementAnalysis.getCatalogName((SqlDefinition)element2);
            SqlNameElement sqlNameElement = ((SqlCreateStatement)element2).getNameElement();
            SqlReferenceExpression sqlReferenceExpression = sqlNameElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlNameElement : null;
            Object object = q2 = sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY)) {
                sqlNameElement = q2;
                SqlReferenceExpression sqlReferenceExpression2 = sqlNameElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlNameElement : null;
                q2 = sqlReferenceExpression2 != null ? sqlReferenceExpression2.getQualifierExpression() : null;
            }
            SqlNameElement sqlNameElement2 = (sqlNameElement = q2) instanceof SqlNameElement ? sqlNameElement : null;
            schemaName = sqlNameElement2 != null ? OraStatementAnalysis.getCatalogName(sqlNameElement2) : null;
        } else if (sqlElement instanceof SqlAlterStatement) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlAlterStatement)element2).getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return null;
            }
            SqlReferenceExpression ref2 = sqlReferenceExpression;
            ObjectKind objectKind3 = ref2.getReferenceElementType().getTargetKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getTargetKind(...)");
            kind = objectKind3;
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"VIEW");
                kind = objectKind4;
            }
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PACKAGE)) {
                SqlAlterInstruction instruction2;
                SqlAlterInstruction[] sqlAlterInstructionArray = ((SqlAlterStatement)element2).getAlterInstructions();
                Intrinsics.checkNotNullExpressionValue((Object)sqlAlterInstructionArray, (String)"getAlterInstructions(...)");
                SqlAlterInstruction sqlAlterInstruction = instruction2 = (SqlAlterInstruction)ArraysKt.firstOrNull((Object[])sqlAlterInstructionArray);
                if (Intrinsics.areEqual((Object)(sqlAlterInstruction != null ? sqlAlterInstruction.getInstructionType() : null), (Object)SqlCommonKeywords.SQL_COMPILE)) {
                    SqlAlterInstruction sqlAlterInstruction2 = instruction2;
                    Intrinsics.checkNotNull((Object)sqlAlterInstruction2);
                    if (sqlAlterInstruction2.getNode().findChildByType((IElementType)SqlCommonKeywords.SQL_BODY) != null) {
                        ObjectKind objectKind5 = ObjectKind.BODY;
                        Intrinsics.checkNotNullExpressionValue((Object)objectKind5, (String)"BODY");
                        kind = objectKind5;
                    }
                }
            }
            objectName = OraStatementAnalysis.getCatalogName((SqlNameElement)ref2);
            SqlExpression q3 = ref2.getQualifierExpression();
            SqlNameElement sqlNameElement = q3 instanceof SqlNameElement ? (SqlNameElement)q3 : null;
            schemaName = sqlNameElement != null ? OraStatementAnalysis.getCatalogName(sqlNameElement) : null;
        }
        return objectName != null ? new ObjectInfo(kind, schemaName, objectName) : null;
    }

    private static final String getCatalogName(SqlDefinition $this$catalogName) {
        SqlNameElement sqlNameElement = $this$catalogName.getNameElement();
        return sqlNameElement != null ? OraStatementAnalysis.getCatalogName(sqlNameElement) : null;
    }

    private static final String getCatalogName(SqlNameElement $this$catalogName) {
        String string = $this$catalogName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        if (((CharSequence)name2).length() == 0) {
            return null;
        }
        if ($this$catalogName.isQuotedIdentifier()) {
            name2 = StringsKt.replace$default((String)name2, (String)"\"\"", (String)"\"", (boolean)false, (int)4, null);
        } else {
            String string2 = StringUtil.toUpperCase((String)name2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            name2 = string2;
        }
        return name2;
    }

    @NotNull
    public static final String getOracleTypeLikeConditionFor(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? "like '%VIEW'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) ? "like '%BODY'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE) ? "= 'TYPE'" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? "in ('PROCEDURE','FUNCTION')" : "= '" + kind.name() + "'")))));
    }

    public static final /* synthetic */ ObjectInfo access$parseStatementForAffectedObjectInfo(SqlElement element2) {
        return OraStatementAnalysis.parseStatementForAffectedObjectInfo(element2);
    }
}

