/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J.\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J&\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020#H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "DATETIME_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DATE_FORMAT", "DATE_PARSER", "Lcom/intellij/database/run/ui/grid/editors/Formatter;", "getDATE_PARSER", "()Lcom/intellij/database/run/ui/grid/editors/Formatter;", "DATE_PARSER$delegate", "Lkotlin/Lazy;", "formatsCache", "Lcom/intellij/database/run/ui/grid/editors/FormatsCache;", "formatterCreator", "Lcom/intellij/database/extractors/DatabaseFormatterCreator;", "supportsInOperator", "", "getSupportsInOperator", "()Z", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "version", "Lcom/intellij/database/util/Version;", "alias", "", "ftsPredicate", "columnRef", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "getFtsIndextype", "Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "isDateLiteral", "v", "FtsIndextype", "intellij.database.dialects.oracle"})
public final class OraPredicatesHelper
extends BasePredicatesHelper {
    private final DateTimeFormatter DATE_FORMAT;
    private final DateTimeFormatter DATETIME_FORMAT;
    @NotNull
    private final DatabaseFormatterCreator formatterCreator;
    @NotNull
    private final FormatsCache formatsCache;
    @NotNull
    private final Lazy DATE_PARSER$delegate;

    public OraPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.DATE_FORMAT = FormatterCreator.appendDate((DateTimeFormatterBuilder)new DateTimeFormatterBuilder()).toFormatter(Locale.US);
        this.DATETIME_FORMAT = FormatterCreator.appendTime((DateTimeFormatterBuilder)FormatterCreator.appendDate((DateTimeFormatterBuilder)new DateTimeFormatterBuilder()).appendPattern(" ")).toFormatter(Locale.US);
        this.formatterCreator = new DatabaseFormatterCreator(dbms);
        this.formatsCache = new FormatsCache();
        this.DATE_PARSER$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Formatter>(this){
            final /* synthetic */ OraPredicatesHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Formatter invoke() {
                return (Formatter)OraPredicatesHelper.access$getFormatterCreator$p(this.this$0).create(FormatterCreator.getEraTimestampKey(null, null, (FormatsCache)OraPredicatesHelper.access$getFormatsCache$p(this.this$0)));
            }
        }));
    }

    private final Formatter getDATE_PARSER() {
        Lazy lazy = this.DATE_PARSER$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Formatter)object;
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Domain domain = this.getDomain(column2, value2, version);
        if (Intrinsics.areEqual((Object)(domain != null ? domain.simpleName() : null), (Object)"date") && value2 instanceof StringPredicateValue) {
            try {
                if (this.isDateLiteral(((Object)StringsKt.trim((CharSequence)((StringPredicateValue)value2).getStr())).toString())) {
                    return super.equalsPredicate(column2, new StringPredicateValue(((Object)StringsKt.trim((CharSequence)((StringPredicateValue)value2).getStr())).toString(), false, 2, null), op, false, version, alias);
                }
                Object date = this.getDATE_PARSER().parse(StringUtil.unquoteString((String)((StringPredicateValue)value2).getStr()));
                if (date instanceof Date) {
                    LocalDateTime localDateTime = DataGridFormattersUtilCore.fromDateToLocalDateTime((Date)((Date)date), (FormatsCache)this.formatsCache, (FormatterCreator)this.formatterCreator, null);
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"fromDateToLocalDateTime(...)");
                    LocalDateTime localDateTime2 = localDateTime;
                    return DataGridFormattersUtilCore.isEmptyTime((TemporalAccessor)localDateTime2) ? super.equalsPredicate(column2, new StringPredicateValue("DATE '" + this.DATE_FORMAT.format(localDateTime2) + "'", false, 2, null), op, false, version, alias) : super.equalsPredicate(column2, new StringPredicateValue("TIMESTAMP '" + this.DATETIME_FORMAT.format(localDateTime2) + "'", false, 2, null), op, false, version, alias);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return super.equalsPredicate(column2, value2, op, quote, version, alias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDateLiteral(String v2) {
        if ((StringsKt.startsWith((String)v2, (String)"TO_DATE", (boolean)true) || StringsKt.startsWith((String)v2, (String)"TO_TIMESTAMP", (boolean)true)) && StringsKt.contains$default((CharSequence)v2, (CharSequence)"(", (boolean)false, (int)2, null)) {
            if (StringsKt.endsWith$default((String)v2, (String)")", (boolean)false, (int)2, null)) return true;
        }
        if (!StringsKt.startsWith((String)v2, (String)"DATE", (boolean)true)) {
            if (!StringsKt.startsWith$default((String)v2, (String)"TIMESTAMP", (boolean)false, (int)2, null)) return false;
        }
        if (!StringsKt.endsWith$default((String)v2, (String)"'", (boolean)false, (int)2, null)) return false;
        String string = v2.substring(0, v2.length() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"'", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value2, @Nullable String alias, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BasicTableOrViewColumn column2 = PredicatesUtilKt.toBasicColumn(columnRef);
        if (column2 == null || !(value2 instanceof StringPredicateValue) && !(value2 instanceof Placeholder)) {
            return null;
        }
        BasicTableOrView basicTableOrView = column2.getTable();
        OraLikeTable oraLikeTable = basicTableOrView instanceof OraLikeTable ? (OraLikeTable)basicTableOrView : null;
        if (oraLikeTable == null) {
            return null;
        }
        OraLikeTable table = oraLikeTable;
        Ref.ObjectRef indextype = new Ref.ObjectRef();
        for (BasicModIndex index2 : table.getIndices()) {
            List<? extends BasicLikeColumn> indexCols;
            Intrinsics.checkNotNullExpressionValue(index2.getCols(), (String)"getCols(...)");
            if (indexCols.size() != 1 || !Intrinsics.areEqual((Object)indexCols.get(0), (Object)column2) || !(index2 instanceof OraIndex)) continue;
            indextype.element = this.getFtsIndextype((OraIndex)index2);
            if (indextype.element == null) continue;
        }
        if ((FtsIndextype)((Object)indextype.element) == null) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value2, ContainsInIndexedTextOperation.INSTANCE, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>((Ref.ObjectRef<FtsIndextype>)indextype, alias, columnRef, value2, this){
            final /* synthetic */ Ref.ObjectRef<FtsIndextype> $indextype;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ OraPredicatesHelper this$0;
            {
                this.$indextype = $indextype;
                this.$alias = $alias;
                this.$columnRef = $columnRef;
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                DdlBuilder ddlBuilder = builder.identifier(((FtsIndextype)((Object)this.$indextype.element)).getOperator()).symbol("(");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
                PredicatesUtilKt.identifier(ddlBuilder, this.$alias, this.$columnRef).symbol(",").space();
                PredicateValue predicateValue = this.$value;
                if (Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) {
                    builder.placeholder();
                } else if (predicateValue instanceof CustomPlaceholder) {
                    builder.plain(((CustomPlaceholder)this.$value).getPlaceholder());
                } else if (predicateValue instanceof StringPredicateValue) {
                    builder.literal(DbImplUtilCore.StringLiteralDecorator.MATCHES.decorate(((StringPredicateValue)this.$value).getStr(), this.this$0.getDbms()));
                }
                if (this.$indextype.element == FtsIndextype.CTXCAT) {
                    builder.symbol(",").space().plain("''");
                }
                builder.symbol(")").space().symbol(">").space().number(0);
            }
        }));
    }

    private final FtsIndextype getFtsIndextype(OraIndex index2) {
        FtsIndextype ftsIndextype;
        block2: {
            BasicReference basicReference = index2.getIndextypeRef();
            if (basicReference == null) {
                return null;
            }
            BasicReference ref2 = basicReference;
            FtsIndextype[] ftsIndextypeArray = FtsIndextype.values();
            int n = ftsIndextypeArray.length;
            for (int j = 0; j < n; ++j) {
                FtsIndextype ftsIndextype2;
                FtsIndextype indexType = ftsIndextype2 = ftsIndextypeArray[j];
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)ref2.getName(), (Object)indexType.name()) && Intrinsics.areEqual((Object)ref2.getParentName(), (Object)indexType.getOwner());
                if (!bl2) continue;
                ftsIndextype = ftsIndextype2;
                break block2;
            }
            ftsIndextype = null;
        }
        return ftsIndextype;
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        LogicalType type2;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        LogicalType logicalType = type2 = domain2 != null ? domain2.getLogicType() : null;
        return switch (logicalType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[logicalType.ordinal()]) {
            case 1, 2, 3, 4, 5, 6 -> PredicatesUtilKt.getFormatTester(columnRef, this.getDbms(), type2);
            default -> null;
        };
    }

    public static final /* synthetic */ DatabaseFormatterCreator access$getFormatterCreator$p(OraPredicatesHelper $this) {
        return $this.formatterCreator;
    }

    public static final /* synthetic */ FormatsCache access$getFormatsCache$p(OraPredicatesHelper $this) {
        return $this.formatsCache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "", "owner", "", "operator", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "getOwner", "CONTEXT", "CTXRULE", "CTXCAT", "intellij.database.dialects.oracle"})
    private static final class FtsIndextype
    extends Enum<FtsIndextype> {
        @NotNull
        private final String owner;
        @NotNull
        private final String operator;
        public static final /* enum */ FtsIndextype CONTEXT = new FtsIndextype("CTXSYS", "CONTAINS");
        public static final /* enum */ FtsIndextype CTXRULE = new FtsIndextype("CTXSYS", "MATCHES");
        public static final /* enum */ FtsIndextype CTXCAT = new FtsIndextype("CTXSYS", "CATSEARCH");
        private static final /* synthetic */ FtsIndextype[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FtsIndextype(String owner, String operator2) {
            this.owner = owner;
            this.operator = operator2;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        public static FtsIndextype[] values() {
            return (FtsIndextype[])$VALUES.clone();
        }

        public static FtsIndextype valueOf(String value2) {
            return Enum.valueOf(FtsIndextype.class, value2);
        }

        @NotNull
        public static EnumEntries<FtsIndextype> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ftsIndextypeArray = new FtsIndextype[]{FtsIndextype.CONTEXT, FtsIndextype.CTXRULE, FtsIndextype.CTXCAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogicalType.values().length];
            try {
                nArray[LogicalType.TIME_WITH_TIMEZONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIMESTAMP_WITH_TIMEZONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIMESTAMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.TIME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogicalType.JSON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

