/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.introspection.ImpacteesBuilder;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.impl.SqlDefinitionHolderStatementImpl;
import com.intellij.sql.psi.impl.SqlRenameToClauseImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "()V", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "OraDeterminer", "intellij.database.dialects.oracle"})
public final class OraAffectAnalyzer
extends BaseAffectAnalyzer {
    @Override
    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return new OraDeterminer(searchPath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "analyzeDdlStatement", "", "statement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "handleAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "handleRenameClause", "renameClause", "Lcom/intellij/sql/psi/SqlRenameToClause;", "handleRenameNewStyle", "Lcom/intellij/sql/psi/impl/SqlDefinitionHolderStatementImpl;", "intellij.database.dialects.oracle"})
    @SourceDebugExtension(value={"SMAP\nOraAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n+ 2 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 AnyFun.kt\ncom/intellij/database/util/common/AnyFunKt\n*L\n1#1,70:1\n260#2:71\n260#2:72\n436#3:73\n288#4,2:74\n64#5:76\n*S KotlinDebug\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n*L\n35#1:71\n49#1:72\n57#1:73\n57#1:74,2\n60#1:76\n*E\n"})
    private static final class OraDeterminer
    extends BaseAffectAnalyzer.SingleDatabaseDeterminer {
        public OraDeterminer(@Nullable SearchPath searchPath) {
            super(searchPath);
        }

        @Override
        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlDdlStatement sqlDdlStatement = statement2;
            if (sqlDdlStatement instanceof SqlAlterStatement) {
                this.handleAlterStatement((SqlAlterStatement)statement2);
            } else if (sqlDdlStatement instanceof SqlDefinitionHolderStatementImpl) {
                this.handleRenameNewStyle((SqlDefinitionHolderStatementImpl)statement2);
            } else {
                super.analyzeDdlStatement(statement2);
            }
        }

        private final void handleAlterStatement(SqlAlterStatement statement2) {
            SqlReferenceExpression objectRef = statement2.getAlterTargetReference();
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClauseImpl renameClause = (SqlRenameToClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClauseImpl.class, (boolean)false);
            if (renameClause == null) {
                BaseAffectAnalyzer.Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, objectRef, null, 4, null);
            } else {
                SqlNameElement nameElement = renameClause.getNameElement();
                SqlReferenceExpression sqlReferenceExpression = objectRef;
                SqlExpression sqlExpression = sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
                SqlReferenceExpression parentRef = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                this.handleByRef(ImpacteesBuilder.ActionType.DROP, objectRef, ObjectKind.TABLE);
                if (nameElement != null) {
                    ObjectKind objectKind = ObjectKind.TABLE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
                    this.handleByNameAndParentRef(ImpacteesBuilder.ActionType.ALTER, objectKind, nameElement, parentRef);
                }
            }
        }

        private final void handleRenameNewStyle(SqlDefinitionHolderStatementImpl statement2) {
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClause renameClause = (SqlRenameToClause)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClause.class, (boolean)false);
            this.handleRenameClause(renameClause);
        }

        /*
         * WARNING - void declaration
         */
        private final void handleRenameClause(SqlRenameToClause renameClause) {
            Object v1;
            SqlReferenceExpression originReference;
            block3: {
                void $this$firstOrNull$iv;
                if (renameClause == null) {
                    return;
                }
                originReference = renameClause.getTargetReference();
                BaseAffectAnalyzer.Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, originReference, null, 4, null);
                Object $this$childrenOfType$iv = (PsiElement)renameClause;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlIdentifier.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                $this$childrenOfType$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqlIdentifier it2 = (SqlIdentifier)element$iv;
                    boolean bl = false;
                    if (!(it2 != originReference)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            SqlIdentifier targetIdentifier = v1;
            if (targetIdentifier != null) {
                void $this$replace$iv;
                this.handleByRef(ImpacteesBuilder.ActionType.DROP, originReference, ObjectKind.TABLE);
                ObjectKind $i$f$firstOrNull = renameClause.getTargetObjectKind();
                Pair mapping$iv = TuplesKt.to((Object)SqlDbElementType.ANY, (Object)ObjectKind.TABLE);
                boolean $i$f$replace = false;
                ObjectKind objectKind = (ObjectKind)(Intrinsics.areEqual((Object)$this$replace$iv, (Object)mapping$iv.getFirst()) ? mapping$iv.getSecond() : $this$replace$iv);
                Intrinsics.checkNotNull((Object)objectKind);
                String string = targetIdentifier.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                SqlReferenceExpression sqlReferenceExpression = originReference;
                SqlExpression sqlExpression = sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
                this.handleByNameAndParentRef(ImpacteesBuilder.ActionType.ALTER, objectKind, string, targetIdentifier.isQuotedIdentifier(), sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null);
            }
        }
    }
}

