/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J&\u0010*\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010\u00062\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J0\u0010.\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010/2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u00100\u001a\u000201H\u0002J4\u00102\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060/0\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dH\u0002J$\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u0010+\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010-2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010=\u001a\u000201H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020\u0017H\u0014J\u0012\u0010A\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020\u0017H\u0014J\u0013\u0010B\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\bC*\u00020\bH\u0002\u00a8\u0006D"}, d2={"Lcom/intellij/database/dialects/mssql/MsObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "asExternalProp", "Lcom/intellij/database/model/NameValueType;", "name", "", "valueExpr", "Lcom/intellij/sql/psi/SqlExpression;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "Lcom/intellij/sql/psi/SqlElement;", "buildCall", "callStatement", "Lcom/intellij/sql/psi/SqlCallStatement;", "buildExtendedProperty", "add", "", "buildExtendedPropertyObjRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "arguments", "", "buildMsDefault", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "buildMsLikeIndex", "Lcom/intellij/database/dialects/mssql/model/MsLikeIndex;", "buildRoutine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildTableColumn", "Lcom/intellij/database/dialects/mssql/model/MsTableColumn;", "buildTrigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "createReference", "text", "elementType", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "epName", "Lkotlin/Pair;", "o", "", "epNames", "finalize", "finalizeDefaultConstraint", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getRefType", "level", "seqMaximumDefault", "", "isAsc", "seqMinimumDefault", "stringValue", "Lorg/jetbrains/annotations/Nullable;", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsObjectBuilder.kt\ncom/intellij/database/dialects/mssql/MsObjectBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,265:1\n378#2,7:266\n1549#2:293\n1620#2,3:294\n1#3:273\n625#4,5:274\n614#4,7:279\n644#4:286\n660#4,6:287\n621#4,3:297\n615#4:300\n625#4,5:301\n625#4,5:306\n614#4,7:312\n644#4:319\n660#4,6:320\n621#4,3:326\n615#4:329\n14#5:311\n14#5:330\n14#5:331\n*S KotlinDebug\n*F\n+ 1 MsObjectBuilder.kt\ncom/intellij/database/dialects/mssql/MsObjectBuilder\n*L\n89#1:266,7\n174#1:293\n174#1:294,3\n163#1:274,5\n168#1:279,7\n174#1:286\n174#1:287,6\n168#1:297,3\n168#1:300\n192#1:301,5\n205#1:306,5\n213#1:312,7\n216#1:319\n216#1:320,6\n213#1:326,3\n213#1:329\n213#1:311\n235#1:330\n245#1:331\n*E\n"})
public final class MsObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof MsTrigger) {
            this.buildTrigger((MsTrigger)obj2, source, context);
        } else if (basicModElement instanceof MsRoutine) {
            this.buildRoutine((MsRoutine)obj2, source, context);
        } else if (basicModElement instanceof MsTableColumn) {
            this.buildTableColumn((MsTableColumn)obj2, source, context);
        } else if (basicModElement instanceof MsLikeIndex) {
            this.buildMsLikeIndex((MsLikeIndex)obj2, source, context);
        } else if (basicModElement instanceof MsDefaultConstraint) {
            this.buildMsDefault((MsDefaultConstraint)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    public void build(@NotNull SqlElement source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (source instanceof SqlCallStatement) {
            this.buildCall((SqlCallStatement)source, context);
        }
        super.build(source, context);
    }

    private final void buildCall(SqlCallStatement callStatement, SqlObjectBuilder.Context context) {
        Object object = callStatement.getCallableReference();
        if (object == null || (object = object.getName()) == null) {
            return;
        }
        Object name2 = object;
        if (StringsKt.equals((String)name2, (String)"sp_addextendedproperty", (boolean)true) || StringsKt.equals((String)name2, (String)"sp_updateextendedproperty", (boolean)true)) {
            this.buildExtendedProperty(callStatement, context, true);
        } else if (StringsKt.equals((String)name2, (String)"sp_dropextendedproperty", (boolean)true)) {
            this.buildExtendedProperty(callStatement, context, false);
        }
    }

    private final void buildExtendedProperty(SqlCallStatement callStatement, SqlObjectBuilder.Context context, boolean add) {
        SqlExpression valueExpr;
        List list = callStatement.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
        List arguments = list;
        SqlReferenceExpression ref2 = this.buildExtendedPropertyObjRef(callStatement, arguments, add);
        BasicModElement basicModElement = this.resolve(context, ref2);
        if (basicModElement == null) {
            return;
        }
        BasicModElement obj2 = basicModElement;
        SqlExpression sqlExpression = (SqlExpression)CollectionsKt.getOrNull((List)arguments, (int)0);
        String name2 = sqlExpression != null ? this.stringValue(sqlExpression) : null;
        SqlExpression sqlExpression2 = valueExpr = add ? (SqlExpression)CollectionsKt.getOrNull((List)arguments, (int)1) : null;
        if (Intrinsics.areEqual((Object)name2, (Object)"MS_Description")) {
            BasicModNamedElement basicModNamedElement = obj2 instanceof BasicModNamedElement ? (BasicModNamedElement)obj2 : null;
            if (basicModNamedElement != null) {
                SqlExpression sqlExpression3 = valueExpr;
                basicModNamedElement.setComment(sqlExpression3 != null ? this.stringValue(sqlExpression3) : null);
            }
        } else if (name2 != null && obj2 instanceof MsExtendedPropertiesHolder) {
            List<NameValueType> list2 = ((MsExtendedPropertiesHolder)obj2).getExtendedProperties();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getExtendedProperties(...)");
            List props = CollectionsKt.toMutableList((Collection)list2);
            props.removeIf(arg_0 -> MsObjectBuilder.buildExtendedProperty$lambda$0((Function1)new Function1<NameValueType, Boolean>(name2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(NameValueType it2) {
                    return Intrinsics.areEqual((Object)it2.getName(), (Object)this.$name);
                }
            }, arg_0));
            if (valueExpr != null) {
                props.add(this.asExternalProp(name2, valueExpr));
            }
            ((MsExtendedPropertiesHolder)obj2).setExtendedProperties(props);
        }
    }

    private final NameValueType asExternalProp(String name2, SqlExpression valueExpr) {
        String string;
        if (valueExpr instanceof SqlStringLiteralExpression) {
            String string2 = ((SqlStringLiteralExpression)valueExpr).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = StringsKt.startsWith((String)string2, (String)"N", (boolean)true) ? "nvarchar" : "varchar";
        } else {
            string = "bigint";
        }
        String type2 = string;
        String string3 = valueExpr instanceof SqlLiteralExpression ? ((SqlLiteralExpression)valueExpr).getText() : "invalid";
        Intrinsics.checkNotNull((Object)string3);
        return new NameValueType(name2, string3, type2);
    }

    /*
     * WARNING - void declaration
     */
    private final SqlReferenceExpression buildExtendedPropertyObjRef(SqlCallStatement callStatement, List<? extends SqlExpression> arguments, boolean add) {
        SqlReferenceElementType sqlReferenceElementType;
        int n;
        Object iterator$iv;
        Object object;
        NamingService ns;
        List<Pair<String, String>> names2;
        block3: {
            void $this$indexOfLast$iv;
            names2 = this.epNames(arguments, add ? 2 : 1);
            Dbms dbms = DbImplUtilCore.getDbms((PsiElement)callStatement);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            ns = NamingServices.getNamingService$default(dbms, null, null, 6, null);
            List<Pair<String, String>> list = names2;
            object = CollectionsKt.asSequence((Iterable)names2);
            boolean $i$f$indexOfLast = false;
            iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Pair it2 = (Pair)iterator$iv.previous();
                boolean bl = false;
                if (!(it2.getSecond() == null)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        int n3 = n;
        String text2 = SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)object, (int)(n3 + 1)), (CharSequence)".", null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, CharSequence>(ns){
            final /* synthetic */ NamingService $ns;
            {
                this.$ns = $ns;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<String, String> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                Object object = it2.getSecond();
                Intrinsics.checkNotNull((Object)object);
                return this.$ns.catToScript((String)object, null, true);
            }
        }), (int)30, null);
        MsObjectBuilder msObjectBuilder = this;
        SqlCallStatement sqlCallStatement = callStatement;
        String string = text2;
        String string2 = (String)((Pair)CollectionsKt.last(names2)).getFirst();
        if (string2 != null) {
            void it3;
            iterator$iv = string2;
            String string3 = string;
            SqlCallStatement sqlCallStatement2 = sqlCallStatement;
            object = msObjectBuilder;
            boolean bl = false;
            SqlReferenceElementType sqlReferenceElementType2 = this.getRefType((String)it3, CollectionsKt.getLastIndex(names2));
            msObjectBuilder = object;
            sqlCallStatement = sqlCallStatement2;
            string = string3;
            sqlReferenceElementType = sqlReferenceElementType2;
        } else {
            sqlReferenceElementType = null;
        }
        return msObjectBuilder.createReference(sqlCallStatement, string, sqlReferenceElementType);
    }

    private final SqlReferenceElementType getRefType(String name2, int level) {
        return switch (name2) {
            case "USER", "SCHEMA" -> SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE;
            case "TRIGGER" -> SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE;
            case "TYPE" -> SqlCompositeElementTypes.SQL_TYPE_REFERENCE;
            case "AGGREGATE" -> SqlCompositeElementTypes.SQL_AGGREGATE_REFERENCE;
            case "DEFAULT" -> MsElementTypes.Extra.MSSQL_DEFAULT_REFERENCE;
            case "FUNCTION" -> SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE;
            case "PROCEDURE" -> SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE;
            case "RULE" -> MsElementTypes.Extra.MSSQL_RULE_REFERENCE;
            case "SEQUENCE" -> SqlCompositeElementTypes.SQL_SEQUENCE_REFERENCE;
            case "SYNONYM" -> SqlCompositeElementTypes.SQL_SYNONYM_REFERENCE;
            case "TABLE" -> SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            case "TABLE_TYPE" -> SqlCompositeElementTypes.SQL_TABLE_TYPE_REFERENCE;
            case "VIEW" -> SqlCompositeElementTypes.SQL_VIEW_REFERENCE;
            case "COLUMN" -> SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            case "CONSTRAINT" -> SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE;
            case "INDEX" -> SqlCompositeElementTypes.SQL_INDEX_REFERENCE;
            case "PARAMETER" -> SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE;
            default -> null;
        };
    }

    private final SqlReferenceExpression createReference(SqlCallStatement callStatement, String text2, SqlReferenceElementType elementType) {
        if (text2 == null || elementType == null) {
            return null;
        }
        SqlCodeFragmentImpl frag = new SqlCodeFragmentImpl(callStatement.getProject(), SqlImplUtil.getSqlDialectSafe((PsiElement)callStatement), (IElementType)elementType, "a.sql", text2, false);
        frag.setContext((PsiElement)callStatement);
        Class[] classArray = new Class[]{SqlReferenceExpression.class};
        return (SqlReferenceExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)((PsiElement)frag), (Class[])classArray);
    }

    private final List<Pair<String, String>> epNames(List<? extends SqlExpression> arguments, int o2) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, 2))), (Function1)((Function1)new Function1<Integer, Pair<? extends String, ? extends String>>(this, arguments, o2){
            final /* synthetic */ MsObjectBuilder this$0;
            final /* synthetic */ List<SqlExpression> $arguments;
            final /* synthetic */ int $o;
            {
                this.this$0 = $receiver;
                this.$arguments = $arguments;
                this.$o = $o;
                super(1);
            }

            @Nullable
            public final Pair<String, String> invoke(int it2) {
                return MsObjectBuilder.access$epName(this.this$0, this.$arguments, this.$o + it2 * 2);
            }
        })));
    }

    private final Pair<String, String> epName(List<? extends SqlExpression> arguments, int o2) {
        Pair pair;
        if (arguments.size() > o2) {
            SqlExpression sqlExpression = (SqlExpression)CollectionsKt.getOrNull(arguments, (int)o2);
            SqlExpression sqlExpression2 = (SqlExpression)CollectionsKt.getOrNull(arguments, (int)(o2 + 1));
            pair = new Pair((Object)(sqlExpression != null ? this.stringValue(sqlExpression) : null), (Object)(sqlExpression2 != null ? this.stringValue(sqlExpression2) : null));
        } else {
            pair = null;
        }
        return pair;
    }

    private final String stringValue(SqlExpression $this$stringValue) {
        SqlStringLiteralExpression sqlStringLiteralExpression = $this$stringValue instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)$this$stringValue : null;
        return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
    }

    @Override
    public void finalize(@NotNull BasicModElement obj2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        super.finalize(obj2);
        if (obj2 instanceof MsDefaultConstraint) {
            this.finalizeDefaultConstraint((MsDefaultConstraint)obj2);
        }
    }

    private final void finalizeDefaultConstraint(MsDefaultConstraint obj2) {
        block1: {
            List<? extends BasicLikeColumn> list = obj2.getCols();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCols(...)");
            BasicLikeColumn basicLikeColumn = (BasicLikeColumn)CollectionsKt.firstOrNull(list);
            if (basicLikeColumn == null) break block1;
            BasicLikeColumn it2 = basicLikeColumn;
            boolean bl = false;
            MsStoredColumn msStoredColumn = it2 instanceof MsStoredColumn ? (MsStoredColumn)it2 : null;
            basicLikeColumn = msStoredColumn;
            if (msStoredColumn != null) {
                BasicLikeColumn basicLikeColumn2;
                BasicLikeColumn $this$finalizeDefaultConstraint_u24lambda_u244 = basicLikeColumn2 = basicLikeColumn;
                boolean bl2 = false;
                $this$finalizeDefaultConstraint_u24lambda_u244.setDefaultConstraintRef(BasicMetaUtils.createPortableReference((BasicElement)$this$finalizeDefaultConstraint_u24lambda_u244, (BasicElement)obj2, MsStoredColumn.DEFAULT_CONSTRAINT_REF));
            }
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text2, def)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMsLikeIndex(MsLikeIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        MsLikeIndex stubbed;
        BasicElement basicElement;
        super.buildIndex(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        Object object = $this$stubbed$iv;
        if (object instanceof MsLikeIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (object instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof MsLikeIndex)) {
                basicElement2 = null;
            }
            basicElement = (MsLikeIndex)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsLikeIndex)basicElement) == null) {
            void this_$iv;
            boolean fulltext = false;
            boolean clustered = false;
            Ref.ObjectRef includeColumns = new Ref.ObjectRef();
            includeColumns.element = CollectionsKt.emptyList();
            object = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlIndexDefinition ? (SqlIndexDefinition)source : null);
            boolean $i$f$forEachChild = false;
            void var11_14 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SqlReferenceList l;
                PsiElement psiElement2;
                PsiElement it$iv;
                Object element$iv$iv;
                block13: {
                    PsiElement c2 = tmp$iv$iv;
                    boolean bl = false;
                    IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c2);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_FULLTEXT)) {
                        fulltext = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_CLUSTERED)) {
                        clustered = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_NONCLUSTERED)) {
                        clustered = false;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)c2.getFirstChild()), (Object)MsTypes.MSSQL_INCLUDE)) continue;
                    SqlObjectBuilderImpl this_$iv2 = this;
                    boolean $i$f$findChild = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
                    element$iv$iv = c2.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv2 = element$iv$iv; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        it$iv = tmp$iv$iv2;
                        boolean bl2 = false;
                        if (!(it$iv instanceof SqlReferenceList)) continue;
                        psiElement2 = tmp$iv$iv2;
                        break block13;
                    }
                    psiElement2 = null;
                }
                if ((SqlReferenceList)psiElement2 == null) continue;
                boolean bl = false;
                List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(l);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getReferenceList(...)");
                element$iv$iv = list;
                Ref.ObjectRef objectRef = includeColumns;
                boolean $i$f$map = false;
                it$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(it2.getName());
                }
                objectRef.element = (List)destination$iv$iv;
            }
            obj2.setFulltext(fulltext);
            obj2.setClustering(clustered);
            obj2.setIncludedColNames((List)includeColumns.element);
        } else {
            obj2.setFulltext(stubbed.isFulltext());
            obj2.setClustering(stubbed.isClustering());
            obj2.setIncludedColNames(stubbed.getIncludedColNames());
        }
    }

    private final void buildMsDefault(MsDefaultConstraint obj2, DasObject source, SqlObjectBuilder.Context context) {
        MsDefaultConstraint stubbed;
        BasicElement basicElement;
        super.buildBasicElement(obj2, source, context);
        super.buildColumniation(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof MsDefaultConstraint) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof MsDefaultConstraint)) {
                basicElement2 = null;
            }
            basicElement = (MsDefaultConstraint)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsDefaultConstraint)basicElement) == null) {
            SqlConstraintDefinition def = source instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)source : null;
            SqlConstraintDefinition sqlConstraintDefinition = def;
            obj2.setDefaultExpression(sqlConstraintDefinition != null && (sqlConstraintDefinition = (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION)) != null ? sqlConstraintDefinition.getText() : null);
        } else {
            obj2.setDefaultExpression(stubbed.getDefaultExpression());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTableColumn(MsTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        MsTableColumn stubbed;
        BasicElement basicElement;
        this.buildBasicElement(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof MsTableColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof MsTableColumn)) {
                basicElement2 = null;
            }
            basicElement = (MsTableColumn)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsTableColumn)basicElement) != null) {
            obj2.setAutoInc(stubbed.isAutoInc());
            obj2.setCollationRef(stubbed.getCollationRef());
        } else {
            void el$iv;
            void this_$iv;
            boolean autoInc = false;
            Ref.ObjectRef collation = new Ref.ObjectRef();
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            DasObject $this$asSafely$iv = source;
            boolean $i$f$asSafely = false;
            DasObject dasObject2 = $this$asSafely$iv;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            $this$asSafely$iv = (PsiElement)dasObject2;
            boolean $i$f$forEachChild = false;
            void var10_13 = this_$iv;
            void v4 = el$iv;
            PsiElement first$iv$iv = v4 != null ? v4.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                SqlReferenceExpression sqlReferenceExpression;
                PsiElement psiElement;
                block15: {
                    void this_$iv2;
                    PsiElement it2 = tmp$iv$iv;
                    boolean bl = false;
                    IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it2);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) {
                        autoInc = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLLATE_CLAUSE)) continue;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                    Ref.ObjectRef objectRef = collation;
                    boolean $i$f$findChild = false;
                    void var20_23 = this_$iv2;
                    PsiElement element$iv$iv = it2.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv2 = element$iv$iv; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv2;
                        boolean bl2 = false;
                        if (!(it$iv instanceof SqlReferenceExpression)) continue;
                        psiElement = tmp$iv$iv2;
                        break block15;
                    }
                    psiElement = null;
                }
                objectRef.element = (sqlReferenceExpression = (SqlReferenceExpression)psiElement) != null ? SqlObjectBuilderImpl.asBasic$default(this, sqlReferenceExpression, false, 1, null) : null;
            }
            obj2.setAutoInc(autoInc);
            obj2.setCollationRef((BasicReference)collation.element);
        }
        if (obj2.isAutoInc()) {
            obj2.setNotNull(true);
        }
        if (StringsKt.equals((String)obj2.getName(), (String)"timestamp", (boolean)true)) {
            DataType dataType = DataTypeFactory.of(obj2.getName());
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            obj2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            obj2.setComputed(true);
        } else if (StringsKt.equals((String)obj2.getName(), (String)"rowversion", (boolean)true)) {
            obj2.setComputed(true);
        }
    }

    private final void buildRoutine(MsRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicArgument basicArgument;
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModRoutine");
        this.buildRoutine((BasicModRoutine)obj2, source, context);
        if (!context.isStubBuilder() && obj2.getRoutineType() == MsRoutineType.TAB_FUN && (basicArgument = obj2.getReturnArgument()) != null) {
            BasicArgument $this$asSafely$iv = basicArgument;
            boolean $i$f$asSafely = false;
            BasicArgument basicArgument2 = $this$asSafely$iv;
            if (!(basicArgument2 instanceof MsArgument)) {
                basicArgument2 = null;
            }
            if ((basicArgument = (MsArgument)basicArgument2) != null) {
                basicArgument.drop();
            }
        }
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ MsObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateProcedureStatement sqlCreateProcedureStatement = object instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)object : null;
                return sqlCreateProcedureStatement != null && (object = this.this$0.wholeStatement((SqlRoutineDefinition)sqlCreateProcedureStatement)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    @Override
    public void buildRoutineKind(@NotNull BasicModRoutine obj2, @NotNull DasObject source) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        MsRoutine cfr_ignored_0 = (MsRoutine)obj2;
        DasRoutine.Kind k = this.extractRoutineKind(source);
        MsRoutine msRoutine = (MsRoutine)obj2;
        msRoutine.setRoutineType(switch (WhenMappings.$EnumSwitchMapping$0[k.ordinal()]) {
            case 1 -> MsRoutineType.PROC;
            case 2 -> {
                DasObject v3;
                DasObject $this$asSafely$iv = source;
                boolean $i$f$asSafely = false;
                DasObject v2 = $this$asSafely$iv;
                if (!(v2 instanceof DasRoutine)) {
                    v2 = null;
                }
                if (((v3 = (DasRoutine)v2) != null && (v3 = v3.getReturnArgument()) != null ? v3.getDasType() : null) instanceof DasTableType) {
                    yield MsRoutineType.TAB_FUN;
                }
                yield MsRoutineType.SCALAR_FUN;
            }
            default -> MsRoutineType.CLR_PROC;
        });
    }

    private final void buildTrigger(MsTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger((BasicModTrigger)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ MsObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateTriggerStatement sqlCreateTriggerStatement = object instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)object : null;
                return sqlCreateTriggerStatement != null && (object = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(source, this){
            final /* synthetic */ DasObject $source;
            final /* synthetic */ MsObjectBuilder this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final CompositeText invoke() {
                Object object = this.$source;
                SqlCreateViewStatement sqlCreateViewStatement = object instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)object : null;
                return sqlCreateViewStatement != null && (object = this.this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null;
            }
        }));
    }

    @Nullable
    protected Void seqMinimumDefault(boolean isAsc) {
        return null;
    }

    @Nullable
    protected Void seqMaximumDefault(boolean isAsc) {
        return null;
    }

    private static final boolean buildExtendedProperty$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pair access$epName(MsObjectBuilder $this, List arguments, int o2) {
        return $this.epName(arguments, o2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasRoutine.Kind.values().length];
            try {
                nArray[DasRoutine.Kind.PROCEDURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasRoutine.Kind.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

