/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dialects.mssql.model.MsLinkedServer;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/mssql/MsLinkedDataSourceHelper;", "Lcom/intellij/database/dataSource/LinkedDataSourceHelper;", "()V", "createLinkedDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "link", "Lcom/intellij/database/model/DasObject;", "linkDs", "project", "Lcom/intellij/openapi/project/Project;", "getLinkedDataSourceKind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.mssql"})
public final class MsLinkedDataSourceHelper
extends LinkedDataSourceHelper {
    @Override
    @NotNull
    public ObjectKind getLinkedDataSourceKind() {
        ObjectKind objectKind = ObjectKind.LINKED_SERVER;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LINKED_SERVER");
        return objectKind;
    }

    @Override
    @NotNull
    public LocalDataSource createLinkedDataSource(@NotNull DasObject link, @NotNull LocalDataSource linkDs, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)linkDs, (String)"linkDs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalDataSource localDataSource = super.createLinkedDataSource(link, linkDs, project);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"createLinkedDataSource(...)");
        LocalDataSource ds = localDataSource;
        MsLinkedServer msLinkedServer = link instanceof MsLinkedServer ? (MsLinkedServer)link : null;
        if (msLinkedServer == null) {
            return ds;
        }
        MsLinkedServer linkedServer = msLinkedServer;
        if (!Intrinsics.areEqual((Object)linkedServer.getProviderName(), (Object)"SQLNCLI")) {
            return ds;
        }
        DatabaseDriver databaseDriver = linkDs.getDatabaseDriver();
        List<StatelessJdbcUrlParser> list = databaseDriver != null ? databaseDriver.getJDBCUrlParsers() : null;
        UrlEditorModel model2 = new UrlEditorModel(list == null ? (Collection)CollectionsKt.emptyList() : (Collection)list);
        String string = linkDs.getUrl();
        if (string == null) {
            string = "";
        }
        model2.setUrl(string);
        model2.commit(true);
        String string2 = linkedServer.getDataSource();
        if (string2 == null) {
            string2 = "";
        }
        model2.setParameter("instance", string2);
        String string3 = linkedServer.getCatalog();
        if (string3 == null) {
            string3 = "";
        }
        model2.setParameter("database", string3);
        model2.commit(true);
        ds.setUrl(model2.getUrl());
        return ds;
    }
}

