/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaDescriptionService;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J1\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00062\u0006\u0010\u0005\u001a\u0002H\u00112\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExaScript", "r", "Lcom/intellij/database/dialects/exasol/model/ExaScript;", "describeExaVirtualSchema", "s", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "isPropertyValueDefault", "", "E", "property", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicMetaProperty;)Z", "intellij.database.dialects.exasol"})
public final class ExaDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof ExaScript ? this.describeExaScript((ExaScript)e2, context) : (basicElement instanceof ExaVirtualSchema ? this.describeExaVirtualSchema((ExaVirtualSchema)e2, context) : super.content(e2, context));
    }

    private final String describeExaScript(ExaScript r, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(ExaScript.SCRIPT_TYPE);
        return "script " + StringUtil.toLowerCase((String)String.valueOf((Object)r.getScriptType()));
    }

    private final String describeExaVirtualSchema(ExaVirtualSchema s2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(ExaVirtualSchema.ADAPTER_REF);
        ((Collection)context.getDescribed()).add(ExaVirtualSchema.PROPERTIES);
        String string = this.getName(s2.getAdapterRef(), s2.getAdapter());
        List<NameValue> list = s2.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        return "vschema using " + string + " props {" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)describeExaVirtualSchema.1.INSTANCE, (int)30, null);
    }

    @Override
    protected <E extends BasicElement> boolean isPropertyValueDefault(@NotNull E e2, @NotNull BasicMetaProperty<E, ?> property) {
        Intrinsics.checkNotNullParameter(e2, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual(property.id, (Object)ExaUser.PASSWORD) || Intrinsics.areEqual(property.id, ExaConnection.PASSWORD) || super.isPropertyValueDefault(e2, property);
    }
}

