/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model.properties;

import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.dialects.cassandra.model.defaults.CassTablePropertyKind;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CassPropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<CassKeyColumn> T_CASS_KEY_COLUMN = BasicMetaType.createType(CassKeyColumn.class, CassPropertyConverter::importCassKeyColumn, CassPropertyConverter::export);
    public static final BasicMetaType<List<CassKeyColumn>> T_LIST_OF_CASS_KEY_COLUMN = new BasicMetaType.CollectionMetaType<CassKeyColumn, List<CassKeyColumn>>(List.class, T_CASS_KEY_COLUMN, CassPropertyConverter::importListOfCassKeyColumn, CassPropertyConverter::exportListOfCassKeyColumn);
    public static final BasicMetaType<CassSchemaPropertyKind> T_CASS_SCHEMA_PROPERTY_KIND = BasicMetaType.createType(CassSchemaPropertyKind.class, CassPropertyConverter::importCassSchemaPropertyKind, CassPropertyConverter::export);
    public static final BasicMetaType<Map<CassSchemaPropertyKind, String>> T_MAP_OF_CASS_SCHEMA_PROPERTY_KIND_STRING = new BasicMetaType.MapMetaType<CassSchemaPropertyKind, String>(T_CASS_SCHEMA_PROPERTY_KIND, T_STRING, CassPropertyConverter::importMapOfCassSchemaPropertyKindString, CassPropertyConverter::exportMapOfCassSchemaPropertyKindString);
    public static final BasicMetaType<CassTablePropertyKind> T_CASS_TABLE_PROPERTY_KIND = BasicMetaType.createType(CassTablePropertyKind.class, CassPropertyConverter::importCassTablePropertyKind, CassPropertyConverter::export);
    public static final BasicMetaType<Map<CassTablePropertyKind, String>> T_MAP_OF_CASS_TABLE_PROPERTY_KIND_STRING = new BasicMetaType.MapMetaType<CassTablePropertyKind, String>(T_CASS_TABLE_PROPERTY_KIND, T_STRING, CassPropertyConverter::importMapOfCassTablePropertyKindString, CassPropertyConverter::exportMapOfCassTablePropertyKindString);

    public static String exportListOfCassKeyColumn(List<CassKeyColumn> columns2) {
        StringBuilder sb = new StringBuilder();
        for (CassKeyColumn column2 : columns2) {
            sb.append(column2.export()).append("\n");
        }
        return sb.toString();
    }

    public static String export(CassKeyColumn column2) {
        return column2 == null ? null : column2.export();
    }

    @NotNull
    public static List<CassKeyColumn> importListOfCassKeyColumn(String text2) {
        String[] lines;
        if (text2 == null || text2.length() == 0) {
            List<CassKeyColumn> list = Collections.emptyList();
            if (list == null) {
                CassPropertyConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<CassKeyColumn> res2 = new ArrayList<CassKeyColumn>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            res2.add(CassKeyColumn.read(line));
        }
        ArrayList<CassKeyColumn> arrayList = res2;
        if (arrayList == null) {
            CassPropertyConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public static CassKeyColumn importCassKeyColumn(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return CassKeyColumn.read(text2);
    }

    public static String exportMapOfCassSchemaPropertyKindString(Map<CassSchemaPropertyKind, String> properties2) {
        return CassPropertyConverter.exportMap(properties2);
    }

    public static String export(CassSchemaPropertyKind property) {
        return property == null ? null : property.name().toLowerCase(Locale.ENGLISH);
    }

    public static String exportMapOfCassTablePropertyKindString(Map<CassTablePropertyKind, String> properties2) {
        return CassPropertyConverter.exportMap(properties2);
    }

    public static String export(CassTablePropertyKind property) {
        return property == null ? null : property.name().toLowerCase(Locale.ENGLISH);
    }

    public static <T extends Enum<T>> String exportMap(Map<T, String> properties2) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, String> entry : properties2.entrySet()) {
            sb.append(((Enum)entry.getKey()).name().toLowerCase(Locale.ENGLISH)).append(":").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Nullable
    public static CassSchemaPropertyKind importCassSchemaPropertyKind(String text2) {
        return StringUtil.isEmpty((String)text2) ? null : Enum.valueOf(CassSchemaPropertyKind.class, text2.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static Map<CassSchemaPropertyKind, String> importMapOfCassSchemaPropertyKindString(String text2) {
        return CassPropertyConverter.importMap(text2, CassSchemaPropertyKind.class);
    }

    @Nullable
    public static CassTablePropertyKind importCassTablePropertyKind(String text2) {
        return StringUtil.isEmpty((String)text2) ? null : Enum.valueOf(CassTablePropertyKind.class, text2.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static Map<CassTablePropertyKind, String> importMapOfCassTablePropertyKindString(String text2) {
        return CassPropertyConverter.importMap(text2, CassTablePropertyKind.class);
    }

    @NotNull
    public static <T extends Enum<T>> Map<T, String> importMap(String text2, Class<T> enumClass) {
        String[] lines;
        LinkedHashMap<T, String> properties2 = new LinkedHashMap<T, String>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            int colon = line.indexOf(58);
            if (colon == -1) continue;
            String name2 = line.substring(0, colon);
            try {
                T kind = Enum.valueOf(enumClass, name2.toUpperCase(Locale.ENGLISH));
                properties2.put(kind, line.substring(colon + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        LinkedHashMap<T, String> linkedHashMap = properties2;
        if (linkedHashMap == null) {
            CassPropertyConverter.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dialects/cassandra/model/properties/CassPropertyConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfCassKeyColumn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "importMap";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

