/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.dialects.cassandra.generator.producers.CassElementOption;
import com.intellij.database.dialects.cassandra.generator.producers.CassKeyProducersKt;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassDescriptionService;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020 H\u0002J \u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020,2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeCassAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "describeCassFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "describeCassIndex", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "describeCassKey", "key", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeCassKeyImpl", "describeCassMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "describeCassRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "describeCassSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "describeCassTable", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "describeCassTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "o", "describeIndex", "Lcom/intellij/database/model/DasIndex;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "describeIndexingItems", "describeLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "updatePresentation", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassDescriptionService.kt\ncom/intellij/database/dialects/cassandra/model/CassDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class CassDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof CassKey ? this.describeCassKey((CassKey)e2, context) : (basicElement instanceof CassTableColumn ? this.describeCassTableColumn((CassTableColumn)e2, context) : (basicElement instanceof CassIndex ? this.describeCassIndex((CassIndex)e2, context) : (basicElement instanceof CassFunction ? this.describeCassFunction((CassFunction)e2, context) : (basicElement instanceof CassAggregate ? this.describeCassAggregate((CassAggregate)e2, context) : (basicElement instanceof CassRole ? this.describeCassRole((CassRole)e2, context) : (basicElement instanceof CassSchema ? this.describeCassSchema((CassSchema)e2, context) : (basicElement instanceof CassTable ? this.describeCassTable((CassTable)e2, context) : (basicElement instanceof CassMatView ? this.describeCassMatView((CassMatView)e2, context) : super.content(e2, context)))))))));
    }

    private final String describeCassMatView(CassMatView e2, DescriptionService.Context context) {
        String desc = super.describeView(e2, context);
        String likeTableDesc = this.describeLikeTable(e2, context);
        if (((CharSequence)desc).length() > 0 && ((CharSequence)likeTableDesc).length() > 0) {
            return desc + " " + likeTableDesc;
        }
        return desc + likeTableDesc;
    }

    private final String describeCassTable(CassTable e2, DescriptionService.Context context) {
        String desc = super.describeTable(e2, context);
        String likeTableDesc = this.describeLikeTable(e2, context);
        if (((CharSequence)desc).length() > 0 && ((CharSequence)likeTableDesc).length() > 0) {
            return desc + " " + likeTableDesc;
        }
        return desc + likeTableDesc;
    }

    private final String describeLikeTable(CassLikeTable e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassLikeTable.COMMENT);
        ((Collection)context.getDescribed()).add(CassLikeTable.PROPERTIES);
        Object desc = "";
        for (CassElementOption option : CassTableProducersKt.getTableOptions()) {
            Object version;
            if (Intrinsics.areEqual((Object)option.getName(), (Object)"comment")) continue;
            String realValue = (String)option.getValueGetter().invoke((Object)e2);
            BasicElement basicElement = e2.getParent();
            BasicElement basicElement2 = basicElement != null ? basicElement.getParent() : null;
            Object object = basicElement2 instanceof BasicRoot ? (BasicRoot)basicElement2 : null;
            if (object == null || (object = object.getServerVersion()) == null) {
                object = version = Version.ZERO;
            }
            if (realValue == null) continue;
            Function1<Version, String> function1 = option.getDefaultValue();
            Intrinsics.checkNotNull((Object)version);
            if (Intrinsics.areEqual((Object)realValue, (Object)function1.invoke(version))) continue;
            desc = (String)desc + " " + option.getName() + " = " + CassElementOption.getLiteral$default(option, e2, (Version)version, false, 4, null);
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)desc))).toString();
    }

    private final String describeCassSchema(CassSchema e2, DescriptionService.Context context) {
        Object desc;
        block1: {
            String it2;
            ((Collection)context.getDescribed()).add(CassSchema.PROPERTIES);
            desc = null;
            desc = super.describeBasicElement(e2);
            String string = e2.getProperties().get((Object)CassSchemaPropertyKind.DURABLE_WRITES);
            if (string != null) {
                it2 = string;
                boolean bl = false;
                desc = desc + " durable_writes: " + it2;
            }
            String string2 = e2.getProperties().get((Object)CassSchemaPropertyKind.REPLICATION);
            if (string2 == null) break block1;
            it2 = string2;
            boolean bl = false;
            desc = desc + " replication: " + it2;
        }
        return desc;
    }

    private final String describeCassRole(CassRole e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassRole.SUPER_ROLE);
        ((Collection)context.getDescribed()).add(CassRole.CAN_LOGIN);
        Object desc = "";
        if (e2.isSuperRole()) {
            desc = (String)desc + " superuser";
        }
        if (e2.isCanLogin()) {
            desc = (String)desc + " login";
        }
        return desc;
    }

    private final String describeCassAggregate(CassAggregate e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassAggregate.STATE_STORED_TYPE);
        ((Collection)context.getDescribed()).add(CassAggregate.STATE_FUNC);
        ((Collection)context.getDescribed()).add(CassAggregate.FINAL_FUNC);
        ((Collection)context.getDescribed()).add(CassAggregate.INIT_COND);
        String description = super.describeRoutine(e2, context) + " state_type: " + e2.getStateType().toDataType();
        if (e2.getStateFunc() != null) {
            description = description + " state_func: " + e2.getStateFunc();
        }
        if (e2.getFinalFunc() != null) {
            description = description + " final_func: " + e2.getFinalFunc();
        }
        if (e2.getInitCond() != null) {
            description = description + " init_cond: " + e2.getInitCond();
        }
        return description;
    }

    private final String describeCassFunction(CassFunction e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassFunction.LANGUAGE);
        ((Collection)context.getDescribed()).add(CassFunction.CALLED_ON_NULL_INPUT);
        Object description = super.describeRoutine(e2, context);
        if (e2.getLanguage() != null) {
            description = (String)description + " language: " + e2.getLanguage();
        }
        return (String)description + " called_on_null_input: " + e2.isCalledOnNullInput();
    }

    private final String describeCassTableColumn(CassTableColumn e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassTableColumn.STATIC_COLUMN);
        String description = this.describeTableOrViewColumn(e2, context);
        if (e2.isStaticColumn()) {
            return description + " static";
        }
        return description;
    }

    private final String describeCassKey(CassKey key2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassKey.COLUMNS);
        return this.describeCassKeyImpl(key2);
    }

    @NlsSafe
    private final String describeCassKeyImpl(CassKey key2) {
        String res2 = "(" + CassKeyProducersKt.describeKey(key2, (Function1<? super String, String>)((Function1)describeCassKeyImpl.res.1.INSTANCE)) + ")";
        if (CassKeyProducersKt.isDefaultClusteringOrder(key2)) {
            return res2;
        }
        return res2 + " clustering order by (" + CassKeyProducersKt.getClusteringOrderBy(key2, (Function1<? super String, String>)((Function1)describeCassKeyImpl.1.INSTANCE)) + ")";
    }

    private final String describeCassIndex(CassIndex index2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(CassIndex.COLUMNS);
        ((Collection)context.getDescribed()).add(CassIndex.CUSTOM);
        String inner = this.describeIndexingItems(index2);
        return (index2.isCustom() ? "custom index" : "index") + " (" + inner + ")";
    }

    private final String describeIndexingItems(CassIndex index2) {
        String string;
        if (index2.getColumns().isEmpty()) {
            string = "???";
        } else {
            List<IndexColumn> list = index2.getColumns();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColumns(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        }
        return string;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof CassKey) {
            this.describeCassKey(presentation, (CassKey)o2);
        } else if (dasObject instanceof CassTableColumn) {
            this.describeCassTableColumn(presentation, (CassTableColumn)o2);
        } else {
            super.updatePresentation(project, o2, viewOptions, presentation);
        }
    }

    private final void describeCassKey(PresentationData presentation, CassKey key2) {
        presentation.addText(" " + this.describeCassKeyImpl(key2), DbPresentationCore.INFO_ATTRS);
    }

    private final void describeCassTableColumn(PresentationData presentation, CassTableColumn o2) {
        super.describeColumn(presentation, o2);
        if (o2.isStaticColumn()) {
            String string = " static";
            presentation.addText(string, DbPresentationCore.INFO_ATTRS);
        }
    }

    @Override
    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex index2, @NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        if (!(index2 instanceof CassIndex)) {
            return;
        }
        List<IndexColumn> list = ((CassIndex)index2).getColumns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getColumns(...)");
        String columns2 = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        presentation.addText(" (" + columns2 + ")", DbPresentationCore.INFO_ATTRS);
    }
}

