/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J4\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\u001eH\u0016J$\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010&\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0014J\u001a\u0010\t\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0010H\u0014J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0010H\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\fH\u0014J\u0010\u00102\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0010H\u0014J\u0018\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u001eH\u0002J\b\u00106\u001a\u00020\u0010H\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "Lcom/intellij/database/script/generator/NamingService;", "dbms", "Lcom/intellij/database/Dbms;", "plainNamePattern", "Ljava/util/regex/Pattern;", "casing", "Lcom/intellij/database/util/Casing;", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Lcom/intellij/database/util/Casing;)V", "getCasing", "()Lcom/intellij/database/util/Casing;", "closingQuote", "", "getClosingQuote", "()C", "closingQuotes", "", "getClosingQuotes", "()Ljava/lang/String;", "getDbms", "()Lcom/intellij/database/Dbms;", "openingQuote", "getOpeningQuote", "openingQuotes", "getOpeningQuotes", "reservedWords", "", "getReservedWords", "()Ljava/util/Set;", "canScript", "", "name", "catToScript", "catName", "kind", "Lcom/intellij/database/model/ObjectKind;", "plain", "forceQuoting", "enquote", "scrName", "op", "cl", "context", "Lcom/intellij/database/model/DasObject;", "getDefaultCasing", "isIdentifier", "isPlain", "isPure", "isQuotable", "isQuoted", "matchesCasing", "c", "identifier", "skipQuoting", "toString", "unquoteIdentifier", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractNamingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNamingService.kt\ncom/intellij/database/dialects/base/generator/AbstractNamingService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n970#2:114\n1041#2,3:115\n1064#2,2:120\n1855#3,2:118\n*S KotlinDebug\n*F\n+ 1 AbstractNamingService.kt\ncom/intellij/database/dialects/base/generator/AbstractNamingService\n*L\n75#1:114\n75#1:115,3\n98#1:120,2\n75#1:118,2\n*E\n"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Pattern plainNamePattern;
    @NotNull
    private final Casing casing;

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern plainNamePattern, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)plainNamePattern, (String)"plainNamePattern");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        this.dbms = dbms;
        this.plainNamePattern = plainNamePattern;
        this.casing = casing;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final Casing getCasing() {
        return this.casing;
    }

    private final Set<String> getReservedWords() {
        Set set;
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN)) {
            set = SetsKt.emptySet();
        } else {
            Object t = SqlLanguageDialect.EP.forDbms(this.dbms);
            Intrinsics.checkNotNull(t);
            Set set2 = ((SqlLanguageDialect)t).getReservedKeywords();
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getReservedKeywords(...)");
        }
        return set;
    }

    @Override
    public char getOpeningQuote() {
        return this.getOpeningQuotes().charAt(0);
    }

    @Override
    public char getClosingQuote() {
        return this.getClosingQuotes().charAt(0);
    }

    @Override
    @NotNull
    public String getOpeningQuotes() {
        return "\"";
    }

    @Override
    @NotNull
    public String getClosingQuotes() {
        return "\"";
    }

    @Override
    @NotNull
    public Casing getDefaultCasing() {
        return this.casing;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getDefaultCasing();
    }

    @Override
    @NotNull
    public String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain, @Nullable String openingQuotes, boolean forceQuoting) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        if (!forceQuoting && this.skipQuoting(catName, plain)) {
            return catName;
        }
        return this.enquote(catName, kind, openingQuotes);
    }

    @Override
    public boolean isQuoted(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (scrName.length() < 2) {
            return false;
        }
        int opIdx = StringsKt.indexOf$default((CharSequence)this.getOpeningQuotes(), (char)StringsKt.first((CharSequence)scrName), (int)0, (boolean)false, (int)6, null);
        if (opIdx == -1) {
            return false;
        }
        return StringsKt.last((CharSequence)scrName) == this.getClosingQuotes().charAt(opIdx);
    }

    protected boolean isQuotable(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        return true;
    }

    @Override
    @NotNull
    public String unquoteIdentifier(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (!this.isQuoted(scrName)) {
            return scrName;
        }
        char quote = StringsKt.last((CharSequence)scrName);
        String string = scrName.substring(1, scrName.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.replace$default((String)string, (String)("" + quote + quote), (String)String.valueOf(quote), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String enquote(@NotNull String scrName, @Nullable ObjectKind kind, @Nullable String openingQuotes) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (!this.isQuotable(scrName)) {
            return scrName;
        }
        String oq = this.getOpeningQuotes();
        String cq = this.getClosingQuotes();
        int any = 0;
        any = -1;
        String string = openingQuotes;
        if (string != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int j = 0; j < $this$mapTo$iv$iv.length(); ++j) {
                void it2;
                char item$iv$iv;
                char c2 = item$iv$iv = $this$mapTo$iv$iv.charAt(j);
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(StringsKt.indexOf$default((CharSequence)oq, (char)it2, (int)0, (boolean)false, (int)6, null));
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = (Iterable)new IntRange(0, StringsKt.getLastIndex((CharSequence)oq));
        }
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i2 = ((Number)element$iv).intValue();
            boolean bl = false;
            if (i2 == -1) continue;
            if (any == -1) {
                any = i2;
            }
            if (StringsKt.contains$default((CharSequence)scrName, (char)cq.charAt(i2), (boolean)false, (int)2, null)) continue;
            return this.enquote(scrName, oq.charAt(i2), cq.charAt(i2));
        }
        if (any == -1) {
            any = 0;
        }
        return this.enquote(scrName, oq.charAt(any), cq.charAt(any));
    }

    @NotNull
    protected String enquote(@NotNull String name2, char op, char cl) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        char c2 = op;
        String string = StringsKt.replace$default((String)name2, (String)String.valueOf(cl), (String)("" + cl + cl), (boolean)false, (int)4, null);
        return c2 + string + cl;
    }

    private final boolean skipQuoting(String name2, boolean plain) {
        return (plain || this.casing.plain == this.casing.quoted ? this.isPlain(name2) : this.isPure(name2)) && !this.getReservedWords().contains(name2);
    }

    @Override
    public boolean isPlain(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.isIdentifier(name2);
    }

    @Override
    public boolean isPure(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.isIdentifier(name2) && this.matchesCasing(name2);
    }

    private final boolean isIdentifier(String name2) {
        CharSequence charSequence = name2;
        return new Regex(this.plainNamePattern).matches(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean matchesCasing(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (this.casing.plain != Case.UPPER) {
            if (this.casing.plain != Case.LOWER) return true;
        }
        if (this.casing.plain == this.casing.quoted) return true;
        CharSequence $this$all$iv = identifier;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it2 = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (!this.matchesCasing(it2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean matchesCasing(char c2) {
        Case case_ = this.casing.plain;
        return switch (case_ == null ? -1 : WhenMappings.$EnumSwitchMapping$0[case_.ordinal()]) {
            case 1 -> {
                if (!Character.isLowerCase(c2)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!Character.isUpperCase(c2)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Override
    public boolean canScript(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.isPlain(name2) && !this.getReservedWords().contains(name2);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ":\n\tdbms: " + this.dbms + "\n\tcasing: " + this.casing + "\n\tplain pattern: " + this.plainNamePattern + "\n";
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Case.values().length];
            try {
                nArray[Case.UPPER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Case.LOWER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

