/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.basic.BasicLogin;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModLogin;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DatabaseAlterLoginHelper {
    DatabaseAlterLoginHelper() {
    }

    @Nullable
    static boolean canAlterLogin(@NotNull DatabaseConnectionConfig config) {
        String username;
        if (config == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(0);
        }
        if ((username = StringUtil.nullize((String)LocalDataSource.getUsername(config))) == null) {
            return false;
        }
        return DatabaseAlterLoginHelper.getMetaLogin(config) != null;
    }

    @Nullable
    private static BasicMetaObject<BasicModLogin> getMetaLogin(@NotNull DatabaseConnectionConfig config) {
        BasicModel model2;
        if (config == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(1);
        }
        BasicMetaModel<?> mm = (model2 = (BasicModel)ObjectUtils.tryCast((Object)config.getDataSource().getModel(), BasicModel.class)) == null ? DbImplUtilCore.getMetaModel(config.getDbms()) : model2.getMetaModel();
        return (BasicMetaObject)((JBTreeTraverser)JBTreeTraverser.of(o2 -> o2.children).withRoot(mm.root)).traverse().filterMap(o2 -> o2.tryCast(BasicModLogin.class)).first();
    }

    @Nullable
    static ScriptingResult generatePasswordChangeScript(@NotNull Project project, @NotNull DatabaseConnectionConfig config, @Nullable OneTimeString oldPass, @NotNull OneTimeString newPass) {
        BasicLogin user;
        if (project == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(3);
        }
        if (newPass == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(4);
        }
        if ((user = DatabaseAlterLoginHelper.getUser(config, oldPass)) == null) {
            return null;
        }
        BasicModModel newModel = ModelFactory.BLACK_HOLE.createModel(config.getDbms());
        BasicModLogin newUser = (BasicModLogin)ObjectUtils.tryCast((Object)ModelLightCopier.copy(user, newModel, true), BasicModLogin.class);
        if (newUser == null) {
            return null;
        }
        newUser.setPassword(newPass);
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(Objects.requireNonNull(user.getModel()), newModel);
        builder.setCorrespondence(Collections.singleton(ElementDelta.create(user, newUser)));
        return ScriptGenerators.INSTANCE.makeScript(project, builder.build());
    }

    @Nullable
    private static BasicLogin getUser(@NotNull DatabaseConnectionConfig config, @Nullable OneTimeString oldPassword) {
        BasicMetaObject<BasicModLogin> metaLogin;
        String username;
        if (config == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(5);
        }
        if ((username = StringUtil.nullize((String)LocalDataSource.getUsername(config))) == null) {
            return null;
        }
        BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)config.getDataSource().getModel(), BasicModel.class);
        BasicLogin login = model2 == null ? null : (BasicLogin)((JBTreeTraverser)model2.traverser().filter(DasUtil.byName(username))).filter(BasicLogin.class).first();
        BasicModModel newModel = ModelFactory.BLACK_HOLE.createModel(config.getDbms());
        BasicMetaObject<BasicModLogin> basicMetaObject = metaLogin = login == null ? DatabaseAlterLoginHelper.getMetaLogin(config) : login.getMetaObject().tryCast(BasicModLogin.class);
        if (metaLogin == null) {
            return null;
        }
        BasicLogin mutableLogin = login != null ? (BasicLogin)((Object)ModelLightCopier.copy(newModel, login, true)) : DatabaseAlterLoginHelper.instantiateUser(newModel, metaLogin, username);
        newModel.modify(mutableLogin, BasicModLogin.class, l -> l.setPassword(oldPassword));
        return mutableLogin;
    }

    private static BasicModLogin instantiateUser(BasicModModel newModel, BasicMetaObject<BasicModLogin> metaLogin, String username) {
        Ref res2 = Ref.create();
        newModel.modify(BasicModRoot.class, r -> {
            BasicModLogin l = (BasicModLogin)DatabaseAlterLoginHelper.instantiate(r, metaLogin);
            if (l != null) {
                l.setName(username);
                l.setNameScripted(true);
                l.setNameQuoted(false);
            }
            res2.set((Object)l);
        });
        return (BasicModLogin)res2.get();
    }

    private static <T extends BasicModElement> T instantiate(@NotNull BasicModRoot r, @NotNull BasicMetaObject<T> meta) {
        ModFamily family;
        if (r == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            DatabaseAlterLoginHelper.$$$reportNull$$$0(7);
        }
        if (r.getMetaObject() == meta) {
            return (T)((BasicModElement)meta.tryCast(r));
        }
        BasicMetaObject<BasicModElement> p2 = meta.getParent() == null ? null : meta.getParent().tryCast(BasicModElement.class);
        BasicModElement parent2 = p2 == null ? null : DatabaseAlterLoginHelper.instantiate(r, p2);
        ModFamily modFamily = family = parent2 == null ? null : (ModFamily)BasicMetaUtils.getFamily(parent2, meta);
        if (family == null) {
            return null;
        }
        return (T)family.createNewOne();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/DatabaseAlterLoginHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canAlterLogin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMetaLogin";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePasswordChangeScript";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getUser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

