/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.editor.DbImportAutoTableManager;
import com.intellij.database.dbimport.editor.DbImportCachedDataManager;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.DbQuerySourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.DetectedColumnsData;
import com.intellij.database.dbimport.editor.data.FakeRootData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.data.ScriptedSourceData;
import com.intellij.database.dbimport.editor.editor.DbAutoDefinitionEditor;
import com.intellij.database.dbimport.editor.editor.DbAutoReferenceEditor;
import com.intellij.database.dbimport.editor.editor.DbCharsetEditor;
import com.intellij.database.dbimport.editor.editor.DbCrossDsReferenceEditor;
import com.intellij.database.dbimport.editor.editor.DbCsvColumnsEditor;
import com.intellij.database.dbimport.editor.editor.DbCsvFormatEditor;
import com.intellij.database.dbimport.editor.editor.DbErrorsPathEditor;
import com.intellij.database.dbimport.editor.editor.DbMappingColumnsEditor;
import com.intellij.database.dbimport.editor.editor.DbPathEditor;
import com.intellij.database.dbimport.editor.editor.DbScriptLoaderEditor;
import com.intellij.database.dbimport.editor.model.applier.DbAutoDefinitionApplier;
import com.intellij.database.dbimport.editor.model.applier.DbAutoReferenceApplier;
import com.intellij.database.dbimport.editor.model.applier.DbAutoReferenceMultiApplier;
import com.intellij.database.dbimport.editor.model.applier.DbCrossDsReferenceModelApplier;
import com.intellij.database.dbimport.editor.model.applier.DbDetectedColumnListModelApplier;
import com.intellij.database.dbimport.editor.model.applier.DbMappingColumnsApplier;
import com.intellij.database.dbimport.editor.model.state.DbAutoDefinitionState;
import com.intellij.database.dbimport.editor.model.state.DbAutoReferenceModelState;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.WrapperElement;
import com.intellij.database.model.basic.WrapperElementFactory;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbDirectReferenceModelMultiApplier;
import com.intellij.database.schemaEditor.model.applier.DbIndirectReferenceModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbDirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeTreeModel;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImportEditorBuilder
extends DbObjectEditorBuilder {
    @Override
    @Nullable
    protected <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditorImpl(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model2) {
        DbModelState s2;
        S s3;
        S s4;
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(1);
        }
        if (model2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(2);
        }
        if ((s4 = model2.getState()) instanceof DbAutoDefinitionState) {
            DbAutoDefinitionState as = (DbAutoDefinitionState)s4;
            return new DbAutoDefinitionEditor<E>(controller, model2.castState(as));
        }
        BasicMetaId key2 = model2.getModelInternalKey();
        if (key2 == MappingData.COLUMN_MAPPINGS && (s3 = model2.getState()) instanceof DbCollectionModelState) {
            s2 = (DbCollectionModelState)s3;
            return new DbMappingColumnsEditor<E>(controller, model2.castState(s2.tryCast(MappingData.COLUMN_MAPPINGS)));
        }
        if (key2 == DetectedColumnsData.COLUMNS && (s3 = model2.getState()) instanceof DbCollectionModelState) {
            s2 = (DbCollectionModelState)s3;
            return new DbCsvColumnsEditor<E>(controller, model2.castState(s2.tryCast(DetectedColumnsData.COLUMNS)));
        }
        if (key2 == MappingData.TABLE_REF && (s3 = model2.getState()) instanceof DbAutoReferenceModelState) {
            s2 = (DbAutoReferenceModelState)s3;
            return new DbAutoReferenceEditor(controller, model2.castState(s2));
        }
        if (key2 == MappingData.SCHEMA_REF && (s3 = model2.getState()) instanceof DbDirectReferenceModelState) {
            s2 = (DbDirectReferenceModelState)s3;
            return new DbCrossDsReferenceEditor(controller, model2.castState(s2));
        }
        if (key2 == DbTableSourceData.TABLE_REF && (s3 = model2.getState()) instanceof DbDirectReferenceModelState) {
            s2 = (DbDirectReferenceModelState)s3;
            return new DbCrossDsReferenceEditor(controller, model2.castState(s2));
        }
        if (key2 == DbQuerySourceData.TARGET_REF && (s3 = model2.getState()) instanceof DbDirectReferenceModelState) {
            s2 = (DbDirectReferenceModelState)s3;
            return new DbCrossDsReferenceEditor(controller, model2.castState(s2));
        }
        if (key2 == CsvSourceData.PATH && (s3 = model2.getState()) instanceof DbTextModelState) {
            s2 = (DbTextModelState)s3;
            return new DbPathEditor<E>(controller, model2.castState(s2));
        }
        if (key2 == MappingData.ERRORS_PATH && (s3 = model2.getState()) instanceof DbTextModelState) {
            s2 = (DbTextModelState)s3;
            return new DbErrorsPathEditor<E>(controller, model2.castState(s2));
        }
        if (key2 == CsvSourceData.CHARSET && (s3 = model2.getState()) instanceof DbSingleValueModelState) {
            s2 = (DbSingleValueModelState)s3;
            return new DbCharsetEditor<E>(controller, model2.castState(s2));
        }
        if (key2 == CsvSourceData.CSV_FORMAT && (s3 = model2.getState()) instanceof DbSingleValueModelState) {
            s2 = (DbSingleValueModelState)s3;
            return new DbCsvFormatEditor<E>(controller, model2.castState(s2));
        }
        if (key2 == ScriptedSourceData.LOADER && (s3 = model2.getState()) instanceof DbSingleValueModelState) {
            s2 = (DbSingleValueModelState)s3;
            return new DbScriptLoaderEditor<E>(controller, model2.castState(s2));
        }
        return super.createObjectEditorImpl(factory, controller, model2);
    }

    @Override
    protected <E extends BasicElement> boolean createReferenceEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, ?> reference, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models2) {
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(3);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(4);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(6);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(7);
        }
        if (models2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(8);
        }
        if (reference.id == MappingData.DATA_SOURCE_REF) {
            return true;
        }
        return super.createReferenceEditorModel(factory, controller, id, reference, fields, models2);
    }

    @Override
    protected <E extends BasicElement> boolean createPropertyEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models2) {
        DbImportCachedDataManager checker;
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(9);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(10);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(11);
        }
        if (property == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(12);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(13);
        }
        if (models2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(14);
        }
        if (property.id == MappingData.AUTO_NAME) {
            return true;
        }
        if (property.id == DbTableSourceData.USE_CACHED && (checker = DbImportCachedDataManager.getInstance(controller)) != null && !checker.hasCachedData(id)) {
            return true;
        }
        return super.createPropertyEditorModel(factory, controller, id, property, fields, models2);
    }

    @Override
    @Nullable
    protected <E extends BasicElement> DbEditorModel<E, ?> createPropertyEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields) {
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(15);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(16);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(17);
        }
        if (property == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(18);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(19);
        }
        if (property.id == MappingData.COLUMN_MAPPINGS) {
            DbMappingColumnsApplier<E> applier = new DbMappingColumnsApplier<E>(property.asId(MappingData.COLUMN_MAPPINGS));
            DbCollectionModelState<MappingData.ColumnMapping> state = new DbCollectionModelState<MappingData.ColumnMapping>(applier);
            return new DbEditorModelBase<E, DbCollectionModelState<MappingData.ColumnMapping>>(controller, id, factory.getTitle(id, property.id), state, applier, null);
        }
        if (property.id == DetectedColumnsData.COLUMNS) {
            DbDetectedColumnListModelApplier<E> applier = new DbDetectedColumnListModelApplier<E>(property.asId(DetectedColumnsData.COLUMNS));
            DbCollectionModelState<DetectedColumnsData.Column> state = new DbCollectionModelState<DetectedColumnsData.Column>(applier);
            return new DbEditorModelBase<E, DbCollectionModelState<DetectedColumnsData.Column>>(controller, id, factory.getTitle(id, property.id), state, applier, null);
        }
        return super.createPropertyEditorModel(factory, controller, id, property, fields);
    }

    @Override
    @Nullable
    protected <E extends BasicElement, T extends BasicElement> DbEditorModel<E, ?> createReferenceEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, T> reference, @NotNull List<BasicMetaField<E>> fields) {
        BasicMetaReference<E, WrapperElement<DataSourceData>> dsRef2;
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(20);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(21);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(22);
        }
        if (reference == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(23);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(24);
        }
        if (id.getMetaObject().kind == MappingData.KIND && reference.id == MappingData.SCHEMA_REF && (dsRef2 = id.getMetaObject().getReference(MappingData.DATA_SOURCE_REF)) != null) {
            DbDirectReferenceModelState state = new DbDirectReferenceModelState();
            return new DbEditorModelBase(controller, id, factory.getTitle(id, reference.id), state, new DbCrossDsReferenceModelApplier(reference, dsRef2), new DbDirectReferenceModelMultiApplier());
        }
        if (id.getMetaObject().kind == MappingData.KIND && reference.id == MappingData.TABLE_REF) {
            DbAutoReferenceApplier applier = new DbAutoReferenceApplier(reference, DbIndirectReferenceModelApplier.TEXT_PARSER);
            DbAutoReferenceModelState state = new DbAutoReferenceModelState(v2 -> applier.toReference(controller.getDbms(id), v2));
            return new DbEditorModelBase(controller, id, factory.getTitle(id, reference.id), state, applier, new DbAutoReferenceMultiApplier());
        }
        if (id.getMetaObject().kind == DbTableSourceData.KIND && reference.id == DbTableSourceData.TABLE_REF && (dsRef2 = id.getMetaObject().getReference(DbTableSourceData.DATA_SOURCE_REF)) != null) {
            DbDirectReferenceModelState state = new DbDirectReferenceModelState();
            return new DbEditorModelBase(controller, id, factory.getTitle(id, reference.id), state, new DbCrossDsReferenceModelApplier(reference, dsRef2), new DbDirectReferenceModelMultiApplier());
        }
        if (id.getMetaObject().kind == DbQuerySourceData.KIND && reference.id == DbQuerySourceData.TARGET_REF && (dsRef2 = id.getMetaObject().getReference(DbQuerySourceData.DATA_SOURCE_REF)) != null) {
            DbDirectReferenceModelState state = new DbDirectReferenceModelState();
            return new DbEditorModelBase(controller, id, factory.getTitle(id, reference.id), state, new DbCrossDsReferenceModelApplier(reference, dsRef2), new DbDirectReferenceModelMultiApplier());
        }
        return super.createReferenceEditorModel(factory, controller, id, reference, fields);
    }

    @Override
    protected boolean isIncludedInStructured(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(25);
        }
        return super.isIncludedInStructured(meta) && meta.kind != DataSourceData.KIND;
    }

    @Override
    public boolean shouldHaveEditor(@NotNull DbModelRef<?, ?> model2) {
        if (model2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(26);
        }
        return super.shouldHaveEditor(model2) && model2.getModelInternalKey() != DbAutoDefinitionState.ID;
    }

    @Override
    @NotNull
    public <E extends BasicElement> List<DbEditorModel<E, ?>> createObjectPropertiesModels(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable List<BasicMetaId> invalid) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(27);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(28);
        }
        List<DbEditorModel<DbEditorModelBase<E, DbAutoDefinitionState>, ?>> models2 = super.createObjectPropertiesModels(controller, id, invalid);
        if (id.getMetaObject().kindOf(BasicTable.class)) {
            models2.add(new DbEditorModelBase<E, DbAutoDefinitionState>(controller, id, null, new DbAutoDefinitionState(), new DbAutoDefinitionApplier(), null));
        }
        List<DbEditorModel<DbEditorModelBase<E, DbAutoDefinitionState>, ?>> list = models2;
        if (list == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Override
    @Nullable
    public Icon getIcon(BasicElement properties2) {
        if (properties2.getMetaObject().kind == CsvSourceData.KIND) {
            return DatabaseIcons.FileFormat;
        }
        if (properties2.getMetaObject().kind == DbTableSourceData.KIND) {
            return DatabaseIcons.Table;
        }
        if (properties2.getMetaObject().kind == DbQuerySourceData.KIND) {
            return AllIcons.Nodes.DataSchema;
        }
        if (properties2.getMetaObject().kind == ScriptedSourceData.KIND) {
            return DatabaseIcons.Udf_script;
        }
        if (properties2.getMetaObject().kind == MappingData.KIND) {
            return DatabaseIcons.Synonym;
        }
        return super.getIcon(properties2);
    }

    @Override
    public boolean isUnaligned(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(30);
        }
        return super.isUnaligned(editor2) || editor2.getModelInternalKey() == CsvSourceData.FIRST_ROW_IS_HEADER || editor2.getModelInternalKey() == CsvSourceData.FIRST_COLUMN_IS_HEADER || editor2.getModelInternalKey() == CsvSourceData.TRIM_WHITESPACES;
    }

    @Override
    public boolean startsNewLine(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(31);
        }
        return super.startsNewLine(editor2) || editor2.getModelInternalKey() == CsvSourceData.FIRST_ROW_IS_HEADER;
    }

    @Override
    public boolean isBigSqlEditor(@NotNull DbModelRef<?, DbTextModelState> model2, @NotNull DbObjectEditorFactory factory) {
        if (model2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(32);
        }
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(33);
        }
        return super.isBigSqlEditor(model2, factory) || model2.getModelInternalKey() == DbQuerySourceData.QUERY;
    }

    @Override
    public boolean isHideFromStructure(@NotNull DbModelRef<?, ?> ref2) {
        DbStructureFamilyModelState fs;
        if (ref2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(34);
        }
        if (super.isHideFromStructure(ref2)) {
            return true;
        }
        Object obj2 = ref2.getState();
        return obj2 instanceof DbStructureFamilyModelState && DbImportEditorBuilder.isHiddenGroup((fs = (DbStructureFamilyModelState)obj2).getMetaObject());
    }

    @Override
    @Nullable
    public String getLocationText(@NotNull DbEditorController controller, @NotNull ElementIdentity<?> identity) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(35);
        }
        if (identity == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(36);
        }
        if ((kind = identity.getMetaObject().kind) == DbTableSourceData.KIND) {
            ElementIdentity<BasicLikeTable> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, DbTableSourceData.TABLE_REF);
            return this.computeLocationString(controller, tgtId);
        }
        if (kind == MappingData.KIND) {
            ElementIdentity<BasicTable> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, MappingData.TABLE_REF);
            return this.computeLocationString(controller, tgtId);
        }
        if (kind == DbQuerySourceData.KIND) {
            ElementIdentity<BasicNamespace> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, DbQuerySourceData.TARGET_REF);
            return this.computePathString(controller, tgtId);
        }
        return super.getLocationText(controller, identity);
    }

    private static boolean isHiddenGroup(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(37);
        }
        return DbImportDataPreviewManager.Companion.isSourceKind(meta.kind) || meta.kind == MappingData.KIND;
    }

    @Override
    @NotNull
    public Dbms getDbms(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        RawDataSource ds;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(38);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(39);
        }
        if (id.getMetaObject().kind == DataSourceData.KIND && (ds = DataSourceData.getDataSource(controller, id)) != null) {
            Dbms dbms = ds.getDbms();
            if (dbms == null) {
                DbImportEditorBuilder.$$$reportNull$$$0(40);
            }
            return dbms;
        }
        ElementIdentity<?> dsId = DbImportEditorBuilder.getAssociatedElementId(controller, id);
        if (dsId != null) {
            Dbms dbms = this.getDbms(controller, dsId);
            if (dbms == null) {
                DbImportEditorBuilder.$$$reportNull$$$0(41);
            }
            return dbms;
        }
        Dbms dbms = super.getDbms(controller, id);
        if (dbms == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(42);
        }
        return dbms;
    }

    @Override
    @Nullable
    public Version getServerVersion(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        RawDataSource ds;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(43);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(44);
        }
        if (id.getMetaObject().kind == DataSourceData.KIND && (ds = DataSourceData.getDataSource(controller, id)) != null) {
            return ds.getVersion();
        }
        ElementIdentity<?> dsId = DbImportEditorBuilder.getAssociatedElementId(controller, id);
        if (dsId != null) {
            return this.getServerVersion(controller, dsId);
        }
        return super.getServerVersion(controller, id);
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayNamePrefix(@NotNull ElementIdentity<?> id) {
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(45);
        }
        if (DbImportDataPreviewManager.Companion.isSourceKind(id.getMetaObject().kind)) {
            return DatabaseBundle.message("import.source.label", new Object[0]);
        }
        if (DbImportDataPreviewManager.Companion.isTargetKind(id.getMetaObject().kind)) {
            return DatabaseBundle.message("import.target.label", new Object[0]);
        }
        return super.getDisplayNamePrefix(id);
    }

    @Nullable
    private static ElementIdentity<?> getAssociatedElementId(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(46);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(47);
        }
        if ((kind = id.getMetaObject().kind) == DbTableSourceData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, DbTableSourceData.TABLE_REF);
        }
        if (kind == DbQuerySourceData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, DbQuerySourceData.TARGET_REF);
        }
        if (kind == MappingData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, MappingData.TABLE_REF);
        }
        return null;
    }

    @Override
    @Nullable
    protected String getStructureRootGroup(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> rootId2, @NotNull DbModelRef<?, ? extends DbStructureNodeState<?, ?>> checkRef) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(48);
        }
        if (rootId2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(49);
        }
        if (checkRef == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(50);
        }
        ElementMatcher matcher = controller.getMatcher();
        if (checkRef.getIdentity() == rootId2) {
            return checkRef.getState() instanceof DbStructureFamilyModelState ? "" : null;
        }
        if (checkRef.getState() instanceof DbStructureObjectModelState) {
            DbEditorModel<?, DbStructureObjectModelState<?>> node2;
            ElementIdentity<?> parent2 = matcher.getParent(checkRef.getIdentity());
            DbEditorModel<?, DbStructureObjectModelState<?>> dbEditorModel = node2 = parent2 == null ? null : controller.getStructureNodeModel(parent2);
            if (node2 != null) {
                return null;
            }
            DbAutoDefinitionState autoDefState = DbAutoDefinitionState.resolve(controller, checkRef.getIdentity());
            return autoDefState == null || autoDefState.isInManualMode() ? checkRef.getIdentity().getMetaObject().kind.getPluralPresentableName() : null;
        }
        return null;
    }

    @Override
    @Nullable
    protected DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getAffectedStructureNodeByChange(@NotNull DbEditorModel<?, ?> m) {
        if (m == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(51);
        }
        return m.getState() instanceof DbAutoDefinitionState ? DbModelRef.create(m.getController().getStructureNodeModel(m.getIdentity())) : null;
    }

    @Override
    @Nullable
    public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> meta) {
        if (meta != null && meta.kind == ObjectKind.ROOT) {
            return DataSourceData.META.get(FakeRootData.META);
        }
        return super.getParent(meta);
    }

    @Override
    protected <E extends BasicElement> void prepareProperties(DbObjectEditorFactory factory, BasicMetaObject<E> meta, List<BasicMetaField<E>> fields) {
        super.prepareProperties(factory, meta, fields);
        if (meta.kind == MappingData.KIND) {
            ModelHelper.moveTo(fields, 0, MappingData.SCHEMA_REF, MappingData.TABLE_REF, MappingData.COLUMN_MAPPINGS);
        } else if (meta.kind == DbQuerySourceData.KIND) {
            ModelHelper.moveTo(fields, 0, DbQuerySourceData.TARGET_REF, DbQuerySourceData.QUERY, DbQuerySourceData.USE_CACHED);
        } else if (meta.kind == DbTableSourceData.KIND) {
            ModelHelper.moveTo(fields, 0, DbTableSourceData.TABLE_REF, DbTableSourceData.USE_CACHED);
        } else if (meta.kind == CsvSourceData.KIND) {
            ModelHelper.moveTo(fields, 0, CsvSourceData.PATH, CsvSourceData.CHARSET, CsvSourceData.CSV_FORMAT, CsvSourceData.FIRST_ROW_IS_HEADER, CsvSourceData.FIRST_COLUMN_IS_HEADER, CsvSourceData.TRIM_WHITESPACES);
        }
    }

    @Override
    public <T extends BasicElement> void initNewObject(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child, @NotNull ModelHelper.ObjectKindVariant variant, int position, @NotNull Set<DbModelRef<?, ? extends DbStructureNodeState<?, ?>>> selection2) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(52);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(53);
        }
        if (variant == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(54);
        }
        if (selection2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(55);
        }
        super.initNewObject(controller, child, variant, position, selection2);
        ElementIdentity<T> identity = child.getIdentity();
        if (identity.getMetaObject().kind == CsvSourceData.KIND) {
            this.initCsvSource(controller, child);
        } else if (identity.getMetaObject().kind == DbTableSourceData.KIND) {
            this.initDbSource(controller, child);
        }
    }

    @Override
    @NotNull
    public DefaultActionGroup createStructureContextMenu() {
        DefaultActionGroup group2 = super.createStructureContextMenu();
        group2.add((AnAction)new SetAutomaticAction());
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(56);
        }
        return defaultActionGroup;
    }

    private <T extends BasicElement> void initCsvSource(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(57);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(58);
        }
        ElementIdentity<T> identity = child.getIdentity();
        this.addObjectToFamily(controller, child, MappingData.META.get(identity.getMetaObject()));
    }

    private <T extends BasicElement> void initDbSource(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(59);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(60);
        }
        ElementIdentity<T> identity = child.getIdentity();
        this.addObjectToFamily(controller, child, MappingData.META.get(identity.getMetaObject()));
    }

    private <P extends BasicElement, T extends BasicElement> void addObjectToFamily(@NotNull DbEditorModelController controller, @NotNull DbModelRef<P, DbStructureObjectModelState<P>> parent2, @NotNull BasicMetaObject<T> meta) {
        DbModelRef<P, DbStructureFamilyModelState<T>> family;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(61);
        }
        if (parent2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(62);
        }
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(63);
        }
        if ((family = parent2.getState().getFamily(meta)) == null) {
            return;
        }
        ElementIdentity<P> parentId = parent2.getIdentity();
        ElementIdentity<T> childId = controller.getMatcher().create(parentId, meta);
        DbEditorModel<T, DbStructureObjectModelState<T>> child = this.createStructureNodeModel(controller, childId);
        family.getState().setCollection(controller, ContainerUtil.append(family.getState().getCollection(), (Object[])new DbModelRef[]{new DbModelRef<T, DbStructureObjectModelState<T>>(child)}));
    }

    @Override
    public boolean isEnabled(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, @Nullable BasicElement e2, @NotNull BasicMetaId prop) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(64);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(65);
        }
        if (prop == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(66);
        }
        if ((kind = id.getMetaObject().kind) == MappingData.KIND) {
            if (prop == MappingData.DISABLE_CONSTRAINTS) {
                ElementIdentity<BasicTable> tableId = DbReferenceModelState.resolveReference(controller, id, MappingData.TABLE_REF);
                if (tableId == null) {
                    return true;
                }
                Dbms dbms = controller.getDbms(tableId);
                Version version = this.getServerVersion(controller, id);
                return ImportManager.of(dbms, version).isSupportFastMode();
            }
            if (prop == MappingData.ERRORS_PATH) {
                MappingData m = WrapperElementFactory.getDelegate(e2, MappingData.class);
                return m == null || m.getDumpErrors();
            }
        }
        if ((kind == DbTableSourceData.KIND || kind == DbQuerySourceData.KIND) && prop == DbTableSourceData.USE_CACHED) {
            DbImportCachedDataManager cachedDataManager = DbImportCachedDataManager.getInstance(controller);
            return cachedDataManager != null && cachedDataManager.isCachedDataAvailable(id, e2);
        }
        return super.isEnabled(controller, id, e2, prop);
    }

    @Override
    public boolean canDrop(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> element2) {
        DbAutoDefinitionState autoDef;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(67);
        }
        if (element2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(68);
        }
        if ((autoDef = DbAutoDefinitionState.resolve(controller, element2)) != null && !autoDef.getAutoDefinitionSources().isEmpty()) {
            return false;
        }
        return super.canDrop(controller, element2);
    }

    @Override
    @Nullable
    public DbDataSource getDataSource(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        ElementIdentity<?> assId;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(69);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(70);
        }
        if ((assId = DbImportEditorBuilder.getAssociatedElementId(controller, id)) != null) {
            return this.getDataSource(controller, assId);
        }
        return DataSourceData.getDbDataSource(controller, id);
    }

    @Override
    public <T extends BasicElement> String getDisplayName(@NotNull ElementIdentity<T> id, @NotNull T properties2) {
        ObjectKind kind;
        String name2;
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(71);
        }
        if (properties2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(72);
        }
        if ((name2 = properties2.getName()).isEmpty() && !(id instanceof MultiElementIdentity) && ((kind = id.getMetaObject().kind) == MappingData.KIND || kind == CsvSourceData.KIND || kind == DbTableSourceData.KIND)) {
            return DatabaseBundle.message("label.incomplete", new Object[0]);
        }
        return super.getDisplayName(id, properties2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 29, 40, 41, 42, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 16: 
            case 21: 
            case 27: 
            case 35: 
            case 38: 
            case 43: 
            case 46: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 22: 
            case 28: 
            case 39: 
            case 44: 
            case 45: 
            case 47: 
            case 65: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 13: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 25: 
            case 37: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 29: 
            case 40: 
            case 41: 
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkRef";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 53: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectPropertiesModels";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureContextMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditorImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceEditorModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditorModel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedInStructured";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldHaveEditor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPropertiesModels";
                break;
            }
            case 29: 
            case 40: 
            case 41: 
            case 42: 
            case 56: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isUnaligned";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsNewLine";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isBigSqlEditor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isHideFromStructure";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocationText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenGroup";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getServerVersion";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayNamePrefix";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElementId";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getStructureRootGroup";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStructureNodeByChange";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "initNewObject";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "initCsvSource";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "initDbSource";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addObjectToFamily";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 29, 40, 41, 42, 56 -> new IllegalStateException(string);
        };
    }

    public static class SetAutomaticAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SetAutomaticAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                SetAutomaticAction.$$$reportNull$$$0(1);
            }
            JBIterable<DbStructureNodeEditor<?, ?>> nodes = SetAutomaticAction.getDetachableNodes(e2);
            DbStructureNodeEditor first2 = (DbStructureNodeEditor)nodes.first();
            e2.getPresentation().setText(first2 != null && DbEditorUtilsKt.existsOriginally(first2.getController(), first2.getIdentity()) ? DatabaseBundle.message("action.import.hide.text", new Object[0]) : DatabaseBundle.message("action.import.set.automatic.text", new Object[0]));
            e2.getPresentation().setEnabledAndVisible(nodes.isNotEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                SetAutomaticAction.$$$reportNull$$$0(2);
            }
            for (DbStructureNodeEditor node2 : SetAutomaticAction.getDetachableNodes(e2)) {
                DbEditorModelController controller = node2.getController().getModelController();
                DbAutoDefinitionState autoState = DbAutoDefinitionState.resolve(controller, node2.getIdentity());
                if (autoState == null) continue;
                if (DbImportAutoTableManager.Companion.canBeDefinedByMapping(controller, node2.getIdentity())) {
                    for (DbEditor<?, ?> editor2 : node2.getController().getAllEditors()) {
                        DbAutoReferenceEditor cde;
                        if (!(editor2 instanceof DbAutoReferenceEditor) || ((DbAutoReferenceModelState)(cde = (DbAutoReferenceEditor)editor2).getState()).getTargetId() != node2.getIdentity()) continue;
                        cde.setDefinesTable(true);
                        break;
                    }
                }
                autoState.setInManualMode(false);
            }
        }

        @NotNull
        private static JBIterable<DbStructureNodeEditor<?, ?>> getDetachableNodes(@NotNull AnActionEvent e2) {
            DbStructureEditor editor2;
            if (e2 == null) {
                SetAutomaticAction.$$$reportNull$$$0(3);
            }
            if ((editor2 = (DbStructureEditor)e2.getData(DbStructureEditor.KEY)) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    SetAutomaticAction.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            JBIterable jBIterable = DbStructureEditorActions.getSelectedNodes(e2).filter(n -> SetAutomaticAction.isDetachable(editor2, n)).collect();
            if (jBIterable == null) {
                SetAutomaticAction.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static boolean isDetachable(DbStructureEditor<?> editor2, DbStructureNodeEditor<?, ?> n) {
            DbEditorModelController modelController = n.getController().getModelController();
            DbAutoDefinitionState autoDefState = DbAutoDefinitionState.resolve(modelController, n.getIdentity());
            if (autoDefState == null || !autoDefState.isInManualMode()) {
                return false;
            }
            ElementOwner oOwner = modelController.getMatcher().getOriginalOwner();
            if (oOwner != null && autoDefState.getAutoDefinitionSources().isEmpty() && oOwner.find(n.getIdentity()) == null) {
                return false;
            }
            DbStructureNodeTreeModel structure = editor2.getStructure();
            if (!(structure.getParentNode(n) instanceof DbStructureModelState.Group)) {
                return false;
            }
            FileStatus status = DbVisualEditorBase.getStatus(n);
            return status == FileStatus.ADDED || status == FileStatus.NOT_CHANGED;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder$SetAutomaticAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder$SetAutomaticAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetachableNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDetachableNodes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

