/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataImporter {
    private static final Set<DasTable> ourBusyTables = ConcurrentCollectionFactory.createConcurrentSet();
    private final Project myProject;
    private final DbNamespace myNamespace;
    @Nullable
    private final DbTable myExistingTable;
    private final ReaderTask.SourceFactory mySourceType;
    private final ImportInfo myInfo;

    public DataImporter(@NotNull Project project, @NotNull ReaderTask.SourceFactory sourceType, @NotNull ImportInfo info2) {
        if (project == null) {
            DataImporter.$$$reportNull$$$0(0);
        }
        if (sourceType == null) {
            DataImporter.$$$reportNull$$$0(1);
        }
        if (info2 == null) {
            DataImporter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        ImportEditorContext context = (ImportEditorContext)info2.getContext();
        this.myNamespace = Objects.requireNonNull(context.getNamespace());
        this.myExistingTable = (DbTable)DbSqlUtilCore.findElement(this.myNamespace.getDataSource(), info2.getTablePath());
        this.mySourceType = sourceType;
        this.myInfo = info2;
    }

    @NotNull
    public ImportInfo getImportInfo() {
        ImportInfo importInfo = this.myInfo;
        if (importInfo == null) {
            DataImporter.$$$reportNull$$$0(3);
        }
        return importInfo;
    }

    @NotNull
    public AsyncTask<Boolean> importData() throws IOException {
        if (this.myInfo == null) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            if (asyncTask == null) {
                DataImporter.$$$reportNull$$$0(4);
            }
            return asyncTask;
        }
        AsyncTask<Boolean> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.importing.data", new Object[0])).computeAsync(null, () -> {
            DbDataSource dataSource2 = this.myNamespace.getDataSource();
            Dbms dbms = dataSource2.getDbms();
            this.lockTable();
            boolean shouldUnlock = true;
            try {
                DasNamespace namespace = DbImplUtilCore.getSearchPathObjectForSwitch(this.myNamespace);
                ReaderTask.Source source = this.mySourceType.createSource(this.myInfo);
                ImportDatabaseModifier modifier = new ImportDatabaseModifier(this.myProject, DbImplUtilCore.getLocalDataSource(dataSource2), this.myInfo, dbms, source, ObjectPaths.searchPathOf(namespace));
                modifier.include(DasObjectFun.getBasicElement(this.myNamespace));
                modifier.setElementToFocus(this.myInfo.getTablePath());
                AsyncTask<Boolean> task = modifier.runStatements(false).whenComplete(null, (r, e2) -> this.unlockTable());
                shouldUnlock = false;
                AsyncTask<Boolean> asyncTask = task;
                return asyncTask;
            }
            finally {
                if (shouldUnlock) {
                    this.unlockTable();
                }
            }
        });
        if (asyncTask == null) {
            DataImporter.$$$reportNull$$$0(5);
        }
        return asyncTask;
    }

    private void lockTable() {
        if (!Objects.requireNonNull(this.myInfo).shouldLockTable()) {
            return;
        }
        if (this.myExistingTable != null) {
            ourBusyTables.add(this.myExistingTable);
        }
    }

    private void unlockTable() {
        if (!Objects.requireNonNull(this.myInfo).shouldLockTable()) {
            return;
        }
        if (this.myExistingTable != null) {
            ourBusyTables.remove(this.myExistingTable);
        }
    }

    public static boolean isBusy(@Nullable Object element2) {
        DasTable table = DataImporter.getElement(element2);
        return table != null && ourBusyTables.contains(table);
    }

    private static DasTable getElement(@Nullable Object element2) {
        return element2 instanceof DasTableChild ? ((DasTableChild)element2).getTable() : (element2 instanceof DasTable ? (DasTable)element2 : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DataImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DataImporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "importData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

