/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.data.types.BaseConversionGraph;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DbConversionGraph;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DbGridHelper;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.TypesMutator;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.objects.DasGridDataHookUp;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DbGridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactories;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultNumericRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DataBusGridUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridUtil
extends GridUtil {
    public static final Logger LOG = Logger.getInstance(DataGridUtil.class);

    private DataGridUtil() {
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            DataGridUtil.$$$reportNull$$$0(2);
        }
        DataGrid dataGrid = DataGridUtil.createDataGrid((Project)project, dataHookUp, (ActionGroup)popupActions, DataGridUtil::configure);
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(3);
        }
        return dataGrid;
    }

    @NotNull
    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(4);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(5);
        }
        DataGrid dataGrid = DataGridUtil.createPreviewDataGrid((Project)project, dataHookUp, DataGridUtil::configure);
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(6);
        }
        return dataGrid;
    }

    public static void configure(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(7);
        }
        if (appearance == null) {
            DataGridUtil.$$$reportNull$$$0(8);
        }
        GridCellEditorHelper.set((CoreGrid)grid, (GridCellEditorHelper)new DbGridCellEditorHelper());
        GridHelper.set((CoreGrid)grid, (GridHelper)new DbGridHelper((Function0<Dbms>)((Function0)() -> DataGridUtil.getDbms(grid))));
        GridCellEditorFactoryProvider.set((DataGrid)grid, (GridCellEditorFactoryProvider)GridCellEditorFactories.getInstance());
        List<GridCellRendererFactory> factories = Arrays.asList(new DefaultBooleanRendererFactory(grid), new DefaultNumericRendererFactory(grid), new DefaultTextRendererFactory(grid));
        GridCellRendererFactories.set((DataGrid)grid, (GridCellRendererFactories)new GridCellRendererFactories(factories));
        grid.setObjectFormatterProvider(dataGrid -> DbObjectFormatter.get((CoreGrid<GridRow, GridColumn>)dataGrid));
        BaseConversionGraph.set((CoreGrid)grid, (ConversionGraph)new DbConversionGraph(new FormatsCache(), FormatterCreator.get((CoreGrid)grid), () -> grid.getObjectFormatter()));
        GridUtil.addDataProvider((DataGrid)grid, key2 -> DataGridUtil.getData(grid, key2));
        appearance.setResultViewShowRowNumbers(true);
        appearance.setBooleanMode(DataGridAppearanceSettings.getSettings().getBooleanMode());
    }

    @Nullable
    private static Object getData(@NotNull DataGrid grid, @NonNls String dataId) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(9);
        }
        GridDataHookUp hookUp = grid.getDataHookup();
        if (SelectInContext.DATA_KEY.is(dataId)) {
            JBIterable<DasObject> objects2 = DbNavigationUtils.unwrapElements(DataGridUtil.getPsiElementForSelection((DataGrid)grid));
            DbElement element2 = objects2 == null ? null : (DbElement)objects2.filter(DbElement.class).first();
            return element2 == null ? null : SelectInContextImpl.createFileSystemItemContext((PsiElement)element2);
        }
        if (Session.SESSION_KEY.is(dataId) && hookUp instanceof SessionClient) {
            return ((SessionClient)hookUp).getSession();
        }
        if (SessionClientHolder.CLIENT_KEY.is(dataId) && hookUp instanceof SessionClient) {
            return hookUp;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            JBIterable<DasObject> objects3 = DbNavigationUtils.unwrapElements(DataGridUtil.getPsiElementForSelection((DataGrid)grid));
            return objects3 == null || objects3.isEmpty() ? null : objects3.filter(DbElement.class).map(e2 -> DbNavigationUtils.createFromTreeNavigatable(e2)).toArray((Object[])Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        return LangDataKeys.CONTEXT_LANGUAGES.is(dataId) ? ContainerUtil.ar((Object[])new Language[]{DbSqlUtil.getLanguage(DataGridUtil.getDbms(grid))}) : (DatabaseDataKeys.DATA_GRID_SETTINGS_KEY.is(dataId) ? DatabaseSettings.getSettings() : null);
    }

    @NlsSafe
    @NotNull
    public static String getSqlType(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable GridColumn column2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            return "";
        }
        String typeNameSafe = StringUtil.notNullize((String)column2.getTypeName());
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (hookUp == null) {
            String string = typeNameSafe;
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn(grid, column2);
        if (dasColumn != null && dasColumn.getDasType() != DasTypeSystemBase.UNKNOWN) {
            String string = dasColumn.getDasType().getSpecification();
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        Version version = DbImplUtilCore.getDatabaseVersion(DataGridUtilCore.getDatabaseSystem(grid));
        Domain domain = BaseDomainRegistry.getDomain(DataGridUtilCore.getDbms(grid), version, (ColumnDescriptor)column2, false);
        String string = ImportUtil.getSqlTypeName(domain, (ColumnDescriptor)column2, null, DataGridUtilCore.getDbms(grid), version);
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void setupProgressIndicatingAuditor(final @NotNull DataGrid grid) {
        GridDataHookUp gridDataHookup;
        DataRequest.OwnerEx ownerEx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(14);
        }
        DataRequest.OwnerEx ownerEx2 = ownerEx = (gridDataHookup = grid.getDataHookup()) instanceof DataRequest.OwnerEx ? (DataRequest.OwnerEx)gridDataHookup : null;
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().addAuditor(new DataAuditor(){

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((StatusBarInfo)grid.getProject().getMessageBus().syncPublisher(StatusBar.Info.INSTANCE.getTOPIC())).setInfo(message2);
            }

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable String messageId) {
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ("ROWS_RETRIEVED".equals(messageId)) {
                    return;
                }
                this.print(context, message2);
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                if (request2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.connecting", new Object[0]));
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.processing", new Object[0]));
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(5);
                }
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.querying", new Object[0]));
            }

            @Override
            public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                if (request2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(7);
                }
                DataGridUtil.setProgressMessage(grid, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestStarted";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStatement";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void setProgressMessage(@NotNull DataGrid grid, @Nls @Nullable String message2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(15);
        }
        DbImplUtil.invokeLaterIfNeeded(() -> {
            JBLoadingPanel loadingPanel = grid.getPanel().getComponent();
            if (message2 != null) {
                loadingPanel.startLoading();
            } else {
                loadingPanel.stopLoading();
            }
            loadingPanel.setLoadingText(message2);
        });
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable DataGrid grid) {
        return DataGridUtil.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid);
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? (DasTable)ObjectUtils.tryCast((Object)hookup.getDatabaseTable(), DasTable.class) : null;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)grid);
        DatabaseDialectEx databaseDialectEx = hookup != null ? hookup.getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DataGridUtil.$$$reportNull$$$0(16);
        }
        return databaseDialectEx;
    }

    @Contract(pure=true)
    @NotNull
    public static Dbms getDbms(@Nullable DataGrid grid) {
        Dbms dbms = DataGridUtilCore.getDbms((CoreGrid<GridRow, GridColumn>)grid);
        if (dbms == null) {
            DataGridUtil.$$$reportNull$$$0(17);
        }
        return dbms;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DataGrid grid) {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(DataGridUtil.getDbms(grid));
        if (sqlLanguageDialect == null) {
            DataGridUtil.$$$reportNull$$$0(18);
        }
        return sqlLanguageDialect;
    }

    public static int getSubQueryIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getSubQueryIndex() : 1;
    }

    public static int getResultSetIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getResultSetIndex() : 1;
    }

    @Contract(value="null->null;!null->_")
    public static String getQueryText(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookUp = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookUp != null ? dataBusHookUp.getQueryText() : null;
    }

    public static DataBusGridDataHookUp getDataBusHookUp(@Nullable DataGrid grid) {
        return (DataBusGridDataHookUp)DataGridUtil.getHookUp((CoreGrid)grid, DataBusGridDataHookUp.class);
    }

    public static DatabaseGridDataHookUp getDatabaseHookUp(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        return (DatabaseGridDataHookUp)DataGridUtil.getHookUp(grid, DatabaseGridDataHookUp.class);
    }

    public static DataGridSessionClient getDataGridClient(@Nullable DataGrid grid) {
        return (DataGridSessionClient)DataGridUtil.getHookUp((CoreGrid)grid, DataGridSessionClient.class);
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(19);
        }
        JComponent header = DataGridUtil.addGridHeaderComponent((DataGrid)dataGrid);
        DatabaseEditorHelper.configureEditorHeader(dataGrid.getProject(), virtualFile, header);
        JComponent jComponent = header;
        if (jComponent == null) {
            DataGridUtil.$$$reportNull$$$0(20);
        }
        return jComponent;
    }

    public static boolean canBuildWhereClause(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(21);
        }
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        List columns2 = model2.getColumns();
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return !DbImplUtil.getWhereClauseColumns(table, columns2, DataGridUtilCore.getDbms(grid)).isEmpty();
    }

    public static DataConsumer createEDTSafeWrapper(@NotNull DataConsumer handler2, @NotNull Disposable disposableParent) {
        if (handler2 == null) {
            DataGridUtil.$$$reportNull$$$0(22);
        }
        if (disposableParent == null) {
            DataGridUtil.$$$reportNull$$$0(23);
        }
        return DataBusGridUtil.createEDTSafeWrapper(handler2, disposableParent);
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(24);
        }
        if (columnIdx == null) {
            DataGridUtil.$$$reportNull$$$0(25);
        }
        GridColumn column2 = (GridColumn)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column2) : null;
    }

    @Nullable
    public static DasObject getDatabaseObject(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(26);
        }
        if (rowIdx == null) {
            DataGridUtil.$$$reportNull$$$0(27);
        }
        GridRow row = (GridRow)grid.getDataModel(DataAccessType.DATABASE_DATA).getRow(rowIdx);
        DasGridDataHookUp hookup = (DasGridDataHookUp)DataGridUtil.getHookUp((CoreGrid)grid, DasGridDataHookUp.class);
        return hookup != null ? hookup.getDatabaseObject(row) : null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<DataConsumer.Row> getSelectedRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(28);
        }
        List list = JBIterable.from((Iterable)DataGridUtil.getSelectedGridRows((DataGrid)dataGrid)).map(r -> r instanceof DataConsumer.Row ? (DataConsumer.Row)r : DataConsumer.Row.create((int)r.getRowNum(), (Object[])ContainerUtil.newArrayList((Iterable)r).toArray())).toList();
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Nullable
    public static String getResultSetName(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DataGridUtil.$$$reportNull$$$0(30);
        }
        DataGrid grid = DataGridUtil.getDataGrid((DataContext)e2.getDataContext());
        JdbcConsole console = JdbcConsole.findConsole(e2);
        ContentManager manager = ContentManagerUtil.getContentManagerFromContext((DataContext)e2.getDataContext(), (boolean)false);
        return DataGridUtil.getResultSetName(grid, console, manager);
    }

    @Nullable
    public static String getResultSetName(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(31);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(32);
        }
        return DataGridUtil.getResultSetName(grid, DataGridUtil.findGridRelatedConsole(project, grid), null);
    }

    @Nullable
    public static String getResultSetName(@Nullable DataGrid grid, @Nullable JdbcConsole console, @Nullable ContentManager manager) {
        String name2;
        String string = name2 = console != null && grid != null ? DataGridUtil.getNameFromConsole(console, grid) : null;
        if (name2 != null) {
            return name2;
        }
        String string2 = name2 = grid != null && manager != null ? DataGridUtil.getNameFromContentManager(grid, manager) : null;
        if (name2 != null) {
            return name2;
        }
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return table != null ? table.getName() : null;
    }

    @Nullable
    private static String getNameFromConsole(@NotNull JdbcConsole console, @NotNull DataGrid dataGrid) {
        RunnerLayoutUi ui;
        if (console == null) {
            DataGridUtil.$$$reportNull$$$0(33);
        }
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(34);
        }
        return (ui = console.getUi()) == null ? null : DataGridUtil.getNameFromContentManager(dataGrid, ui.getContentManager());
    }

    @Nullable
    private static String getNameFromContentManager(@NotNull DataGrid grid, @NotNull ContentManager manager) {
        Content content;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(35);
        }
        if (manager == null) {
            DataGridUtil.$$$reportNull$$$0(36);
        }
        return (content = manager.getContent((JComponent)grid.getPanel().getComponent())) == null ? null : content.getDisplayName();
    }

    @Nullable
    public static JdbcConsole findGridRelatedConsole(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(37);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(38);
        }
        List<JdbcConsole> consoles = JdbcConsole.getActiveConsoles(project);
        for (JdbcConsole console : consoles) {
            RunnerLayoutUi ui = console.getUi();
            Content content = ui == null ? null : ui.getContentManager().getContent((JComponent)grid.getPanel().getComponent());
            if (content == null) continue;
            return console;
        }
        return null;
    }

    @NotNull
    public static List<String[]> formatValues(@NotNull DataGrid dataGrid, GridColumn @NotNull [] sourceColumns, @NotNull List<Object[]> valuesLists) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(39);
        }
        if (valuesLists == null) {
            DataGridUtil.$$$reportNull$$$0(40);
        }
        if (sourceColumns == null) {
            DataGridUtil.$$$reportNull$$$0(41);
        }
        LinkedList<String[]> formattedValuesList = new LinkedList<String[]>();
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        DbObjectFormatter objectFormatter = new DbObjectFormatter(dbms);
        for (Object[] values2 : valuesLists) {
            ArrayList<String> formattedValues = new ArrayList<String>();
            for (int i2 = 0; i2 < sourceColumns.length; ++i2) {
                formattedValues.add(DataGridUtilCore.formatValue(sourceColumns[i2], (ObjectFormatter)objectFormatter, dbms, values2[i2]));
            }
            formattedValuesList.add(ArrayUtil.toStringArray(formattedValues));
        }
        LinkedList<String[]> linkedList = formattedValuesList;
        if (linkedList == null) {
            DataGridUtil.$$$reportNull$$$0(42);
        }
        return linkedList;
    }

    @Nullable
    public static TypesMutator<GridRow, GridColumn, Domain> getTypesMutator(@Nullable DataGrid grid) {
        return (TypesMutator)ObjectUtils.tryCast((Object)(grid == null ? null : grid.getDataHookup().getMutator()), TypesMutator.class);
    }

    public static void doWhenDataSourceIsLoaded(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull Runnable runnable) {
        DatabaseGridDataHookUp hookUp;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(43);
        }
        if (runnable == null) {
            DataGridUtil.$$$reportNull$$$0(44);
        }
        if ((hookUp = (DatabaseGridDataHookUp)ObjectUtils.tryCast((Object)grid.getDataHookup(), DatabaseGridDataHookUp.class)) == null) {
            return;
        }
        hookUp.getDataSource().getLoadingPromise().onProcessed(o2 -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)grid.getProject().getDisposed(), (Runnable)runnable));
    }

    public static ActionGroup getGridDatabasePopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup.Database");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 11, 12, 13, 16, 17, 18, 20, 29, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 29: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 26: 
            case 32: 
            case 35: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appearance";
                break;
            }
            case 19: 
            case 28: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesLists";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceColumns";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataGrid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewDataGrid";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addGridHeaderComponent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 29: 
            case 42: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewDataGrid";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressIndicatingAuditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProgressMessage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addGridHeaderComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "canBuildWhereClause";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEDTSafeWrapper";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseColumn";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseObject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRows";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromConsole";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromContentManager";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findGridRelatedConsole";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "formatValues";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doWhenDataSourceIsLoaded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 11, 12, 13, 16, 17, 18, 20, 29, 42 -> new IllegalStateException(string);
        };
    }
}

