/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshDataSourceValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            SshDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            SshDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            SshDataSourceValidator.$$$reportNull$$$0(2);
        }
        DataSourceSshTunnelConfiguration configuration = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(target2);
        DatabaseDriver driver2 = target2.getDatabaseDriver();
        String url = target2.getUrl();
        if (driver2 == null || StringUtil.isEmpty((String)url)) {
            return;
        }
        if (configuration == null || SshDataSourceValidator.isOk(driver2, url)) {
            return;
        }
        String description = DatabaseBundle.message("notification.content.host.port.not.found.fix.url.or.href.action0.create.template", new Object[0]);
        problems.consume((Object)new DataSourceProblem(target2, this, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(DatabaseBundle.message("notification.title.unable.to.apply.ssh.settings", new Object[0]), description, description, new DataSourceProblem.NewUrlTemplate(driver2, url)), null));
    }

    private static boolean isOk(@NotNull DatabaseDriver driver2, @NotNull String url) {
        if (driver2 == null) {
            SshDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (url == null) {
            SshDataSourceValidator.$$$reportNull$$$0(4);
        }
        return !JdbcUrlParserUtil.extractHostsPorts(driver2.getJDBCUrlParsers(), url, null).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/SshDataSourceValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isOk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

