/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DesktopActionsOptionProvider;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.toolkit.RemoteDesktopActions;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandlerImpl;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.ide.BrowserUtil;
import java.io.File;
import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dataSource/DesktopActionsConnectionInterceptor;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "()V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "", "Companion", "intellij.database.impl"})
public final class DesktopActionsConnectionInterceptor
implements DatabaseConnectionInterceptor,
ConsoleConfigurationParamProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        if (proto2.shouldInitDriver() && proto2.getDriver() != null) {
            RemoteDriver remoteDriver = proto2.getDriver();
            Intrinsics.checkNotNull((Object)remoteDriver);
            Companion.ensureDesktopActionsConfigured(remoteDriver, proto2.getConnectionPoint());
        }
        return Boxing.boxBoolean((boolean)false);
    }

    @Override
    public void populate(@NotNull LocalDataSource dataSource2, @NotNull ParametersList params2, @NotNull Map<String, String> env) {
        block2: {
            ParamsGroup group2;
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            RemoteDesktopActionsHandlerImpl.State state = DesktopActionsConnectionInterceptor.Companion.getState(dataSource2.getDatabaseDriver());
            if (state != RemoteDesktopActionsHandlerImpl.State.ENABLED) {
                params2.addProperty(RemoteDesktopActionsHandlerImpl.getActionsProperty(), state.getId());
            }
            if (state != RemoteDesktopActionsHandlerImpl.State.ENABLED && state != RemoteDesktopActionsHandlerImpl.State.TOOLKIT) break block2;
            ParamsGroup paramsGroup = group2 = params2.getParamsGroup("exports");
            if (paramsGroup != null) {
                paramsGroup.addParametersString("--add-exports java.desktop/sun.awt=ALL-UNNAMED --add-exports java.desktop/java.awt.peer=ALL-UNNAMED --add-opens java.desktop/java.awt=ALL-UNNAMED");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/DesktopActionsConnectionInterceptor$Companion;", "", "()V", "ensureDesktopActionsConfigured", "", "driver", "Lcom/intellij/database/remote/jdbc/RemoteDriver;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getState", "Lcom/intellij/database/remote/toolkit/RemoteDesktopActionsHandlerImpl$State;", "databaseDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void ensureDesktopActionsConfigured(@NotNull RemoteDriver driver2, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)driver2, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (this.getState(point.getDatabaseDriver()) == RemoteDesktopActionsHandlerImpl.State.DISABLED) {
                return;
            }
            RemoteDesktopActions handler2 = new RemoteDesktopActions(){

                public void open(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void edit(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void print(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void mail(@NotNull URI mailtoURL) {
                    Intrinsics.checkNotNullParameter((Object)mailtoURL, (String)"mailtoURL");
                    throw new UnsupportedOperationException();
                }

                public void browse(@NotNull URI uri) {
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    BrowserUtil.browse((URI)uri);
                }
            };
            try {
                Remote remote = UnicastRemoteObject.exportObject((Remote)RemoteDesktopActionsHandlerImpl.wrap((RemoteDesktopActions)handler2), 0);
                Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler");
                driver2.setDesktopActionsHandler((RemoteDesktopActionsHandler)remote);
            }
            catch (RemoteException e2) {
                throw new RuntimeException(e2);
            }
        }

        private final RemoteDesktopActionsHandlerImpl.State getState(DatabaseDriver databaseDriver) {
            RemoteDesktopActionsHandlerImpl.State value2 = databaseDriver == null ? null : (RemoteDesktopActionsHandlerImpl.State)DbOptionProvider.getOptionValue(databaseDriver, DesktopActionsOptionProvider.class);
            RemoteDesktopActionsHandlerImpl.State state = Objects.requireNonNullElse(value2, RemoteDesktopActionsHandlerImpl.State.ENABLED);
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"requireNonNullElse(...)");
            return state;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

