/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSource
extends SimpleModificationTracker
implements RawDataSource,
DatabaseSystem {
    public static final Topic<Listener> TOPIC = new Topic("DATA_SOURCE_TOPIC", Listener.class);
    private static final Logger LOG = Logger.getInstance(AbstractDataSource.class);
    private String myUniqueId = UUID.randomUUID().toString();
    private String myName = "";
    private String myComment;
    private String myGroupName;
    private boolean myRegistered;
    private AtomicInteger myMuting = new AtomicInteger(0);

    @ApiStatus.Internal
    public void registered() {
        this.myRegistered = true;
    }

    @ApiStatus.Internal
    public void unregistered() {
        this.myRegistered = false;
    }

    @ApiStatus.Internal
    public void modify(@NotNull Runnable modifier) {
        if (modifier == null) {
            AbstractDataSource.$$$reportNull$$$0(0);
        }
        try {
            this.myMuting.incrementAndGet();
            modifier.run();
        }
        finally {
            this.myMuting.decrementAndGet();
        }
    }

    protected void checkAndTrackModification() {
        if (this.myMuting.get() > 0 || !this.myRegistered) {
            this.incModificationCount();
        } else {
            String name2 = this.myName != null ? this.myName : (this.myUniqueId != null ? this.myUniqueId : "<unnamed>");
            String message2 = "Unexpected attempt to modify data source (" + name2 + ")";
            if (ApplicationManager.getApplication().isInternal()) {
                throw new IllegalStateException(message2);
            }
            LOG.error(message2);
        }
    }

    protected void setUniqueId(@Nullable String uniqueId) {
        this.myUniqueId = uniqueId == null ? UUID.randomUUID().toString() : uniqueId;
    }

    @Override
    @NotNull
    public String getUniqueId() {
        String string = this.myUniqueId;
        if (string == null) {
            AbstractDataSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractDataSource.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            AbstractDataSource.$$$reportNull$$$0(3);
        }
        this.myName = name2;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.myGroupName;
    }

    public void setGroupName(@Nullable String groupName) {
        String newGroupName = AbstractDataSource.sanitizeGroupName(groupName);
        if (Objects.equals(this.myGroupName, newGroupName)) {
            return;
        }
        this.checkAndTrackModification();
        this.myGroupName = newGroupName;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    @NotNull
    public abstract DasModel getModel();

    protected void notifyModelReplaced(@Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        AbstractDataSource.notifyChange(listener2 -> listener2.onModelReplaced(this, oldModel, newModel));
    }

    public final boolean equals(Object o2) {
        return this == o2;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.getName();
        if (string == null) {
            AbstractDataSource.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    static String sanitizeGroupName(@Nullable String groupName) {
        return groupName == null ? null : StringUtil.nullize((String)StringUtil.trimStart((String)StringUtil.trimEnd((String)groupName.replaceAll("(?:/\\s*)+", "/"), (String)"/"), (String)"/"));
    }

    private static void notifyChange(Consumer<Listener> notifierAction) {
        Listener listener2 = (Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        notifierAction.accept(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AbstractDataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AbstractDataSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        public void onModelReplaced(@NotNull RawDataSource var1, @Nullable BasicModel var2, @Nullable BasicModel var3);
    }
}

