/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010\u001a\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b\u001a6\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\r0\u0013\"\u0004\b\u0000\u0010\u0014\"\b\b\u0001\u0010\u0015*\u00020\u00162\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0017\u001a\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a$\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u001a\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0080@\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0001H\u0003\u001aB\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H&0\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010&\"\b\b\u0002\u0010\u0015*\u00020\u00162\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u0002H\u00150(\u001a\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0007\u001a\u0012\u0010,\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0006\u001a\u0010\u0010-\u001a\u00020.2\u0006\u00102\u001a\u00020\u0006H\u0000\u001a\u0010\u00103\u001a\u00020\"2\u0006\u0010\n\u001a\u000204H\u0007\u001a\"\u00103\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u0001052\u0006\u0010*\u001a\u00020+H\u0007\u001a\u0010\u00106\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u00107\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0007\u001a\u0012\u00108\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001a\u00108\u001a\u0004\u0018\u00010\"2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0018\u00109\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u00020\u0006H\u0003\u001a\u000e\u0010;\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>\u001a\u000e\u0010?\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020@\u001a\u0018\u0010A\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u000204H\u0000\u001a\u0018\u0010A\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0000\u001a\u000e\u0010B\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010C\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a(\u0010D\u001a\u00020\"*\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u0001052\b\u0010*\u001a\u0004\u0018\u00010+H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"SECOND", "", "cancelledProgressIcon", "Lcom/intellij/ui/LayeredIcon;", "progressTimeout", "canClose", "", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "canDetach", "client", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "cancel", "", "owner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "(Lcom/intellij/database/datagrid/DataRequest$OwnerEx;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "consumer", "Lkotlin/Function1;", "T", "E", "", "Lcom/intellij/util/ThrowableConsumer;", "deactivateDataSourceAsync", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "detach", "disconnect", "formatDuration", "", "inProgress", "time", "function", "R", "func", "Lcom/intellij/util/ThrowableConvertor;", "getClientTitle", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIdleMessage", "getProgressIcon", "Ljavax/swing/Icon;", "work", "Lcom/intellij/database/console/session/DatabaseSession$State$Work;", "idleIcon", "cancelled", "getQualifiedClientTitle", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "Lcom/intellij/database/model/DasDataSource;", "getQualifiedSessionTitle", "getSessionTitle", "getTimeSpent", "getTitle", "trimExtension", "hasAnyNonFinishedWork", "isInternalDepartment", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "isInternalOwner", "Lcom/intellij/database/datagrid/DataRequest$Owner;", "needToSaveSessionName", "needToShowProgress", "needToShowTimeSpent", "qualify", "intellij.database.connectivity"})
@JvmName(name="SessionsUtil")
@SourceDebugExtension(value={"SMAP\nSessionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsUtil.kt\ncom/intellij/database/console/session/SessionsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1747#2,3:225\n1#3:228\n*S KotlinDebug\n*F\n+ 1 SessionsUtil.kt\ncom/intellij/database/console/session/SessionsUtil\n*L\n159#1:225,3\n*E\n"})
public final class SessionsUtil {
    @NotNull
    private static final LayeredIcon cancelledProgressIcon = LayeredIcon.Companion.layeredIcon(SessionsUtil::cancelledProgressIcon$lambda$2);
    private static final long SECOND = 1000L;
    public static final long progressTimeout = 1000L;

    @NotNull
    public static final <T, R, E extends Throwable> Function1<T, R> function(@NotNull ThrowableConvertor<T, R, E> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return new Function1<T, R>(func){
            final /* synthetic */ ThrowableConvertor<T, R, E> $func;
            {
                this.$func = $func;
                super(1);
            }

            public final R invoke(T t) {
                return (R)this.$func.convert(t);
            }
        };
    }

    @NotNull
    public static final <T, E extends Throwable> Function1<T, Unit> consumer(@NotNull ThrowableConsumer<T, E> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Function1<T, Unit>(consumer2){
            final /* synthetic */ ThrowableConsumer<T, E> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(T t) {
                this.$consumer.consume(t);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInternalOwner(@NotNull DataRequest.Owner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof DatabaseSessionClient)) return false;
        DatabaseDepartment databaseDepartment = ((DatabaseSessionClient)owner).getDepartment();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDepartment, (String)"getDepartment(...)");
        if (!SessionsUtil.isInternalDepartment(databaseDepartment)) return false;
        return true;
    }

    public static final boolean isInternalDepartment(@NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return !ApplicationManager.getApplication().isUnitTestMode() && department.isInternal() && !department.isService();
    }

    @Deprecated(message="Do not break structured concurrency, await completion", replaceWith=@ReplaceWith(expression="deactivate", imports={}))
    public static final void deactivateDataSourceAsync(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Project project = session2.getProject();
        LocalDataSource localDataSource = session2.getConnectionPoint().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        SessionsUtil.deactivateDataSourceAsync(project, localDataSource, session2.getConfiguration());
    }

    @Deprecated(message="Do not break structured concurrency, await completion", replaceWith=@ReplaceWith(expression="deactivate", imports={}))
    public static final void deactivateDataSourceAsync(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ConsoleRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)"Deactivate data source", null, (boolean)false, (int)6, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, dataSource2, configuration, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $dataSource;
            final /* synthetic */ ConsoleRunConfiguration $configuration;
            {
                this.$project = $project;
                this.$dataSource = $dataSource;
                this.$configuration = $configuration;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DataSourceUtilKt.deactivate(this.$project, this.$dataSource, this.$configuration, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void deactivateDataSourceAsync$default(Project project, LocalDataSource localDataSource, ConsoleRunConfiguration consoleRunConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            consoleRunConfiguration = null;
        }
        SessionsUtil.deactivateDataSourceAsync(project, localDataSource, consoleRunConfiguration);
    }

    @Nullable
    public static final Object cancel(@NotNull DataRequest.OwnerEx owner, @NotNull Continuation<? super Unit> $completion) {
        DataRequest.Cancel cancel2;
        DataRequest.Cancel it2 = cancel2 = new DataRequest.Cancel(owner);
        boolean bl = false;
        owner.getMessageBus().getDataProducer().processRequest((GridDataRequest)it2);
        AsyncPromise<Void> asyncPromise = cancel2.getPromise();
        Intrinsics.checkNotNullExpressionValue(asyncPromise, (String)"getPromise(...)");
        Object object = Promises.await((Promise)((Promise)asyncPromise), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object disconnect(@NotNull DataRequest.OwnerEx owner, @NotNull Continuation<? super Unit> $completion) {
        DataRequest.Disconnect disconnect;
        DataRequest.Disconnect it2 = disconnect = new DataRequest.Disconnect(owner);
        boolean bl = false;
        owner.getMessageBus().getDataProducer().processRequest((GridDataRequest)it2);
        AsyncPromise<Void> asyncPromise = disconnect.getPromise();
        Intrinsics.checkNotNullExpressionValue(asyncPromise, (String)"getPromise(...)");
        Object object = Promises.await((Promise)((Promise)asyncPromise), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session2, @NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return SessionsUtil.needToSaveSessionName(session2, client.getVirtualFile());
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !session2.isService() && !Intrinsics.areEqual((Object)session2.getTitle(), (Object)SessionsUtil.getSessionTitle(file));
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return SessionsUtil.getProgressIcon(work, session2, false);
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2, boolean idleIcon) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return work.getState() != DatabaseSession.State.WorkState.FINISHED && SessionsUtil.needToShowProgress(session2) ? (idleIcon && work.getState() == DatabaseSession.State.WorkState.SUBMITTED ? AllIcons.RunConfigurations.TestNotRan : SessionsUtil.getProgressIcon(work.getState() == DatabaseSession.State.WorkState.CANCELLING)) : null;
    }

    @NotNull
    public static final Icon getProgressIcon(boolean cancelled) {
        Icon icon;
        if (cancelled) {
            icon = (Icon)cancelledProgressIcon;
        } else {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            icon = (Icon)animatedIcon;
        }
        return icon;
    }

    @NlsContexts.Tooltip
    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session2)) {
            return null;
        }
        long time = work.getTimeSpentMs();
        if (time <= 0L) {
            return null;
        }
        DatabaseSession.State.WorkState workState = work.getState();
        return workState != DatabaseSession.State.WorkState.SUBMITTED ? SessionsUtil.formatDuration(workState.getInProgress(), time) : SessionsUtil.getIdleMessage(session2);
    }

    @NlsSafe
    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session2)) {
            return null;
        }
        DatabaseSession.State state = session2.getState();
        long time = state.getTimeSpentMs();
        return time <= 0L ? null : SessionsUtil.formatDuration(!state.isIdle(), time);
    }

    public static final boolean needToShowProgress(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return SessionsUtil.hasAnyNonFinishedWork(session2) && System.currentTimeMillis() - state.getStartTime() >= 1000L;
    }

    public static final boolean hasAnyNonFinishedWork(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return !state.isIdle() && state.getStartTime() != 0L;
    }

    public static final boolean needToShowTimeSpent(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return !state.isEmpty() && (state.isIdle() || state.getTimeSpentMs() >= 1000L);
    }

    @NlsSafe
    private static final String formatDuration(boolean inProgress, long time) {
        long timeToFormat = inProgress && time > 3000L ? time / 1000L * 1000L : time;
        String string = StringUtil.formatDuration((long)timeToFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        return string;
    }

    @NlsContexts.Tooltip
    private static final String getIdleMessage(DatabaseSession session2) {
        boolean bl;
        block3: {
            DatabaseSession.State state = session2.getState();
            List<DatabaseSession.State.Work> work = state.getWork();
            Iterable $this$any$iv = work;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseSession.State.Work w = (DatabaseSession.State.Work)element$iv;
                    boolean bl2 = false;
                    if (!w.getState().getInProgress()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? DatabaseBundle.message("tooltip.waiting", new Object[0]) : null;
    }

    public static final boolean canClose(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return session2.isIdle();
    }

    public static final void close(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        for (DatabaseSessionClient client : session2.getClients()) {
            session2.detach(client);
        }
        Disposer.dispose((Disposable)session2);
    }

    public static final boolean canDetach(@NotNull VisibleDatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return ((DatabaseSession)client.getSession()).isIdle();
    }

    public static final void detach(@NotNull VisibleDatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ((DatabaseSession)client.getSession()).detach(client);
    }

    @Nls
    @NotNull
    public static final String getSessionTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.getTitle(file, true);
    }

    @Nls
    @NotNull
    public static final String getQualifiedSessionTitle(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return SessionsUtil.qualify(session2.getTitle(), session2.getProject(), session2.getConnectionPoint().getDataSource(), null);
    }

    @Nls
    @NotNull
    public static final String getClientTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.getTitle(file, false);
    }

    @Nls
    @NotNull
    public static final String getQualifiedClientTitle(@NotNull Project project, @Nullable DasDataSource dataSource2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SessionsUtil.qualify(SessionsUtil.getClientTitle(file), project, dataSource2, file);
    }

    @Nls
    @NotNull
    public static final String getQualifiedClientTitle(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return SessionsUtil.qualify(client.getTitle(), ((DatabaseSession)client.getSession()).getProject(), ((DatabaseSession)client.getSession()).getConnectionPoint().getDataSource(), client.getVirtualFile());
    }

    @Nls
    private static final String getTitle(VirtualFile file, boolean trimExtension) {
        String string = DbVFSUtils.isConsoleFile(file) ? file.getNameWithoutExtension() : (DbSrcUtils.isDbSrcFile(file) ? file.getNameWithoutExtension() : (file instanceof DatabaseElementVirtualFileImpl ? ((DatabaseElementVirtualFileImpl)file).getName() : (trimExtension ? file.getNameWithoutExtension() : file.getName())));
        Intrinsics.checkNotNull((Object)string);
        String name2 = string;
        String string2 = StringUtil.unescapeXmlEntities((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeXmlEntities(...)");
        return string2;
    }

    @Nls
    private static final String qualify(String $this$qualify, Project project, DasDataSource dataSource2, VirtualFile file) {
        boolean bl;
        if (dataSource2 == null) {
            return $this$qualify;
        }
        if (DataSourceStorage.getProjectStorage(project).getDataSourcesImpl().skip(1).isEmpty()) {
            return $this$qualify;
        }
        VirtualFile virtualFile = file;
        if (virtualFile != null) {
            VirtualFile it2 = virtualFile;
            boolean bl2 = false;
            bl = !DbVFSUtils.isAssociatedWithDataSource(file);
        } else {
            bl = false;
        }
        if (bl) {
            return $this$qualify;
        }
        return $this$qualify + " [" + dataSource2.getName() + "]";
    }

    private static final Icon[] cancelledProgressIcon$lambda$2() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AnimatedIcon.Default.INSTANCE, (String)"INSTANCE");
        Intrinsics.checkNotNullExpressionValue((Object)DatabaseIcons.SuspendScaled, (String)"SuspendScaled");
        return iconArray;
    }
}

