/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.DatabaseSessionViewServiceImpl;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DbGridDataHookUpManager;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0019\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl;", "Lcom/intellij/database/console/session/DatabaseSessionViewService;", "Lcom/intellij/openapi/Disposable$Default;", "()V", "clientViews", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/console/session/DatabaseClientLogView;", "sessionViews", "Lcom/intellij/database/run/session/VisibleSession;", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "databaseSessionContributorListenSessions", "", "destroyView", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "findDatabaseSession", "Lcom/intellij/database/console/session/DatabaseSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getClientView", "configurator", "Lkotlin/Function1;", "Lcom/intellij/database/console/session/DatabaseClientLogViewBase;", "getClientViewIfAny", "Lcom/intellij/database/run/session/LogView;", "getView", "session", "getViewIfAny", "initView", "key", "MyAutoClosableLanguageConsoleImpl", "MyLanguageConsoleImpl", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseSessionViewServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionViewServiceImpl.kt\ncom/intellij/database/console/session/DatabaseSessionViewServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class DatabaseSessionViewServiceImpl
extends DatabaseSessionViewService
implements Disposable.Default {
    @NotNull
    private final Map<VisibleSession<?>, DatabaseSessionLogView> sessionViews = new HashMap();
    @NotNull
    private final Map<Pair<Project, VirtualFile>, DatabaseClientLogView> clientViews = new HashMap();

    @NotNull
    public DatabaseSessionLogView getView(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DatabaseSessionLogView databaseSessionLogView = this.sessionViews.computeIfAbsent(session2, arg_0 -> DatabaseSessionViewServiceImpl.getView$lambda$0((Function1)new Function1<VisibleSession<?>, DatabaseSessionLogView>(session2, this){
            final /* synthetic */ DatabaseSession $session;
            final /* synthetic */ DatabaseSessionViewServiceImpl this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DatabaseSessionLogView invoke(@NotNull VisibleSession<?> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                ThreadingAssertions.assertEventDispatchThread();
                Project project = this.$session.getProject();
                String string = this.$session.getTitle();
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(((DatabaseConnectionPoint)this.$session.getTarget()).getDataSource());
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
                MyLanguageConsoleImpl console = new MyLanguageConsoleImpl(project, string, (Language)sqlLanguageDialect);
                DatabaseSessionLogView view2 = new DatabaseSessionLogView((LanguageConsoleView)console, this.$session);
                Disposer.register((Disposable)this.$session, () -> getView.1.invoke$lambda$0(this.this$0, this.$session));
                return view2;
            }

            private static final void invoke$lambda$0(DatabaseSessionViewServiceImpl this$0, DatabaseSession $session) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                DatabaseSessionViewServiceImpl.access$getSessionViews$p(this$0).remove($session);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)databaseSessionLogView, (String)"computeIfAbsent(...)");
        return databaseSessionLogView;
    }

    @Override
    public void initView(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.getView(session2);
    }

    @Override
    @Nullable
    public LogView<DatabaseSession> getViewIfAny(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return this.sessionViews.get(session2);
    }

    @NotNull
    public DatabaseClientLogView getClientView(@NotNull DatabaseSessionClientWithFile client, @NotNull Function1<? super DatabaseClientLogViewBase<DatabaseSessionClientWithFile>, Unit> configurator) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
        Project project = ((DatabaseSession)client.getSession()).getProject();
        Pair<Project, VirtualFile> key2 = this.key(client);
        DatabaseClientLogView databaseClientLogView = this.clientViews.computeIfAbsent(key2, arg_0 -> DatabaseSessionViewServiceImpl.getClientView$lambda$1((Function1)new Function1<Pair<? extends Project, ? extends VirtualFile>, DatabaseClientLogView>(project, client, configurator, this, key2){
            final /* synthetic */ Project $project;
            final /* synthetic */ DatabaseSessionClientWithFile $client;
            final /* synthetic */ Function1<DatabaseClientLogViewBase<DatabaseSessionClientWithFile>, Unit> $configurator;
            final /* synthetic */ DatabaseSessionViewServiceImpl this$0;
            final /* synthetic */ Pair<Project, VirtualFile> $key;
            {
                this.$project = $project;
                this.$client = $client;
                this.$configurator = $configurator;
                this.this$0 = $receiver;
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final DatabaseClientLogView invoke(@NotNull Pair<? extends Project, ? extends VirtualFile> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                ThreadingAssertions.assertEventDispatchThread();
                MyAutoClosableLanguageConsoleImpl console = new MyAutoClosableLanguageConsoleImpl(this.$project, this.$client.getTitle(), this.$client.getVirtualFile(), this.$client.getAutoClose());
                DatabaseClientLogView result2 = new DatabaseClientLogView((LanguageConsoleView)console, this.$client);
                this.$configurator.invoke((Object)result2);
                Disposer.register((Disposable)((Disposable)this.this$0), (Disposable)result2);
                Disposer.register((Disposable)result2, () -> getClientView.view.1.invoke$lambda$0(this.this$0, this.$key));
                return result2;
            }

            private static final void invoke$lambda$0(DatabaseSessionViewServiceImpl this$0, Pair $key) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
                DatabaseSessionViewServiceImpl.access$getClientViews$p(this$0).remove($key);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)databaseClientLogView, (String)"computeIfAbsent(...)");
        DatabaseClientLogView view2 = databaseClientLogView;
        if (!Intrinsics.areEqual(view2.getTarget(), (Object)client)) {
            view2.setTarget(client, client.getMessageBus());
            configurator.invoke((Object)view2);
        }
        return view2;
    }

    private final Pair<Project, VirtualFile> key(DatabaseSessionClientWithFile client) {
        return new Pair((Object)((DatabaseSession)client.getSession()).getProject(), (Object)client.getVirtualFile());
    }

    @Override
    @Nullable
    public LogView<DatabaseSessionClientWithFile> getClientViewIfAny(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return client instanceof DataGridSessionClient ? ((DataGridSessionClient)client).getView() : (LogView)this.clientViews.get(this.key(client));
    }

    @Override
    public void destroyView(@NotNull DatabaseSessionClientWithFile client) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            LogView<DatabaseSessionClientWithFile> logView = this.getClientViewIfAny(client);
            if (logView == null) break block0;
            LogView<DatabaseSessionClientWithFile> it2 = logView;
            boolean bl = false;
            Disposer.dispose((Disposable)it2);
        }
    }

    @Override
    public void databaseSessionContributorListenSessions() {
        DatabaseServiceViewContributor.listenSessions();
    }

    @Override
    @Nullable
    public DatabaseSession findDatabaseSession(@NotNull AnActionEvent e2) {
        DataGridSessionClient hookUp;
        DatabaseSession session2;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Object object = e2.getData(Session.SESSION_KEY);
        DatabaseSession databaseSession = session2 = object instanceof DatabaseSession ? (DatabaseSession)object : null;
        if (session2 != null) {
            return session2;
        }
        JdbcConsoleBase console = JdbcConsole.findConsole(e2);
        if (console != null) {
            return (DatabaseSession)console.getSession();
        }
        DataGridSessionClient dataGridSessionClient = hookUp = (DataGridSessionClient)DbGridDataHookUpManager.getInstance(project2).getClient(e2);
        return dataGridSessionClient != null ? dataGridSessionClient.getSession() : null;
    }

    private static final DatabaseSessionLogView getView$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DatabaseSessionLogView)$tmp0.invoke(p0);
    }

    private static final DatabaseClientLogView getClientView$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DatabaseClientLogView)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getSessionViews$p(DatabaseSessionViewServiceImpl $this) {
        return $this.sessionViews;
    }

    public static final /* synthetic */ Map access$getClientViews$p(DatabaseSessionViewServiceImpl $this) {
        return $this.clientViews;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyAutoClosableLanguageConsoleImpl;", "Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyLanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoClose", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "closeFile", "", "intellij.database.impl"})
    private static final class MyAutoClosableLanguageConsoleImpl
    extends MyLanguageConsoleImpl {
        private final boolean autoClose;

        public MyAutoClosableLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file, boolean autoClose) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(project, title, file);
            this.autoClose = autoClose;
        }

        protected void closeFile() {
            if (this.autoClose) {
                super.closeFile();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyLanguageConsoleImpl;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/lang/Language;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.database.impl"})
    private static class MyLanguageConsoleImpl
    extends LanguageConsoleImpl {
        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(new LanguageConsoleImpl.Helper(project, file){

                public void setupEditor(@NotNull EditorEx editor2) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    super.setupEditor(editor2);
                    EditorSettings editorSettings = editor2.getSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
                    EditorSettings editorSettings2 = editorSettings;
                    editorSettings2.setFoldingOutlineShown(true);
                }
            }.setTitle(title));
        }

        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this(project, title, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)""));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

