/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"DATA_SOURCES_DO_NOT_SUGGEST_AGAIN", "", "notifyNewDataSourcesDetected", "", "project", "Lcom/intellij/openapi/project/Project;", "scanForNewConfigurations", "", "intellij.database.impl"})
public final class DatabaseConfigStartupActivityKt {
    @NotNull
    private static final String DATA_SOURCES_DO_NOT_SUGGEST_AGAIN = "data.sources.detected.do.not.suggest.again";

    private static final boolean scanForNewConfigurations(Project project) {
        Module[] modules = project.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.Companion.getInstance(project).getModules();
        Intrinsics.checkNotNull((Object)modules);
        if (modules.length == 0) {
            return false;
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        for (DataSourceDetector detector : DataSourceDetector.EP_NAME.getExtensionList()) {
            if (!detector.isApplicable(project)) continue;
            for (Module module : modules) {
                ProgressManager.checkCanceled();
                detector.collectDataSources(module, registry.getBuilder(), false);
                if (registry.getDataSources().isEmpty()) continue;
                Collection<? extends LocalDataSource> collection2 = registry.getNewDataSources();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getNewDataSources(...)");
                if (!(!collection2.isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    private static final void notifyNewDataSourcesDetected(Project project) {
        if (!project.isOpen()) {
            return;
        }
        String string = DatabaseBundle.message("data.sources.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message("data.sources.detected.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        DatabaseNotifications.DATABASE_DETECTION_GROUP.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message("data.sources.detected.configure", new Object[0]), (String)"data.sources.detected.configure", (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$0((Function2)new Function2<AnActionEvent, Notification, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification) {
                if (ImportDataSourceAction.doImportAction(this.$project, true)) {
                    notification.expire();
                }
            }
        }, arg_0, arg_1))).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message(DATA_SOURCES_DO_NOT_SUGGEST_AGAIN, new Object[0]), (String)DATA_SOURCES_DO_NOT_SUGGEST_AGAIN, (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$1((Function2)new Function2<AnActionEvent, Notification, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification) {
                PropertiesComponent.getInstance((Project)this.$project).setValue("data.sources.detected.do.not.suggest.again", true);
                notification.expire();
            }
        }, arg_0, arg_1))).setSuggestionType(true).setDisplayId("DatabaseConfigFileWatcher.found").notify(project);
    }

    private static final void notifyNewDataSourcesDetected$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void notifyNewDataSourcesDetected$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ boolean access$scanForNewConfigurations(Project project) {
        return DatabaseConfigStartupActivityKt.scanForNewConfigurations(project);
    }

    public static final /* synthetic */ void access$notifyNewDataSourcesDetected(Project project) {
        DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected(project);
    }
}

