/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.SchemaScripts;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExtensionScriptActionGroup
extends ActionGroup
implements DumbAware {
    private static final String SCRIPTS_DIRECTORY = "schema";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected String getScriptsDirectory() {
        return SCRIPTS_DIRECTORY;
    }

    @NotNull
    protected PluginId getPluginId() {
        PluginId pluginId = DatabasePluginId.get();
        if (pluginId == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(1);
        }
        return pluginId;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(2);
        }
        e2.getPresentation().setEnabledAndVisible(SchemaScripts.areAvailableIn(e2.getDataContext()));
    }

    @NotNull
    public @NotNull AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
        if (e2 == null) {
            if (EMPTY_ARRAY == null) {
                RunExtensionScriptActionGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        AnAction[] anActionArray = (AnAction[])ContainerUtil.map2Array(SchemaScripts.getScriptFiles(this.getPluginId(), this.getScriptsDirectory()), (Object[])AnAction.EMPTY_ARRAY, x$0 -> new RunScriptAction((Path)x$0));
        if (anActionArray == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private final class RunScriptAction
    extends DumbAwareAction {
        private final Path myScript;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RunScriptAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private RunScriptAction(Path script2) {
            if (script2 == null) {
                RunScriptAction.$$$reportNull$$$0(1);
            }
            super(StringUtil.escapeMnemonics((String)script2.getFileName().toString()), DatabaseBundle.message("action.RunScriptAction.description", new Object[0]), null);
            this.myScript = script2;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                RunScriptAction.$$$reportNull$$$0(2);
            }
            SchemaScripts.runScript(e2.getDataContext(), this.myScript, RunExtensionScriptActionGroup.this.getPluginId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/RunExtensionScriptActionGroup$RunScriptAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup$RunScriptAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class EditScriptsAction
    extends DumbAwareAction {
        private EditScriptsAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditScriptsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            VirtualFile virtualFile;
            Project project;
            if (e2 == null) {
                EditScriptsAction.$$$reportNull$$$0(1);
            }
            if ((project = e2.getProject()) == null) {
                return;
            }
            Path dir = SchemaScripts.getScriptsDirectory(DatabasePluginId.get(), RunExtensionScriptActionGroup.SCRIPTS_DIRECTORY);
            VirtualFile virtualFile2 = virtualFile = dir == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByNioFile(dir);
            if (virtualFile == null) {
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/RunExtensionScriptActionGroup$EditScriptsAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup$EditScriptsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

