/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.ModelStatisticsInternalAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "formatPercent", "", "loaded", "", "total", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getRoot", "Lcom/intellij/database/model/basic/BasicElement;", "o", "Lcom/intellij/database/model/DasDataSource;", "getRoots", "Lcom/intellij/util/containers/JBIterable;", "showInfo", "info", "ForceLoadInternalAction", "ForceUnloadInternalAction", "Stat", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nModelStatisticsInternalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelStatisticsInternalAction.kt\ncom/intellij/database/actions/ModelStatisticsInternalAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,143:1\n14#2:144\n*S KotlinDebug\n*F\n+ 1 ModelStatisticsInternalAction.kt\ncom/intellij/database/actions/ModelStatisticsInternalAction\n*L\n142#1:144\n*E\n"})
public class ModelStatisticsInternalAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        int total = 0;
        int loaded2 = 0;
        for (BasicElement element2 : ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)this.getRoots(e2))).filter(BasicElement.class)) {
            ++total;
            if (!BaseModel.isLoaded(element2)) continue;
            ++loaded2;
        }
        this.showInfo("In memory: " + this.formatPercent(loaded2, total), e2);
    }

    @NotNull
    protected final String formatPercent(int loaded2, int total) {
        String string = "%2f";
        Object[] objectArray = new Object[]{(double)loaded2 * 100.0 / (double)total};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return loaded2 + "/" + total + " (" + string2 + "%)";
    }

    protected final void showInfo(@NotNull String info2, @NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(info2, MessageType.INFO, null).createBalloon();
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        balloon.show(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext), Balloon.Position.above);
    }

    @NotNull
    protected final JBIterable<BasicElement> getRoots(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBIterable jBIterable = DatabaseContextFun.getSelectedNodesExpandingGroups(dataContext).filterMap(arg_0 -> ModelStatisticsInternalAction.getRoots$lambda$0((Function1)new Function1<BasicNode, BasicElement>(this){
            final /* synthetic */ ModelStatisticsInternalAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final BasicElement invoke(BasicNode o2) {
                BasicNode basicNode = o2;
                if (basicNode instanceof BasicElement) {
                    Intrinsics.checkNotNull((Object)o2);
                    return (BasicElement)o2;
                }
                if (basicNode instanceof DasDataSource) {
                    Intrinsics.checkNotNull((Object)o2);
                    return ModelStatisticsInternalAction.access$getRoot(this.this$0, (DasDataSource)((Object)o2));
                }
                return null;
            }
        }, arg_0)).intercept(arg_0 -> ModelStatisticsInternalAction.getRoots$lambda$1((Function1)new Function1<Iterator<? extends BasicElement>, Iterator<? extends BasicElement>>(e2, this){
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ ModelStatisticsInternalAction this$0;
            {
                this.$e = $e;
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterator<BasicElement> invoke(Iterator<? extends BasicElement> it2) {
                if (it2.hasNext()) {
                    return it2;
                }
                Project project = this.$e.getProject();
                return DbSrcUtils.getDataSourceStorage(project).getDataSourcesImpl().filterMap(arg_0 -> getRoots.2.invoke$lambda$0((Function1)new Function1<LocalDataSource, BasicElement>(this.this$0){
                    final /* synthetic */ ModelStatisticsInternalAction this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final BasicElement invoke(LocalDataSource it2) {
                        Intrinsics.checkNotNull((Object)it2);
                        return ModelStatisticsInternalAction.access$getRoot(this.this$0, it2);
                    }
                }, arg_0)).iterator();
            }

            private static final BasicElement invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (BasicElement)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"intercept(...)");
        return jBIterable;
    }

    private final BasicElement getRoot(DasDataSource o2) {
        DasModel $this$asSafely$iv = o2.getModel();
        boolean $i$f$asSafely = false;
        DasModel dasModel = $this$asSafely$iv;
        if (!(dasModel instanceof BasicModel)) {
            dasModel = null;
        }
        BasicModel basicModel = (BasicModel)dasModel;
        return basicModel != null ? basicModel.getRoot() : null;
    }

    private static final BasicElement getRoots$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final Iterator getRoots$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterator)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicElement access$getRoot(ModelStatisticsInternalAction $this, DasDataSource o2) {
        return $this.getRoot(o2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction$ForceLoadInternalAction;", "Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ForceLoadInternalAction
    extends ModelStatisticsInternalAction {
        @Override
        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            int total = 0;
            int alreadyLoaded = 0;
            int loaded2 = 0;
            for (BasicElement element2 : ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)this.getRoots(e2))).filter(BasicElement.class)) {
                ++total;
                if (BaseModel.isLoaded(element2)) {
                    ++alreadyLoaded;
                    continue;
                }
                if (!BaseModel.forceLoad(element2)) continue;
                ++loaded2;
            }
            int totalLoaded = alreadyLoaded + loaded2;
            int failed = total - totalLoaded;
            this.showInfo(StringsKt.trimMargin$default((String)("\n        |Was in memory: " + this.formatPercent(alreadyLoaded, total) + "\n        |Now in memory: " + this.formatPercent(totalLoaded, total) + "\n        |Failed to load: " + this.formatPercent(failed, total) + "\n      "), null, (int)1, null), e2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction$ForceUnloadInternalAction;", "Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "computeLoaded", "Lcom/intellij/database/actions/ModelStatisticsInternalAction$Stat;", "allObjects", "", "Lcom/intellij/database/model/basic/BasicElement;", "unload", "ds", "Lcom/intellij/database/model/DasDataSource;", "selectedObjects", "", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nModelStatisticsInternalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelStatisticsInternalAction.kt\ncom/intellij/database/actions/ModelStatisticsInternalAction$ForceUnloadInternalAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n800#2,11:144\n1#3:155\n*S KotlinDebug\n*F\n+ 1 ModelStatisticsInternalAction.kt\ncom/intellij/database/actions/ModelStatisticsInternalAction$ForceUnloadInternalAction\n*L\n76#1:144,11\n*E\n"})
    public static final class ForceUnloadInternalAction
    extends ModelStatisticsInternalAction {
        /*
         * WARNING - void declaration
         */
        @Override
        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Stat stat = new Stat(0, 0, 0);
            DbContextElements<?> selection2 = DbContextElementsKt.getContextElements(e2);
            if (selection2 != null) {
                for (DbContextDataSourceElements<?> dsSelection : selection2.getSelection().values()) {
                    Set allObjects;
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    DbContextDataSourceElements<BasicNode> expanded = dsSelection.asNodes().expandGroups().dataSourcesToRoots();
                    Iterable<BasicNode> iterable = expanded.getSelection();
                    JBTreeTraverser<DasObject> jBTreeTraverser = DasUtil.dasTraverser();
                    boolean $i$f$filterIsInstance = false;
                    void var10_12 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof BasicElement)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)((JBTreeTraverser)jBTreeTraverser.withRoots((Iterable)((List)destination$iv$iv))).filter(BasicElement.class).toSet(), (String)"toSet(...)");
                    stat.plusAssign(this.unload(dsSelection.getDataSource(), allObjects));
                }
            } else {
                for (LocalDataSource dataSource2 : DataSourceStorage.getStorage(e2.getProject()).getDataSources()) {
                    Intrinsics.checkNotNull((Object)dataSource2);
                    stat.plusAssign(this.unload(dataSource2, null));
                }
            }
            this.showInfo(StringsKt.trimMargin$default((String)("\n        |Was in memory: " + this.formatPercent(stat.getLoaded(), stat.getTotal()) + "\n        |Now in memory: " + this.formatPercent(stat.getLoaded() - stat.getUnloaded(), stat.getTotal()) + "\n        |Unloaded: " + this.formatPercent(stat.getUnloaded(), stat.getLoaded()) + "\n      "), null, (int)1, null), e2);
        }

        private final Stat unload(DasDataSource ds, Set<? extends BasicElement> selectedObjects) {
            Condition condition2;
            Iterable iterable;
            DasModel dasModel = ds.getModel();
            BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            if (basicModel == null) {
                return new Stat(0, 0, 0);
            }
            BasicModel model2 = basicModel;
            Set<? extends BasicElement> set = selectedObjects;
            if (set != null) {
                iterable = set;
            } else {
                JBTreeTraverser<BasicElement> jBTreeTraverser = model2.basicTraverser();
                Intrinsics.checkNotNullExpressionValue(jBTreeTraverser, (String)"basicTraverser(...)");
                iterable = (Iterable)jBTreeTraverser;
            }
            Iterable allObjects = iterable;
            Stat stat1 = this.computeLoaded(allObjects);
            BasicModel basicModel2 = model2;
            boolean bl = false;
            Set<? extends BasicElement> set2 = selectedObjects;
            if (set2 != null) {
                Set<? extends BasicElement> set3 = set2;
                boolean bl2 = bl;
                BasicModel basicModel3 = basicModel2;
                boolean bl3 = false;
                Condition condition3 = arg_0 -> ForceUnloadInternalAction.unload$lambda$1$lambda$0(selectedObjects, arg_0);
                basicModel2 = basicModel3;
                bl = bl2;
                condition2 = condition3;
            } else {
                condition2 = null;
            }
            BaseModel.forceUnload(basicModel2, bl, condition2);
            Stat stat2 = this.computeLoaded(allObjects);
            stat1.setUnloaded(RangesKt.coerceAtLeast((int)(stat1.getLoaded() - stat2.getLoaded()), (int)0));
            return stat1;
        }

        private final Stat computeLoaded(Iterable<? extends BasicElement> allObjects) {
            Stat stat = new Stat(0, 0, 0);
            for (BasicElement basicElement : allObjects) {
                if (BaseModel.isUnderSubstituted(basicElement)) continue;
                stat.setTotal(stat.getTotal() + 1);
                if (!BaseModel.isLoaded(basicElement)) continue;
                stat.setLoaded(stat.getLoaded() + 1);
            }
            return stat;
        }

        private static final boolean unload$lambda$1$lambda$0(Set $selectedObjects, BasicElement it2) {
            return $selectedObjects.contains(it2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction$Stat;", "", "total", "", "loaded", "unloaded", "(III)V", "getLoaded", "()I", "setLoaded", "(I)V", "getTotal", "setTotal", "getUnloaded", "setUnloaded", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "plusAssign", "", "o", "toString", "", "intellij.database.impl"})
    private static final class Stat {
        private int total;
        private int loaded;
        private int unloaded;

        public Stat(int total, int loaded2, int unloaded) {
            this.total = total;
            this.loaded = loaded2;
            this.unloaded = unloaded;
        }

        public final int getTotal() {
            return this.total;
        }

        public final void setTotal(int n) {
            this.total = n;
        }

        public final int getLoaded() {
            return this.loaded;
        }

        public final void setLoaded(int n) {
            this.loaded = n;
        }

        public final int getUnloaded() {
            return this.unloaded;
        }

        public final void setUnloaded(int n) {
            this.unloaded = n;
        }

        public final void plusAssign(@NotNull Stat o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            this.total += o2.total;
            this.loaded += o2.loaded;
            this.unloaded += o2.unloaded;
        }

        public final int component1() {
            return this.total;
        }

        public final int component2() {
            return this.loaded;
        }

        public final int component3() {
            return this.unloaded;
        }

        @NotNull
        public final Stat copy(int total, int loaded2, int unloaded) {
            return new Stat(total, loaded2, unloaded);
        }

        public static /* synthetic */ Stat copy$default(Stat stat, int n, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = stat.total;
            }
            if ((n5 & 2) != 0) {
                n3 = stat.loaded;
            }
            if ((n5 & 4) != 0) {
                n4 = stat.unloaded;
            }
            return stat.copy(n, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Stat(total=" + this.total + ", loaded=" + this.loaded + ", unloaded=" + this.unloaded + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.total);
            result2 = result2 * 31 + Integer.hashCode(this.loaded);
            result2 = result2 * 31 + Integer.hashCode(this.unloaded);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stat)) {
                return false;
            }
            Stat stat = (Stat)other;
            if (this.total != stat.total) {
                return false;
            }
            if (this.loaded != stat.loaded) {
                return false;
            }
            return this.unloaded == stat.unloaded;
        }
    }
}

