/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class ExplainActionBase
extends QueryActionBase {
    protected final boolean myRun;

    protected ExplainActionBase(boolean run2) {
        this.myRun = run2;
    }

    @Override
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            ExplainActionBase.$$$reportNull$$$0(0);
        }
        if (!this.isSupported(e2)) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e2);
    }

    @Override
    protected void invokeImpl(@Nullable JdbcConsole console, @NotNull ScriptModel<?> scriptModel, @NotNull JdbcConsoleProvider.Info info2) {
        if (scriptModel == null) {
            ExplainActionBase.$$$reportNull$$$0(1);
        }
        if (info2 == null) {
            ExplainActionBase.$$$reportNull$$$0(2);
        }
        if (console == null) {
            return;
        }
        ExplainPlanProvider provider = ExplainPlanProvider.getDefaultProvider(console.getDataSource());
        if (provider == null) {
            return;
        }
        ScriptModel<?> adjusted2 = provider.adjustModel(scriptModel);
        if (!console.beforeExecuteQueries(adjusted2)) {
            return;
        }
        try {
            for (ScriptModel.StatementIt it2 : adjusted2.statements()) {
                try {
                    String text2 = it2.consoleQuery(console.getPStorage(), Conditions.alwaysFalse());
                    this.explainStatement(provider, console, text2);
                }
                catch (TranslateException ex) {
                    ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint((Editor)info2.editor, ex.getMessage()));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage().contains("@NotNull")) {
                throw ex;
            }
            Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)this.getTemplatePresentation().getText());
        }
        catch (UnsupportedOperationException ex) {
            Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)this.getTemplatePresentation().getText());
        }
    }

    protected abstract boolean isSupported(AnActionEvent var1);

    protected abstract void explainStatement(@NotNull ExplainPlanProvider var1, @NotNull JdbcConsole var2, @NotNull String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/ExplainActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Raw
    extends ExplainActionBase {
        protected Raw(boolean run2) {
            super(run2);
        }

        @Override
        protected boolean isSupported(AnActionEvent e2) {
            JdbcConsole console = Raw.getConsole(e2);
            ExplainPlanProvider provider = console != null ? ExplainPlanProvider.getDefaultProvider(console.getDataSource()) : null;
            return provider != null && provider.isRawSupported(console.getDataSource().getVersion(), this.myRun);
        }

        @Override
        protected void explainStatement(@NotNull ExplainPlanProvider provider, @NotNull JdbcConsole console, @NotNull String script2) {
            ExplainPlanProvider.RawExplainTask task;
            if (provider == null) {
                Raw.$$$reportNull$$$0(0);
            }
            if (console == null) {
                Raw.$$$reportNull$$$0(1);
            }
            if (script2 == null) {
                Raw.$$$reportNull$$$0(2);
            }
            if ((task = provider.createRawExplainTask(console.getDataSource(), this.myRun)) != null) {
                Raw.performTask(console, script2, task);
            }
        }

        private static void performTask(@NotNull JdbcConsole console, @NotNull String script2, ExplainPlanProvider.RawExplainTask task) {
            if (console == null) {
                Raw.$$$reportNull$$$0(3);
            }
            if (script2 == null) {
                Raw.$$$reportNull$$$0(4);
            }
            Raw.executePreRequest(console, task).thenApply(r1 -> {
                CompletionStage<Void> promise = Raw.executeExplainBody(console, script2, task);
                DataRequest.RawRequest postRequest = task.sqlPostExplainPlan(console);
                if (postRequest != null) {
                    promise.whenComplete((r, th) -> console.getMessageBus().getDataProducer().processRequest((GridDataRequest)postRequest));
                }
                return null;
            });
        }

        @NotNull
        private static CompletableFuture<Void> executePreRequest(@NotNull JdbcConsole console, ExplainPlanProvider.RawExplainTask task) {
            CompletableFuture<Object> preRequest;
            DataRequest.RawRequest request2;
            if (console == null) {
                Raw.$$$reportNull$$$0(5);
            }
            if ((request2 = task.sqlPreExplainPlan(console)) != null) {
                preRequest = Raw.adapt(request2.getPromise(), true);
                console.getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
            } else {
                preRequest = CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Object> completableFuture = preRequest;
            if (completableFuture == null) {
                Raw.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }

        private static CompletionStage<Void> executeExplainBody(@NotNull JdbcConsole console, @NotNull String script2, @NotNull ExplainPlanProvider.RawExplainTask task) {
            if (console == null) {
                Raw.$$$reportNull$$$0(7);
            }
            if (script2 == null) {
                Raw.$$$reportNull$$$0(8);
            }
            if (task == null) {
                Raw.$$$reportNull$$$0(9);
            }
            StringBuilder sb = new StringBuilder();
            DdlBuilder builder = new DdlBuilder(sb);
            SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(console.getDataSource());
            builder.applyCodeStyle(console.getProject(), dialect);
            task.sqlExplainPlan(builder, script2);
            return Raw.execute(console, builder.getStatement(), true);
        }

        private static CompletionStage<Void> execute(@NotNull JdbcConsole console, @NotNull String script2, boolean stopOnError) {
            if (console == null) {
                Raw.$$$reportNull$$$0(10);
            }
            if (script2 == null) {
                Raw.$$$reportNull$$$0(11);
            }
            SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)console.getProject());
            PsiFile psi = PsiFileFactory.getInstance((Project)console.getProject()).createFileFromText("a.sql", console.getLanguage(), (CharSequence)script2);
            ScriptModel model2 = facade.createScriptModel(psi);
            return Raw.perform(console, model2.statements().transform(ScriptModelUtilCore.TO_QUERY).iterator(), stopOnError);
        }

        static CompletionStage<Void> perform(@NotNull JdbcConsole console, @NotNull Iterator<String> it2, boolean stopOnError) {
            if (console == null) {
                Raw.$$$reportNull$$$0(12);
            }
            if (it2 == null) {
                Raw.$$$reportNull$$$0(13);
            }
            if (!it2.hasNext()) {
                return null;
            }
            String query = it2.next();
            if (StringUtil.isEmptyOrSpaces((String)query)) {
                return Raw.perform(console, it2, stopOnError);
            }
            GridDataRequest request2 = DataRequest.newLimitlessRequest(console, query);
            AsyncPromise promise = request2.getPromise();
            CompletionStage<Void> res2 = AsyncUtil.thenComposeAsync(Raw.adapt((AsyncPromise<Void>)promise, stopOnError), r -> Raw.perform(console, it2, stopOnError), Runnable::run);
            console.getMessageBus().getDataProducer().processRequest(request2);
            return res2;
        }

        @NotNull
        private static CompletableFuture<Void> adapt(AsyncPromise<Void> promise, boolean stopOnError) {
            CompletableFuture<Void> res2 = new CompletableFuture<Void>();
            if (stopOnError) {
                promise.onError(th -> res2.completeExceptionally((Throwable)th));
                promise.onSuccess(r -> res2.complete((Void)r));
            } else {
                promise.onProcessed(r -> res2.complete((Void)r));
            }
            CompletableFuture<Void> completableFuture = res2;
            if (completableFuture == null) {
                Raw.$$$reportNull$$$0(14);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: 
                case 4: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 6: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ExplainActionBase$Raw";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "it";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ExplainActionBase$Raw";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executePreRequest";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adapt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "explainStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "performTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "executePreRequest";
                    break;
                }
                case 6: 
                case 14: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "executeExplainBody";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 14 -> new IllegalStateException(string);
            };
        }

        public static class Analyse
        extends Raw {
            public Analyse() {
                super(true);
            }
        }

        public static class Plan
        extends Raw {
            public Plan() {
                super(false);
            }
        }
    }

    public static abstract class Ui
    extends ExplainActionBase {
        protected Ui(boolean run2) {
            super(run2);
        }

        @Override
        protected boolean isSupported(AnActionEvent e2) {
            JdbcConsole console = Ui.getConsole(e2);
            ExplainPlanProvider provider = console != null ? ExplainPlanProvider.getDefaultProvider(console.getDataSource()) : null;
            return provider != null && provider.isSupported(console.getDataSource().getVersion(), this.myRun);
        }

        @Override
        protected void explainStatement(@NotNull ExplainPlanProvider provider, @NotNull JdbcConsole console, @NotNull String statement2) {
            DataRequest.RawRequest request2;
            if (provider == null) {
                Ui.$$$reportNull$$$0(0);
            }
            if (console == null) {
                Ui.$$$reportNull$$$0(1);
            }
            if (statement2 == null) {
                Ui.$$$reportNull$$$0(2);
            }
            if ((request2 = provider.createExplainRequest(console, (Consumer<? super PlanModel>)((Consumer)model2 -> UIUtil.invokeLaterIfNeeded(() -> console.showPlan((PlanModel)model2))), console.getDataSource(), statement2, this.myRun)) == null) {
                return;
            }
            console.getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/ExplainActionBase$Ui";
            objectArray[2] = "explainStatement";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class Analyse
        extends Ui {
            public Analyse() {
                super(true);
            }
        }

        public static class Plan
        extends Ui {
            public Plan() {
                super(false);
            }
        }
    }
}

