/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.FullTextSearchDialog;
import com.intellij.find.FindModel;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.project.Project;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseStringUsageTarget
implements ConfigurableUsageTarget,
ItemPresentation {
    private final Project myProject;
    private final FindModel myFindModel;
    private final FullTextSearchOptions myOptions;
    private final Collection<DbTable> myTargets;

    DatabaseStringUsageTarget(@NotNull Project project, @NotNull FindModel findModel, @NotNull FullTextSearchOptions options2, @NotNull Collection<DbTable> targets2) {
        if (project == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(0);
        }
        if (findModel == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(1);
        }
        if (options2 == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myFindModel = findModel;
        this.myOptions = options2;
        this.myTargets = targets2;
    }

    @NotNull
    public String getPresentableText() {
        String string = DatabaseBundle.message("occurrences.in.database", this.myFindModel.getStringToFind());
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return AllIcons.Actions.Find;
    }

    public void showSettings() {
        new FullTextSearchDialog(this.myProject, this.myOptions, this.myTargets).show();
    }

    public KeyboardShortcut getShortcut() {
        return null;
    }

    @Nls
    @NotNull
    public String getLongDescriptiveName() {
        String string = this.getPresentableText();
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void findUsages() {
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public String getName() {
        DbElement item = (DbElement)ContainerUtil.getFirstItem(this.myTargets);
        Dbms dbms = item == null ? Dbms.UNKNOWN : DbImplUtilCore.getDbms(item);
        DbImplUtilCore.StringLiteralDecorator decorator = FullTextSearchAction.Companion.toDecorator(this.myOptions.getLocation());
        String string = decorator.decorate(this.myOptions.getText(), dbms);
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseStringUsageTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseStringUsageTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

