/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/BasicModelRegistry;", "Lcom/intellij/openapi/Disposable;", "()V", "disposed", "", "models", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/RawDataSource;", "collectModels", "", "dataSources", "", "dispose", "getDataSource", "model", "getLocalDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "Companion", "DataSourceListener", "ProjectManagerEventListener", "StorageListener", "intellij.database.core.impl"})
public final class BasicModelRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<BasicModel, RawDataSource> models;
    private boolean disposed;

    public BasicModelRegistry() {
        Cache cache2 = Caffeine.newBuilder().weakKeys().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.models = cache2;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic<AbstractDataSource.Listener> topic = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DataSourceListener());
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new StorageListener());
        messageBusConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectManagerEventListener());
        List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        List<LocalDataSource> globalDataSources = list;
        this.collectModels((Iterable<? extends RawDataSource>)globalDataSources);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project p2 : projectArray) {
            List<LocalDataSource> projectDataSources;
            Intrinsics.checkNotNullExpressionValue(DataSourceStorage.getProjectStorage(p2).getDataSources(), (String)"getDataSources(...)");
            this.collectModels((Iterable<? extends RawDataSource>)projectDataSources);
        }
    }

    private final void collectModels(Iterable<? extends RawDataSource> dataSources2) {
        for (RawDataSource rawDataSource : dataSources2) {
            DasModel dasModel = rawDataSource.getModel();
            BasicModel m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            if (m == null) continue;
            this.models.put((Object)m, (Object)rawDataSource);
        }
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return (RawDataSource)this.models.getIfPresent((Object)model2);
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        RawDataSource rawDataSource = this.getDataSource(model2);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    public void dispose() {
        this.disposed = true;
        this.models.invalidateAll();
    }

    @JvmStatic
    @NotNull
    public static final BasicModelRegistry instance() {
        return Companion.instance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/BasicModelRegistry$Companion;", "", "()V", "instance", "Lcom/intellij/database/BasicModelRegistry;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BasicModelRegistry instance() {
            Object object = ApplicationManager.getApplication().getService(BasicModelRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BasicModelRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/BasicModelRegistry$DataSourceListener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "(Lcom/intellij/database/BasicModelRegistry;)V", "onModelReplaced", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "intellij.database.core.impl"})
    private final class DataSourceListener
    implements AbstractDataSource.Listener {
        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            if (oldModel != null) {
                BasicModelRegistry.this.models.invalidate((Object)oldModel);
            }
            if (newModel != null) {
                BasicModelRegistry.this.models.put((Object)newModel, (Object)dataSource2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/BasicModelRegistry$ProjectManagerEventListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "(Lcom/intellij/database/BasicModelRegistry;)V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.core.impl"})
    private final class ProjectManagerEventListener
    implements ProjectCloseListener {
        public void projectClosed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DvTreeInternalFunKt.invalidateEntriesThat(BasicModelRegistry.this.models, (Function2)new Function2<BasicModel, RawDataSource, Boolean>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull BasicModel m, @NotNull RawDataSource ds) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                    SqlDataSource sqlDataSource = ds instanceof SqlDataSource ? (SqlDataSource)ds : null;
                    if ((sqlDataSource != null ? sqlDataSource.getProject() : null) != this.$project) {
                        BasicModModel basicModModel = m instanceof BasicModModel ? (BasicModModel)m : null;
                        ModelTextStorage modelTextStorage = basicModModel != null ? basicModModel.getTextStorage() : null;
                        DbSrcModelStorageCore dbSrcModelStorageCore = modelTextStorage instanceof DbSrcModelStorageCore ? (DbSrcModelStorageCore)modelTextStorage : null;
                        if ((dbSrcModelStorageCore != null ? dbSrcModelStorageCore.getProject() : null) != this.$project) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/BasicModelRegistry$StorageListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "(Lcom/intellij/database/BasicModelRegistry;)V", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.core.impl"})
    private final class StorageListener
    implements DataSourceStorage.Listener {
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            BasicModel m;
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            DasModel dasModel = dataSource2.getModel();
            BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            if (m != null) {
                BasicModelRegistry.this.models.invalidate((Object)m);
            }
        }
    }
}

