/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.ArrayPresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerBundle;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0003UVWB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ(\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020\u0004H\u0002J\b\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020-2\u0006\u00108\u001a\u0002092\u0006\u00105\u001a\u000206H\u0002J$\u0010:\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010 \u001a\u00020;2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u000202H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J&\u0010A\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010 \u001a\u00020B2\u0006\u00105\u001a\u0002062\u0006\u0010<\u001a\u000202H\u0002J\u0018\u0010C\u001a\u00020-2\u0006\u00105\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010C\u001a\u00020-2\u0006\u0010 \u001a\u00020!2\u0006\u00105\u001a\u00020DH\u0002J\u0010\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020IH\u0016J\n\u0010J\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010K\u001a\u0004\u0018\u00010LH\u0016J\b\u0010M\u001a\u0004\u0018\u00010!JF\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00105\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u000202H\u0002J$\u0010R\u001a\u00020-2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010S\u001a\u0004\u0018\u00010\u00042\u0006\u00105\u001a\u00020DH\u0002J\b\u0010T\u001a\u000202H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006X"}, d2={"Lorg/jetbrains/debugger/VariableView;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lorg/jetbrains/debugger/VariableContext;", "variableName", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "(Ljava/lang/String;Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "_memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "memberFilter", "Lorg/jetbrains/concurrency/Promise;", "getMemberFilter", "()Lorg/jetbrains/concurrency/Promise;", "parent", "getParent", "()Lorg/jetbrains/debugger/VariableContext;", "remainingChildren", "", "scope", "Lorg/jetbrains/debugger/Scope;", "getScope", "()Lorg/jetbrains/debugger/Scope;", "value", "Lorg/jetbrains/debugger/values/Value;", "getVariableName", "()Ljava/lang/String;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "getViewSupport", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "addVarName", "", "list", "Lcom/intellij/util/SmartList;", "name", "canNavigateToSource", "", "computeArrayRanges", "properties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeChildren", "remainingChildrenOffset", "", "computeIndexedProperties", "Lorg/jetbrains/debugger/values/ArrayValue;", "isLastChildren", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeNamedProperties", "Lorg/jetbrains/debugger/values/ObjectValue;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getEvaluationExpression", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "getValue", "processNamedObjectProperties", "variables", "maxChildrenToAdd", "defaultIsLast", "setEvaluatedValue", "error", "watchableAsEvaluationExpression", "Companion", "MyFullValueEvaluator", "ObsolescentIndexedVariablesConsumer", "intellij.javascript.debugger.ui"})
@SourceDebugExtension(value={"SMAP\nVariableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,566:1\n1747#2,3:567\n130#3,3:570\n115#3,2:573\n*S KotlinDebug\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView\n*L\n128#1:567,3\n208#1:570,3\n213#1:573,2\n*E\n"})
public final class VariableView
extends XNamedValue
implements VariableContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String variableName;
    @NotNull
    private final Variable variable;
    @NotNull
    private final VariableContext context;
    @Nullable
    private volatile Value value;
    @Nullable
    private MemberFilter _memberFilter;
    @Nullable
    private volatile List<? extends Variable> remainingChildren;
    @NotNull
    private final VariableContext parent;

    public VariableView(@NotNull String variableName, @NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(variableName);
        this.variableName = variableName;
        this.variable = variable;
        this.parent = this.context = context;
    }

    @Override
    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.context.getViewSupport();
    }

    @Override
    @NotNull
    public VariableContext getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.context.getViewSupport().getMemberFilter(this);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.context.getEvaluateContext();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.context.getVm();
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.value = this.variable.getValue();
        if (this.value != null) {
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value);
            this.computePresentation(value, node);
            return;
        }
        if (!(this.variable instanceof ObjectProperty) || ((ObjectProperty)this.variable).getGetter() == null) {
            this.context.getMemberFilter().then(arg_0 -> VariableView.computePresentation$lambda$0((Function1)new Function1<MemberFilter, Promise<? extends Object>>(this, node){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Promise<? extends Object> invoke(MemberFilter filter) {
                    void $this$onError$iv;
                    Obsolescent node$iv;
                    Promise $this$onSuccess$iv;
                    EvaluateContext evaluateContext = this.this$0.getEvaluateContext();
                    String string = VariableView.access$getVariable$p(this.this$0).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = filter.sourceNameToRaw(string);
                    if (string2 == null) {
                        String string3 = VariableView.access$getVariable$p(this.this$0).getName();
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    }
                    Promise promise2 = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)string2, null, (boolean)false, null, (int)14, null);
                    Obsolescent obsolescent = (Obsolescent)this.$node;
                    VariableView variableView = this.this$0;
                    XValueNode xValueNode = this.$node;
                    boolean $i$f$onSuccess = false;
                    Promise promise3 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, variableView, xValueNode){
                        final /* synthetic */ VariableView this$0;
                        final /* synthetic */ XValueNode $node$inlined;
                        {
                            this.this$0 = variableView;
                            this.$node$inlined = xValueNode;
                            super($node);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public void accept(Object param) {
                            EvaluateResult it = (EvaluateResult)param;
                            boolean bl = false;
                            if (it.getWasThrown()) {
                                VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(it.getValue(), null), null, this.$node$inlined);
                            } else {
                                VariableView.access$setValue$p(this.this$0, it.getValue());
                                VariableView.access$getVariable$p(this.this$0).setValue(it.getValue());
                                VariableView.access$computePresentation(this.this$0, it.getValue(), this.$node$inlined);
                            }
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onSuccess(...)");
                    $this$onSuccess$iv = promise3;
                    node$iv = (Obsolescent)this.$node;
                    variableView = this.this$0;
                    xValueNode = this.$node;
                    boolean $i$f$onError = false;
                    Promise promise4 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, variableView, xValueNode){
                        final /* synthetic */ VariableView this$0;
                        final /* synthetic */ XValueNode $node$inlined;
                        {
                            this.this$0 = variableView;
                            this.$node$inlined = xValueNode;
                            super($node);
                        }

                        public void accept(@NotNull Throwable param) {
                            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                            Throwable it = param;
                            boolean bl = false;
                            VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(null, it.getMessage()), it.getMessage(), this.$node$inlined);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"onError(...)");
                    return promise4;
                }
            }, arg_0));
            return;
        }
        node.setPresentation(null, new XValuePresentation(){

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                renderer.renderValue("\u2026");
            }
        }, false);
        String string = ScriptDebuggerBundle.message((String)"full.evaluator.invoke.getter", (Object[])new Object[0]);
        node.setFullValueEvaluator(new XFullValueEvaluator(this, node, string){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback2) {
                void node$iv;
                void $this$onSuccess$iv;
                Object object;
                VariableView context;
                Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
                ValueModifier valueModifier2 = ((ObjectProperty)VariableView.access$getVariable$p(this.this$0)).getValueModifier();
                VariableContext nonProtoContext = VariableView.access$getContext$p(this.this$0);
                while (nonProtoContext instanceof VariableView && VariableViewKt.isPrototypeVariable(((VariableView)nonProtoContext).getVariableName())) {
                    valueModifier2 = VariableView.access$getVariable$p((VariableView)nonProtoContext).getValueModifier();
                    nonProtoContext = ((VariableView)nonProtoContext).getParent();
                }
                if (valueModifier2 == null) {
                    VariableContext variableContext = nonProtoContext;
                    Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.VariableView");
                    context = (VariableView)variableContext;
                    object = VariableView.access$getVariable$p(context).getValue();
                    ValueModifier valueModifier3 = object instanceof ValueModifier ? (ValueModifier)object : null;
                    if (valueModifier3 == null) {
                        return;
                    }
                    valueModifier2 = valueModifier3;
                }
                context = valueModifier2.evaluateGet(VariableView.access$getVariable$p(this.this$0), this.this$0.getEvaluateContext());
                Obsolescent obsolescent = (Obsolescent)this.$node;
                object = this.this$0;
                XValueNode xValueNode = this.$node;
                boolean $i$f$onSuccess = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<Value>((Obsolescent)node$iv, callback2, (VariableView)object, xValueNode){
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback$inlined;
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ XValueNode $node$inlined;
                    {
                        this.$callback$inlined = xFullValueEvaluationCallback;
                        this.this$0 = variableView;
                        this.$node$inlined = xValueNode;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        Value it = (Value)param;
                        boolean bl = false;
                        this.$callback$inlined.evaluated("");
                        VariableView.access$setEvaluatedValue(this.this$0, it, null, this.$node$inlined);
                    }
                }), (String)"onSuccess(...)");
            }
        }.setShowValuePopup(false));
    }

    private final void setEvaluatedValue(Value value, String error, XValueNode node) {
        if (value == null) {
            String string = error;
            if (string == null) {
                string = "Internal Error";
            }
            node.setPresentation(AllIcons.Debugger.Db_primitive, null, string, false);
        } else {
            this.value = value;
            this.computePresentation(value, node);
        }
    }

    private final void computePresentation(Value value, XValueNode node) {
        boolean bl;
        block15: {
            Iterable $this$any$iv = JavaScriptDebugAware.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JavaScriptDebugAware it = (JavaScriptDebugAware)element$iv;
                    boolean bl2 = false;
                    if (!it.computeAlternativeValuePresentation(value, node, this.getIcon())) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (this.variable instanceof ObjectProperty) {
            String string = ((ObjectProperty)this.variable).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (VariableViewKt.isPrototypeVariable(string) && value.getType() != ValueType.NULL) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                Companion.setObjectPresentation((ObjectValue)value, this.getIcon(), node);
                return;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
            case 1: 
            case 2: {
                DebuggerViewSupport debuggerViewSupport = this.context.getViewSupport();
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                debuggerViewSupport.computeObjectPresentation((ObjectValue)value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 3: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableViewKt.trimFunctionDescription(value)), true);
                break;
            }
            case 4: {
                this.context.getViewSupport().computeArrayPresentation(value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon, (XValuePresentation)new XKeywordValuePresentation(string), false);
                break;
            }
            case 8: 
            case 9: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon, VariableViewKt.access$createNumberPresentation(string), false);
                break;
            }
            case 10: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(string), false);
                if (!(value instanceof StringValue) || !((StringValue)value).isTruncated()) {
                    String string2 = value.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    if (string2.length() <= 1000) break;
                }
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value));
                break;
            }
            default: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                node.setPresentation(icon, null, string, true);
            }
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ApplicationManager.getApplication().executeOnPooledThread(() -> VariableView.computeChildren$lambda$2(this, node));
    }

    private final void computeChildren(int remainingChildrenOffset, XCompositeNode node) {
        node.setAlreadySorted(true);
        if (!(this.value instanceof ObjectValue)) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        if (remainingChildrenOffset > 0) {
            List<? extends Variable> list = this.remainingChildren;
            Intrinsics.checkNotNull(list);
            List<? extends Variable> list2 = list;
            int to = RangesKt.coerceAtMost((int)(remainingChildrenOffset + 100), (int)list2.size());
            boolean isLast = to == list2.size();
            node.addChildren(VariablesKt.createVariablesList(list2, remainingChildrenOffset, to, this, this._memberFilter), isLast);
            if (!isLast) {
                node.tooManyChildren(list2.size() - to, () -> VariableView.computeChildren$lambda$3(this, remainingChildrenOffset, node));
            }
            return;
        }
        Value value = this.value;
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
        ObjectValue objectValue = (ObjectValue)value;
        boolean hasNamedProperties = objectValue.hasProperties() != ThreeState.NO;
        boolean hasIndexedProperties = objectValue.hasIndexedProperties() != ThreeState.NO;
        SmartList promises = new SmartList();
        Promise<Object> additionalProperties = this.getViewSupport().computeAdditionalObjectProperties(objectValue, this.variable, this, node);
        if (additionalProperties != null) {
            promises.add(additionalProperties);
        }
        if (hasIndexedProperties) {
            promises.add(this.computeIndexedProperties((ArrayValue)objectValue, node, !hasNamedProperties && additionalProperties == null));
        }
        if (hasNamedProperties) {
            if (additionalProperties == null || additionalProperties.getState() != Promise.State.PENDING) {
                promises.add(this.computeNamedProperties(objectValue, node, !hasIndexedProperties && additionalProperties == null));
            } else {
                Promise<Object> $this$thenAsync$iv = additionalProperties;
                boolean $i$f$thenAsync = false;
                Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<Object, Unit>((Obsolescent)node, this, objectValue, node){
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ ObjectValue $objectValue$inlined;
                    final /* synthetic */ XCompositeNode $node$inlined;
                    {
                        this.this$0 = variableView;
                        this.$objectValue$inlined = objectValue;
                        this.$node$inlined = xCompositeNode;
                        super($node);
                    }

                    @NotNull
                    public Promise<Unit> fun(Object param) {
                        Object it = param;
                        boolean bl = false;
                        return VariableView.access$computeNamedProperties(this.this$0, this.$objectValue$inlined, this.$node$inlined, true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
                promises.add((Object)promise2);
            }
        }
        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
            Promise $this$processed$iv = Promises.all((Collection)((Collection)promises));
            boolean $i$f$processed = false;
            Promise promise3 = $this$processed$iv.onProcessed((Consumer)new ObsolescentConsumer<Object>((Obsolescent)node, node){
                final /* synthetic */ XCompositeNode $node$inlined;
                {
                    this.$node$inlined = xCompositeNode;
                    super($node);
                }

                public void accept(@Nullable Object param) {
                    boolean bl = false;
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onProcessed(...)");
        }
    }

    private final Promise<?> computeIndexedProperties(ArrayValue value, XCompositeNode node, boolean isLastChildren) {
        return ObjectValue.getIndexedProperties$default((ObjectValue)((ObjectValue)value), (int)0, (int)value.getLength(), (int)100, (IndexedVariablesConsumer)new ObsolescentIndexedVariablesConsumer(node, value, this, isLastChildren){
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ ArrayValue $value;
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ boolean $isLastChildren;
            {
                this.$node = $node;
                this.$value = $value;
                this.this$0 = $receiver;
                this.$isLastChildren = $isLastChildren;
                super($node);
            }

            public void consumeRanges(@Nullable int[] ranges2) {
                if (ranges2 == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroupKt.addGroups(this.$value, computeIndexedProperties.consumeRanges.1.INSTANCE, groupList, 0, this.$value.getLength(), 100, this.this$0);
                    this.$node.addChildren(groupList, this.$isLastChildren);
                } else {
                    LazyVariablesGroupKt.addRanges((ObjectValue)this.$value, ranges2, this.$node, this.this$0, this.$isLastChildren);
                }
            }

            public void consumeVariables(@NotNull List<? extends Variable> variables) {
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, this.this$0, null), this.$isLastChildren);
            }
        }, null, (int)16, null);
    }

    private final Promise<Unit> computeNamedProperties(ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return VariablesKt.processVariables(this, (Promise<List<Variable>>)value.getProperties(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(this, value, node, isLastChildren){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ObjectValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                this.$node = $node;
                this.$isLastChildren = $isLastChildren;
                super(2);
            }

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                FunctionValue functionValue;
                Intrinsics.checkNotNullParameter((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                VariableView.access$set_memberFilter$p(this.this$0, memberFilter);
                if (this.$value.getType() == ValueType.ARRAY && !(this.$value instanceof ArrayValue)) {
                    VariableView.access$computeArrayRanges(this.this$0, variables, this.$node);
                    return;
                }
                ObjectValue objectValue = this.$value;
                FunctionValue functionValue2 = functionValue = objectValue instanceof FunctionValue ? (FunctionValue)objectValue : null;
                if (functionValue != null && functionValue.hasScopes() == ThreeState.NO) {
                    functionValue = null;
                }
                VariableView.access$setRemainingChildren$p(this.this$0, VariableView.access$processNamedObjectProperties(this.this$0, variables, this.$node, this.this$0, memberFilter, 100, this.$isLastChildren && functionValue == null));
                if (functionValue != null) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.access$getContext$p(this.this$0))), this.$isLastChildren && VariableView.access$getRemainingChildren$p(this.this$0) == null);
                }
            }
        }));
    }

    private final List<Variable> processNamedObjectProperties(List<? extends Variable> variables, XCompositeNode node, VariableContext context, MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        List<Variable> list = VariablesKt.filterAndSort(variables, memberFilter);
        if (list.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = RangesKt.coerceAtMost((int)maxChildrenToAdd, (int)list.size());
        boolean isLast = to == list.size();
        node.addChildren(VariablesKt.createVariablesList(list, 0, to, context, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list.size() - to, () -> VariableView.processNamedObjectProperties$lambda$6(this, node));
        return list;
    }

    private final void computeArrayRanges(List<? extends Variable> properties, XCompositeNode node) {
        int count;
        MemberFilter memberFilter = this._memberFilter;
        Intrinsics.checkNotNull((Object)memberFilter);
        List<Variable> variables = VariablesKt.filterAndSort(properties, memberFilter);
        int bucketSize = 100;
        if (count <= bucketSize) {
            node.addChildren(VariablesKt.createVariablesList(variables, this, null), true);
            return;
        }
        for (count = variables.size(); count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0)); --count) {
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.1.INSTANCE, groupList, 0, count, bucketSize, this);
        }
        int notGroupedVariablesOffset = 0;
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0; --notGroupedVariablesOffset) {
                String string = variables.get(notGroupedVariablesOffset - 1).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"__", (boolean)false, (int)2, null)) break;
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.2.INSTANCE, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        int n = variables.size();
        for (int i = notGroupedVariablesOffset; i < n; ++i) {
            Variable variable = variables.get(i);
            MemberFilter memberFilter2 = this._memberFilter;
            Intrinsics.checkNotNull((Object)memberFilter2);
            groupList.add((XNamedValue)new VariableView(memberFilter2.rawNameToSource(variable), variable, this));
        }
        node.addChildren(groupList, true);
    }

    private final Icon getIcon() {
        Value value = this.value;
        Intrinsics.checkNotNull((Object)value);
        return Companion.getIcon(value);
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(this){
            final /* synthetic */ VariableView this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public String getInitialValueEditorText() {
                String string;
                Value value = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value);
                if (value.getType() == ValueType.STRING) {
                    Value value2 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value2);
                    String string2 = value2.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2;
                    StringBuilder builder = new StringBuilder(string3.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string3.length(), (String)string3, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                Value value3 = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value3);
                if (value3.getType().isObjectType()) {
                    string = null;
                } else {
                    Value value4 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value4);
                    string = value4.getValueString();
                }
                return string;
            }

            public void setValue(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback2) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
                ValueModifier valueModifier2 = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                Intrinsics.checkNotNull((Object)valueModifier2);
                Variable variable = VariableView.access$getVariable$p(this.this$0);
                String string = expression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
                valueModifier2.setValue(variable, string, this.this$0.getEvaluateContext()).onSuccess(arg_0 -> getModifier.1.setValue$lambda$0(this.this$0, callback2, arg_0)).onError(arg_0 -> getModifier.1.setValue$lambda$1((Function1)new Function1<Throwable, Unit>(callback2){
                    final /* synthetic */ XValueModifier.XModificationCallback $callback;
                    {
                        this.$callback = $callback;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        String string = it.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        this.$callback.errorOccurred(string);
                    }
                }, arg_0));
            }

            private static final void setValue$lambda$0(VariableView this$0, XValueModifier.XModificationCallback $callback, Object it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                VariableView.access$setValue$p(this$0, null);
                $callback.valueModified();
            }

            private static final void setValue$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
    }

    @Nullable
    public final Value getValue() {
        return this.variable.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource() {
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            Object object = value;
            if (value == null) return true;
            String string = object.getValueString();
            object = string;
            if (string == null) return true;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"[native code]", (boolean)false, (int)2, null)) return true;
            boolean bl = true;
            if (!bl) return true;
        }
        if (!this.getViewSupport().canNavigateToSource(this.variable, this.context)) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.FunctionValue");
            ((FunctionValue)value).resolve().onSuccess(arg_0 -> VariableView.computeSourcePosition$lambda$7((Function1)new Function1<FunctionValue, Unit>(this, navigatable){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XNavigatable $navigatable;
                {
                    this.this$0 = $receiver;
                    this.$navigatable = $navigatable;
                    super(1);
                }

                public final void invoke(FunctionValue function) {
                    Vm vm = this.this$0.getVm();
                    Intrinsics.checkNotNull((Object)vm);
                    ScriptManager scriptManager = vm.getScriptManager();
                    Intrinsics.checkNotNull((Object)function);
                    scriptManager.getScript(function).onSuccess(arg_0 -> computeSourcePosition.1.invoke$lambda$0((Function1)new Function1<Script, Unit>(this.$navigatable, this.this$0, function){
                        final /* synthetic */ XNavigatable $navigatable;
                        final /* synthetic */ VariableView this$0;
                        final /* synthetic */ FunctionValue $function;
                        {
                            this.$navigatable = $navigatable;
                            this.this$0 = $receiver;
                            this.$function = $function;
                            super(1);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final void invoke(Script script) {
                            v0 = this.$navigatable;
                            v1 = script;
                            if (v1 == null) ** GOTO lbl-1000
                            var2_2 = v1;
                            var3_3 = this.this$0;
                            var4_4 = this.$function;
                            var5_6 = var2_2;
                            var7_7 = v0;
                            $i$a$-let-VariableView$computeSourcePosition$1$1$1 = false;
                            v2 = var3_3.getViewSupport().getSourceInfo(null, (Script)it, var4_4.getOpenParenLine(), var4_4.getOpenParenColumn());
                            v0 = var7_7;
                            v1 = v2;
                            if (v2 != null) {
                                var3_3 = v1;
                                var7_7 = v0;
                                $i$a$-let-VariableView$computeSourcePosition$1$1$2 = false;
                                v3 = new XSourcePositionWrapper((SourceInfo)it){

                                    @NotNull
                                    public Navigatable createNavigatable(@NotNull Project project) {
                                        Navigatable navigatable;
                                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                        Navigatable navigatable2 = (Navigatable)ReadAction.compute(() -> computeSourcePosition.2.1.createNavigatable$lambda$1(this, project));
                                        if (navigatable2 == null) {
                                            Navigatable navigatable3 = super.createNavigatable(project);
                                            navigatable = navigatable3;
                                            Intrinsics.checkNotNullExpressionValue((Object)navigatable3, (String)"createNavigatable(...)");
                                        } else {
                                            navigatable = navigatable2;
                                        }
                                        return navigatable;
                                    }

                                    private static final Navigatable createNavigatable$lambda$1$lambda$0(XSourcePosition xSourcePosition, PsiElement element, int n, Document document) {
                                        Intrinsics.checkNotNullParameter((Object)xSourcePosition, (String)"<anonymous parameter 0>");
                                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                        Intrinsics.checkNotNullParameter((Object)document, (String)"<anonymous parameter 3>");
                                        PsiElement referenceCandidate = element;
                                        PsiElement psiReference = null;
                                        while (referenceCandidate.getPrevSibling() != null) {
                                            if (!(referenceCandidate instanceof PsiReference)) continue;
                                            psiReference = referenceCandidate;
                                            break;
                                        }
                                        if (psiReference == null) {
                                            PsiElement psiElement;
                                            referenceCandidate = element.getParent();
                                            while ((psiElement = referenceCandidate) != null && (psiElement = psiElement.getPrevSibling()) != null) {
                                                referenceCandidate = psiElement;
                                                if (!(referenceCandidate instanceof PsiReference)) continue;
                                                psiReference = referenceCandidate;
                                                break;
                                            }
                                        }
                                        PsiElement psiElement = psiReference;
                                        PsiElement psiElement2 = psiElement == null ? element.getNavigationElement() : psiElement.getNavigationElement();
                                        return psiElement2 instanceof Navigatable ? (Navigatable)psiElement2 : null;
                                    }

                                    private static final Navigatable createNavigatable$lambda$1(computeSourcePosition.2.1 this$0, Project $project) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                                        return (Navigatable)PsiVisitors.visit((XSourcePosition)this$0.myPosition, (Project)$project, null, computeSourcePosition.2.1::createNavigatable$lambda$1$lambda$0);
                                    }
                                };
                                v0 = var7_7;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = null;
                            }
                            v0.setSourcePosition((XSourcePosition)v3);
                        }
                    }, arg_0));
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        } else {
            DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
            String string = this.getVariableName();
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value);
            debuggerViewSupport.computeSourcePosition(string, value, this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.getViewSupport().computeInlineDebuggerData(this.getVariableName(), this.variable, this.context, callback2);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        if (this.context.getVariableName() == null) {
            return this.variable.getName();
        }
        SmartList list = new SmartList();
        VariableContext variableContext = this.getParent();
        String string = this.variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.addVarName((SmartList<String>)list, variableContext, string);
        VariableContext parent = this.context;
        while (true) {
            VariableContext variableContext2 = parent;
            if ((variableContext2 != null ? variableContext2.getVariableName() : null) == null) break;
            VariableContext variableContext3 = parent.getParent();
            String string2 = parent.getVariableName();
            Intrinsics.checkNotNull((Object)string2);
            this.addVarName((SmartList<String>)list, variableContext3, string2);
            parent = parent.getParent();
        }
        return this.context.getViewSupport().propertyNamesToString((List)list, false);
    }

    private final void addVarName(SmartList<String> list, VariableContext parent, String name) {
        if (parent == null || parent.getVariableName() != null) {
            list.add((Object)name);
        } else {
            String[] stringArray = new String[]{"."};
            list.addAll((Collection)CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }
    }

    private static final Promise computePresentation$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final void computeChildren$lambda$2(VariableView this$0, XCompositeNode $node) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        this$0.computeChildren(0, $node);
    }

    private static final void computeChildren$lambda$3(VariableView this$0, int $remainingChildrenOffset, XCompositeNode $node) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        this$0.computeChildren($remainingChildrenOffset + 100, $node);
    }

    private static final void processNamedObjectProperties$lambda$6(VariableView this$0, XCompositeNode $node) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        this$0.computeChildren(100, $node);
    }

    private static final void computeSourcePosition$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Variable access$getVariable$p(VariableView $this) {
        return $this.variable;
    }

    public static final /* synthetic */ void access$setEvaluatedValue(VariableView $this, Value value, String error, XValueNode node) {
        $this.setEvaluatedValue(value, error, node);
    }

    public static final /* synthetic */ void access$setValue$p(VariableView $this, Value value) {
        $this.value = value;
    }

    public static final /* synthetic */ void access$computePresentation(VariableView $this, Value value, XValueNode node) {
        $this.computePresentation(value, node);
    }

    public static final /* synthetic */ VariableContext access$getContext$p(VariableView $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$set_memberFilter$p(VariableView $this, MemberFilter memberFilter) {
        $this._memberFilter = memberFilter;
    }

    public static final /* synthetic */ void access$computeArrayRanges(VariableView $this, List properties, XCompositeNode node) {
        $this.computeArrayRanges(properties, node);
    }

    public static final /* synthetic */ void access$setRemainingChildren$p(VariableView $this, List list) {
        $this.remainingChildren = list;
    }

    public static final /* synthetic */ List access$processNamedObjectProperties(VariableView $this, List variables, XCompositeNode node, VariableContext context, MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        return $this.processNamedObjectProperties(variables, node, context, memberFilter, maxChildrenToAdd, defaultIsLast);
    }

    public static final /* synthetic */ List access$getRemainingChildren$p(VariableView $this) {
        return $this.remainingChildren;
    }

    public static final /* synthetic */ Value access$getValue$p(VariableView $this) {
        return $this.value;
    }

    public static final /* synthetic */ Promise access$computeNamedProperties(VariableView $this, ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return $this.computeNamedProperties(value, node, isLastChildren);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/debugger/VariableView$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "value", "Lorg/jetbrains/debugger/values/Value;", "setArrayPresentation", "", "context", "Lorg/jetbrains/debugger/VariableContext;", "icon", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "setObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "intellij.javascript.debugger.ui"})
    @SourceDebugExtension(value={"SMAP\nVariableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView$Companion\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,566:1\n109#2,3:567\n147#2,3:570\n*S KotlinDebug\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView$Companion\n*L\n497#1:567,3\n498#1:570,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableViewKt.getObjectValueDescription(value)), value.hasProperties() != ThreeState.NO);
        }

        /*
         * WARNING - void declaration
         */
        public final void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, @NotNull Icon icon, @NotNull XValueNode node) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean bl2 = bl = value.getType() == ValueType.ARRAY;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (value instanceof ArrayValue) {
                int length = ((ArrayValue)value).getLength();
                node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value).getClassName()), length > 0);
                return;
            }
            if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
                return;
            }
            String valueString = value.getValueString();
            if (valueString != null && (StringsKt.endsWith$default((String)valueString, (String)")", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)valueString, (char)']', (boolean)false, (int)2, null)) && VariableViewKt.access$getARRAY_DESCRIPTION_PATTERN$p().matcher(valueString).find()) {
                node.setPresentation(icon, null, valueString, true);
            } else {
                void $this$onError$iv;
                Promise $this$onSuccess$iv;
                Promise promise2 = EvaluateContext.evaluate$default((EvaluateContext)context.getEvaluateContext(), (String)"a.length", Collections.singletonMap("a", value), (boolean)false, null, (int)8, null);
                boolean $i$f$onSuccess = false;
                Promise promise3 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node, node, icon){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    {
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        EvaluateResult it = (EvaluateResult)param;
                        boolean bl = false;
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, "Array[" + it.getValue().getValueString() + "]", true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onSuccess(...)");
                $this$onSuccess$iv = promise3;
                boolean $i$f$onError = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, node, icon, valueString){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    final /* synthetic */ String $valueString$inlined;
                    {
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        this.$valueString$inlined = string;
                        super($node);
                    }

                    public void accept(@NotNull Throwable param) {
                        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                        Throwable it = param;
                        boolean bl = false;
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(VariableView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Failed to evaluate array length: " + it);
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, this.$valueString$inlined != null ? this.$valueString$inlined : "Array", true);
                    }
                }), (String)"onError(...)");
            }
        }

        @NotNull
        public final Icon getIcon(@NotNull Value value) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ValueType type = value.getType();
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Icon icon2 = AllIcons.Nodes.Lambda;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lambda");
                    break;
                }
                case 2: {
                    Icon icon3 = AllIcons.Debugger.Db_array;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_array");
                    break;
                }
                default: {
                    Icon icon4 = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
                    Intrinsics.checkNotNull((Object)icon4);
                    icon = icon4;
                }
            }
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ValueType.values().length];
                try {
                    nArray[ValueType.FUNCTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.ARRAY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/debugger/VariableView$MyFullValueEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "value", "Lorg/jetbrains/debugger/values/Value;", "(Lorg/jetbrains/debugger/values/Value;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "intellij.javascript.debugger.ui"})
    private static final class MyFullValueEvaluator
    extends XFullValueEvaluator {
        @NotNull
        private final Value value;

        public MyFullValueEvaluator(@NotNull Value value) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof StringValue) {
                n = ((StringValue)value).getLength();
            } else {
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                n = string.length();
            }
            super(n);
            this.value = value;
        }

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                String string = this.value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                callback2.evaluated(string);
                return;
            }
            AtomicBoolean evaluated2 = new AtomicBoolean();
            ((StringValue)this.value).getFullString().onSuccess(arg_0 -> MyFullValueEvaluator.startEvaluation$lambda$0((Function1)new Function1<String, Unit>(callback2, evaluated2, this){
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;
                final /* synthetic */ AtomicBoolean $evaluated;
                final /* synthetic */ MyFullValueEvaluator this$0;
                {
                    this.$callback = $callback;
                    this.$evaluated = $evaluated;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(String it) {
                    if (!this.$callback.isObsolete() && this.$evaluated.compareAndSet(false, true)) {
                        String string = MyFullValueEvaluator.access$getValue$p(this.this$0).getValueString();
                        Intrinsics.checkNotNull((Object)string);
                        this.$callback.evaluated(string);
                    }
                }
            }, arg_0)).onError(arg_0 -> MyFullValueEvaluator.startEvaluation$lambda$1((Function1)new Function1<Throwable, Unit>(callback2){
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;
                {
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    String string = it.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    this.$callback.errorOccurred(string);
                }
            }, arg_0));
        }

        private static final void startEvaluation$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void startEvaluation$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ Value access$getValue$p(MyFullValueEvaluator $this) {
            return $this.value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer;", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "isObsolete", "", "()Z", "getNode", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.javascript.debugger.ui"})
    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        @NotNull
        private final XCompositeNode node;

        public ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }

        @NotNull
        protected final XCompositeNode getNode() {
            return this.node;
        }

        public boolean isObsolete() {
            return this.node.isObsolete();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.FUNCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.ARRAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.UNDEFINED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BIGINT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.STRING.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

