/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.visualizer.EditorListItem;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapVisualizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001CB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J \u0010+\u001a\u00020'2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J\u0010\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010*J\u0010\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0005H\u0002J\u0010\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020!H\u0002J\u0010\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020!H\u0002J\b\u0010?\u001a\u00020'H\u0002J\u0018\u0010@\u001a\u00020'2\u0006\u0010A\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010B\u001a\u00020'H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "sourceFileFinder", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "currentHighlighters", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editorListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/EditorListItem;", "generatedEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getGeneratedEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "generatedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getGeneratedTextEditor$intellij_javascript_debugger", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setGeneratedTextEditor$intellij_javascript_debugger", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "positionToSelect", "Lcom/intellij/openapi/editor/LogicalPosition;", "positionToSelectIsSource", "", "rightPanel", "Ljavax/swing/JPanel;", "addMarkersIfNeeded", "", "sourceEditor", "url", "Lcom/intellij/util/Url;", "addSelectedHighlighter", "editor", "Lcom/intellij/openapi/editor/Editor;", "mapping", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "markupModel", "startOffset", "", "endOffset", "createMainComponent", "Ljavax/swing/JComponent;", "selectedSourceUrl", "createSourceEditor", "virtualFile", "highlightGenerated", "sourcePosition", "highlightSource", "generatedPosition", "removeHighlighters", "scheduleHighlight", "position", "updateMarkers", "SourceFileFinderImpl", "intellij.javascript.debugger"})
public final class SourceMapInspector {
    @NotNull
    private final SourceMap map;
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private TextEditor generatedTextEditor;
    @NotNull
    private final EditorEx generatedEditor;
    @Nullable
    private JPanel rightPanel;
    @NotNull
    private final SingleAlarm alarm;
    @Nullable
    private LogicalPosition positionToSelect;
    private boolean positionToSelectIsSource;
    @Nullable
    private CollectionComboBoxModel<EditorListItem> editorListModel;
    @NotNull
    private final MultiMap<MarkupModel, RangeHighlighter> currentHighlighters;
    @NotNull
    private final SourceFileFinder sourceFileFinder;

    public SourceMapInspector(@NotNull SourceMap map, @NotNull VirtualFile generatedFile, @NotNull Project project, @NotNull Disposable disposable, @Nullable SourceFileFinder sourceFileFinder) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)generatedFile, (String)"generatedFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.map = map;
        this.project = project;
        this.disposable = disposable;
        FileEditor fileEditor = TextEditorProvider.Companion.getInstance().createEditor(this.project, generatedFile);
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        this.generatedTextEditor = (TextEditor)fileEditor;
        Editor editor = this.generatedTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.generatedEditor = (EditorEx)editor;
        this.currentHighlighters = new MultiMap();
        SourceFileFinder sourceFileFinder2 = sourceFileFinder;
        if (sourceFileFinder2 == null) {
            sourceFileFinder2 = new SourceFileFinderImpl();
        }
        this.sourceFileFinder = sourceFileFinder2;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)this.generatedTextEditor));
        SourceMapInspectorKt.access$setupEditor(this.generatedEditor);
        this.generatedEditor.setHeaderComponent((JComponent)new JLabel("0:0", 4));
        SourceMapVisualizer.addMarkersToGeneratedFile(this.map, (MarkupModel)this.generatedEditor.getMarkupModel());
        this.alarm = new SingleAlarm(() -> SourceMapInspector._init_$lambda$0(this), 100, this.disposable, null, null, 24, null);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this.disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> SourceMapInspector._init_$lambda$1(this, arg_0));
        this.generatedEditor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getMouseEvent().isShiftDown()) {
                    LogicalPosition logicalPosition = event.getEditor().xyToLogicalPosition(event.getMouseEvent().getPoint());
                    Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                    this.scheduleHighlight(logicalPosition, false);
                }
            }
        });
        this.generatedEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                this.scheduleHighlight(logicalPosition, false);
            }
        });
    }

    @NotNull
    public final TextEditor getGeneratedTextEditor$intellij_javascript_debugger() {
        return this.generatedTextEditor;
    }

    public final void setGeneratedTextEditor$intellij_javascript_debugger(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"<set-?>");
        this.generatedTextEditor = textEditor;
    }

    @NotNull
    public final EditorEx getGeneratedEditor() {
        return this.generatedEditor;
    }

    private final void updateMarkers() {
        MarkupModelEx markupModelEx = this.generatedEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx generatedEditorMarkup = markupModelEx;
        generatedEditorMarkup.removeAllHighlighters();
        SourceMapVisualizer.addMarkersToGeneratedFile(this.map, (MarkupModel)generatedEditorMarkup);
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Object object = collectionComboBoxModel != null ? collectionComboBoxModel.getSelectedItem() : null;
        EditorListItem editorListItem = object instanceof EditorListItem ? (EditorListItem)object : null;
        if (editorListItem == null) {
            return;
        }
        EditorListItem sourceEditorModel = editorListItem;
        EditorEx editorEx = sourceEditorModel.getEditor();
        if (editorEx == null) {
            return;
        }
        EditorEx sourceEditor = editorEx;
        MarkupModelEx markupModelEx2 = sourceEditor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx2, (String)"getMarkupModel(...)");
        MarkupModelEx sourceMarkup = markupModelEx2;
        Url sourceUrl = this.map.getSources()[sourceEditorModel.getSourceIndex()];
        sourceMarkup.removeAllHighlighters();
        SourceMapVisualizer.addMarkersToSourceFile(this.map, (MarkupModel)sourceMarkup, sourceUrl);
    }

    private final void scheduleHighlight(LogicalPosition position, boolean positionToSelectIsSource) {
        this.positionToSelect = position;
        this.positionToSelectIsSource = positionToSelectIsSource;
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
    }

    @NotNull
    public final JComponent createMainComponent(@Nullable Url selectedSourceUrl) {
        List editors = new ArrayList();
        Url[] sources = this.map.getSources();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        int selectedIndex = -1;
        int n = sources.length;
        for (int i = 0; i < n; ++i) {
            Url url = sources[i];
            VirtualFile file2 = this.sourceFileFinder.find(url);
            Font font = null;
            if (file2 == null) {
                Font font2 = UIUtil.getListFont().deriveFont(2);
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"deriveFont(...)");
                font = font2;
            } else if (!fileIndex.isInContent(file2) || fileIndex.isInLibrary(file2)) {
                Font font3 = UIUtil.getListFont();
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"getListFont(...)");
                font = font3;
            } else {
                Font font4 = UIUtil.getListFont().deriveFont(1);
                Intrinsics.checkNotNullExpressionValue((Object)font4, (String)"deriveFont(...)");
                font = font4;
            }
            Collection collection = editors;
            VirtualFile virtualFile = file2;
            String string = virtualFile == null ? url.toDecodedForm() : SourceMapInspectorKt.getFileTitle(virtualFile);
            Intrinsics.checkNotNull((Object)string);
            collection.add(new EditorListItem(i, file2, font, string));
            if (selectedIndex != -1 || selectedSourceUrl == null || !Intrinsics.areEqual((Object)selectedSourceUrl, (Object)url)) continue;
            selectedIndex = i;
        }
        this.editorListModel = new CollectionComboBoxModel(editors);
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        ComboBox comboBox = new ComboBox((ComboBoxModel)collectionComboBoxModel, 100);
        ComboboxSpeedSearch search2 = new ComboboxSpeedSearch((ComboBox<EditorListItem>)comboBox){

            @NotNull
            protected String getElementText(@NotNull Object element) {
                String string;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                EditorListItem item = (EditorListItem)element;
                if (item.getFile() == null) {
                    string = item.getName();
                } else {
                    String string2 = item.getFile().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                }
                return string;
            }
        };
        search2.setupListeners();
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> SourceMapInspector.createMainComponent$lambda$2(createMainComponent.1.INSTANCE, arg_0, arg_1, arg_2)));
        comboBox.addItemListener(arg_0 -> SourceMapInspector.createMainComponent$lambda$3(this, arg_0));
        JPanel jPanel = this.rightPanel = new JPanel(new BorderLayout());
        Intrinsics.checkNotNull((Object)jPanel);
        jPanel.add((Component)comboBox, "First");
        comboBox.setSelectedIndex(selectedIndex);
        JBSplitter splitter = new JBSplitter();
        splitter.setSplitterProportionKey("SourceMapInspector.splitter");
        splitter.setFirstComponent(this.generatedEditor.getComponent());
        splitter.setSecondComponent((JComponent)this.rightPanel);
        this.generatedEditor.getComponent().addAncestorListener((AncestorListener)new AncestorListenerAdapter(this){
            final /* synthetic */ SourceMapInspector this$0;
            {
                this.this$0 = $receiver;
            }

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getGeneratedEditor().getComponent().removeAncestorListener((AncestorListener)((Object)this));
                if (SourceMapInspector.access$getPositionToSelect$p(this.this$0) == null) {
                    return;
                }
                LogicalPosition logicalPosition = SourceMapInspector.access$getPositionToSelect$p(this.this$0);
                Intrinsics.checkNotNull((Object)logicalPosition);
                SourceMapInspector.access$highlightGenerated(this.this$0, logicalPosition);
                SourceMapInspector.access$setPositionToSelect$p(this.this$0, null);
                SourceMapInspector.access$setPositionToSelectIsSource$p(this.this$0, false);
            }
        });
        return (JComponent)splitter;
    }

    private final EditorEx createSourceEditor(VirtualFile virtualFile) {
        FileEditor fileEditor = TextEditorProvider.Companion.getInstance().createEditor(this.project, virtualFile);
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx sourceEditor = (EditorEx)editor;
        SourceMapInspectorKt.access$setupEditor(sourceEditor);
        sourceEditor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ SourceMapInspector this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                SourceMapInspector.access$scheduleHighlight(this.this$0, logicalPosition, true);
            }
        });
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)textEditor));
        return sourceEditor;
    }

    private final void highlightGenerated(LogicalPosition sourcePosition2) {
        EditorListItem item;
        this.removeHighlighters();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        EditorListItem editorListItem = item = (EditorListItem)collectionComboBoxModel.getSelected();
        Intrinsics.checkNotNull((Object)editorListItem);
        Mappings mappings = this.map.findSourceMappings(editorListItem.getSourceIndex());
        Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        MappingList mappingsOrderedBySource = (MappingList)mappings;
        int mappingIndex = mappingsOrderedBySource.indexOf(sourcePosition2.line, sourcePosition2.column);
        if (mappingIndex == -1) {
            return;
        }
        MappingEntry mappingEntry = mappingsOrderedBySource.get(sourcePosition2.line, sourcePosition2.column);
        Intrinsics.checkNotNull((Object)mappingEntry);
        MappingEntry mapping = mappingEntry;
        EditorEx editorEx = item.getEditor();
        Intrinsics.checkNotNull((Object)editorEx);
        this.addSelectedHighlighter((Editor)editorEx, mapping, mappingsOrderedBySource);
        MappingEntry nextMapping = Mappings.getNextOnTheSameLine$default((Mappings)((Mappings)mappingsOrderedBySource), (int)mappingIndex, (boolean)false, (int)2, null);
        mappingsOrderedBySource.processMappingsInLine(mapping.getSourceLine(), new MappingsProcessorInLine(mapping, this, nextMapping){
            final /* synthetic */ MappingEntry $mapping;
            final /* synthetic */ SourceMapInspector this$0;
            final /* synthetic */ MappingEntry $nextMapping;
            {
                this.$mapping = $mapping;
                this.this$0 = $receiver;
                this.$nextMapping = $nextMapping;
            }

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                if (entry.getSourceColumn() >= this.$mapping.getSourceColumn()) {
                    Editor editor = (Editor)this.this$0.getGeneratedEditor();
                    Mappings mappings = SourceMapInspector.access$getMap$p(this.this$0).getGeneratedMappings();
                    Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                    SourceMapInspector.access$addSelectedHighlighter(this.this$0, editor, entry, (MappingList)mappings);
                }
                return nextEntry != null && nextEntry != this.$nextMapping;
            }
        });
        this.generatedEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getGeneratedLine(), mapping.getGeneratedColumn()), ScrollType.CENTER);
    }

    private final void removeHighlighters() {
        if (this.currentHighlighters.isEmpty()) {
            return;
        }
        for (MarkupModel markupModel : this.currentHighlighters.keySet()) {
            for (RangeHighlighter rangeHighlighter : this.currentHighlighters.get((Object)markupModel)) {
                if (!rangeHighlighter.isValid()) continue;
                markupModel.removeHighlighter(rangeHighlighter);
            }
        }
        this.currentHighlighters.clear();
    }

    private final void addSelectedHighlighter(Editor editor, MappingEntry mapping, MappingList mappings) {
        int lineStartOffset = editor.getDocument().getLineStartOffset(mappings.getLine(mapping));
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        int n = lineStartOffset + mappings.getColumn(mapping);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.addSelectedHighlighter(markupModel, n, mappings.getEndOffset(mapping, lineStartOffset, document));
    }

    private final void addSelectedHighlighter(MarkupModel markupModel, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return;
        }
        if (endOffset < startOffset) {
            throw new IllegalStateException();
        }
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 6100, SourceMapVisualizer.SELECTED_MARKER, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        this.currentHighlighters.putValue((Object)markupModel, (Object)highlighter);
    }

    private final void highlightSource(LogicalPosition generatedPosition) {
        Object object;
        this.removeHighlighters();
        MappingEntry mapping = this.map.getGeneratedMappings().get(generatedPosition.line, generatedPosition.column);
        JComponent headerComponent = this.generatedEditor.getHeaderComponent();
        JLabel component = null;
        if (headerComponent instanceof JLabel) {
            component = (JLabel)headerComponent;
        } else if (headerComponent != null) {
            JPanel compoundComponent = new JPanel(new BorderLayout());
            compoundComponent.add((Component)headerComponent, "First");
            component = new JLabel("0:0", 4);
            compoundComponent.add((Component)component, "Last");
            this.generatedEditor.setHeaderComponent((JComponent)compoundComponent);
        } else {
            component = new JLabel("0:0", 4);
            this.generatedEditor.setHeaderComponent((JComponent)component);
        }
        if (mapping == null || mapping.getSource() == -1) {
            component.setText(JSDebuggerBundle.message("js.scripts.visualize.unmapped", new Object[0]));
            return;
        }
        int n = mapping.getSourceLine();
        int n2 = mapping.getSourceColumn();
        if (mapping.getName() == null) {
            object = "";
        } else {
            String string = mapping.getName();
            Intrinsics.checkNotNull((Object)string);
            object = " " + string;
        }
        component.setText(n + ":" + n2 + (String)object + " (" + mapping.getGeneratedLine() + ":" + mapping.getGeneratedColumn() + ")");
        int sourceIndex = mapping.getSource();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        EditorListItem listItem = (EditorListItem)collectionComboBoxModel.getElementAt(sourceIndex);
        VirtualFile virtualFile = listItem.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile;
        EditorEx sourceEditor = listItem.getEditor();
        if (sourceEditor == null) {
            sourceEditor = this.createSourceEditor(sourceFile);
            listItem.setEditor(sourceEditor);
            JPanel jPanel = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel);
            jPanel.add(sourceEditor.getComponent(), "Center", 1);
            JPanel jPanel2 = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel2);
            jPanel2.revalidate();
            JPanel jPanel3 = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel3);
            jPanel3.repaint();
        }
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel2 = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel2);
        collectionComboBoxModel2.setSelectedItem((Object)listItem);
        Editor editor = (Editor)sourceEditor;
        Mappings mappings = this.map.findSourceMappings(sourceIndex);
        Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        this.addSelectedHighlighter(editor, mapping, (MappingList)mappings);
        Editor editor2 = (Editor)this.generatedEditor;
        Mappings mappings2 = this.map.getGeneratedMappings();
        Intrinsics.checkNotNull((Object)mappings2, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        this.addSelectedHighlighter(editor2, mapping, (MappingList)mappings2);
        sourceEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getSourceLine(), mapping.getSourceColumn()), ScrollType.MAKE_VISIBLE);
        this.addMarkersIfNeeded(sourceEditor, this.map, this.map.getSources()[sourceIndex]);
    }

    private final void addMarkersIfNeeded(EditorEx sourceEditor, SourceMap map, Url url) {
        if (!Intrinsics.areEqual((Object)SourceMapInspectorKt.access$getEDITOR_MARKED$p().get((UserDataHolder)sourceEditor), (Object)true)) {
            SourceMapInspectorKt.access$getEDITOR_MARKED$p().set((UserDataHolder)sourceEditor, (Object)true);
            SourceMapVisualizer.addMarkersToSourceFile(map, (MarkupModel)sourceEditor.getMarkupModel(), url);
        }
    }

    private static final void _init_$lambda$0(SourceMapInspector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LogicalPosition p = this$0.positionToSelect;
        if (p != null) {
            this$0.positionToSelect = null;
            if (this$0.positionToSelectIsSource) {
                this$0.highlightGenerated(p);
            } else {
                this$0.highlightSource(p);
            }
        }
    }

    private static final void _init_$lambda$1(SourceMapInspector this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateMarkers();
    }

    private static final void createMainComponent$lambda$2(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final void createMainComponent$lambda$3(SourceMapInspector this$0, ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (e.getStateChange() != 1) {
            return;
        }
        Object object = e.getItem();
        EditorListItem editorListItem = object instanceof EditorListItem ? (EditorListItem)object : null;
        if (editorListItem == null) {
            return;
        }
        EditorListItem selectedItem = editorListItem;
        JPanel jPanel = this$0.rightPanel;
        Intrinsics.checkNotNull((Object)jPanel);
        if (jPanel.getComponentCount() > 1) {
            JPanel jPanel2 = this$0.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel2);
            jPanel2.remove(1);
        }
        if (selectedItem.getEditor() == null && selectedItem.getFile() != null) {
            selectedItem.setEditor(this$0.createSourceEditor(selectedItem.getFile()));
        }
        if (selectedItem.getEditor() != null) {
            EditorEx editorEx = selectedItem.getEditor();
            Intrinsics.checkNotNull((Object)editorEx);
            EditorEx editor = editorEx;
            JPanel jPanel3 = this$0.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel3);
            jPanel3.add(editor.getComponent(), "Center", 1);
            this$0.addMarkersIfNeeded(editor, this$0.map, this$0.map.getSources()[selectedItem.getSourceIndex()]);
        }
        LogicalPosition sourcePosition2 = null;
        if (selectedItem.getFile() == null) {
            sourcePosition2 = new LogicalPosition(0, 0);
        } else {
            JavaScriptDebugAware debugAware;
            PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile(selectedItem.getFile());
            Intrinsics.checkNotNull((Object)psiFile);
            PsiFile file2 = psiFile;
            PsiElement navigationElement = null;
            JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions();
            int n = javaScriptDebugAwareArray.length;
            for (int i = 0; i < n && (navigationElement = (debugAware = javaScriptDebugAwareArray[i]).getNavigationElementForSourcemapInspector(file2)) == null; ++i) {
            }
            if (navigationElement == null) {
                navigationElement = file2.getNavigationElement();
            }
            PsiElement psiElement = navigationElement;
            Intrinsics.checkNotNull((Object)psiElement);
            int offset = psiElement.getTextOffset();
            EditorEx editorEx = selectedItem.getEditor();
            Intrinsics.checkNotNull((Object)editorEx);
            DocumentEx documentEx = editorEx.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            int line = document.getLineNumber(offset);
            sourcePosition2 = new LogicalPosition(line, offset - document.getLineStartOffset(line));
        }
        JPanel jPanel4 = this$0.rightPanel;
        Intrinsics.checkNotNull((Object)jPanel4);
        if (jPanel4.getParent() != null) {
            JPanel jPanel5 = this$0.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel5);
            jPanel5.revalidate();
            JPanel jPanel6 = this$0.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel6);
            jPanel6.repaint();
            this$0.highlightGenerated(sourcePosition2);
        } else {
            this$0.positionToSelect = sourcePosition2;
            this$0.positionToSelectIsSource = true;
        }
    }

    public static final /* synthetic */ LogicalPosition access$getPositionToSelect$p(SourceMapInspector $this) {
        return $this.positionToSelect;
    }

    public static final /* synthetic */ void access$highlightGenerated(SourceMapInspector $this, LogicalPosition sourcePosition2) {
        $this.highlightGenerated(sourcePosition2);
    }

    public static final /* synthetic */ void access$setPositionToSelect$p(SourceMapInspector $this, LogicalPosition logicalPosition) {
        $this.positionToSelect = logicalPosition;
    }

    public static final /* synthetic */ void access$setPositionToSelectIsSource$p(SourceMapInspector $this, boolean bl) {
        $this.positionToSelectIsSource = bl;
    }

    public static final /* synthetic */ void access$addSelectedHighlighter(SourceMapInspector $this, Editor editor, MappingEntry mapping, MappingList mappings) {
        $this.addSelectedHighlighter(editor, mapping, mappings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector$SourceFileFinderImpl;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;)V", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderBase;", "find", "Lcom/intellij/openapi/vfs/VirtualFile;", "source", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
    public final class SourceFileFinderImpl
    implements SourceFileFinder {
        @NotNull
        private final UserDataHolderBase userDataHolder = new UserDataHolderBase();

        @Override
        @Nullable
        public VirtualFile find(@NotNull Url source) {
            VirtualFile file2;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            VirtualFile virtualFile = SourceMapInspectorKt.createSourceFromProvidedContent(SourceMapInspector.this.map, source, (UserDataHolder)this.userDataHolder);
            if (virtualFile == null) {
                virtualFile = SourceMapInspectorKt.getSourceFile(source);
            }
            if ((file2 = virtualFile) == null) {
                for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)SourceMapInspector.this.project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                    WebBrowser webBrowser;
                    WebBrowser webBrowser2 = webBrowser = debugProcess.getSession().isStopped() ? null : debugProcess.getConnection().getBrowser();
                    if (BrowserFamily.CHROME != (webBrowser2 != null ? webBrowser2.getFamily() : null)) continue;
                    return debugProcess.findFileOrAny(source);
                }
            }
            return file2;
        }
    }
}

