/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebugUtilsKt;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.nodejs.NodeDebugConnector;
import com.intellij.javascript.debugger.scripts.RootsDirectoryInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfo;
import com.intellij.javascript.debugger.scripts.SourcesTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseKt;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0017\u001a\u00020\u000e2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "root", "Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "getRoot", "()Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "updateScriptsAlarm", "Lcom/intellij/util/SingleAlarm;", "addScript", "", "script", "Lorg/jetbrains/debugger/Script;", "clear", "doAddScript", "url", "Lcom/intellij/util/Url;", "doRemoveScript", "removeScript", "setTreeModel", "treeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "treeStructure", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeStructure;", "suggestRootNode", "intellij.javascript.debugger"})
public final class SourceTabManager {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ScriptDirectoryInfo root;
    @Nullable
    private volatile SingleAlarm updateScriptsAlarm;

    public SourceTabManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.root = new ScriptDirectoryInfo("<root>", Urls.newUnparsable((String)""), null, 4, null);
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final ScriptDirectoryInfo getRoot() {
        return this.root;
    }

    public final void addScript(@NotNull Script script) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            if (NodeDebugConnector.INSTANCE.isDebugConnectorFile(script.getUrl())) {
                return;
            }
            if (script.getSourceMap() == null) {
                this.doAddScript(script, script.getUrl());
            } else {
                SourceMap sourceMap = script.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                for (Url source : sourceMap.getSources()) {
                    this.doAddScript(script, source);
                }
            }
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block4;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    private final void doAddScript(Script script, Url url) {
        this.suggestRootNode(script, url).addChild(script, url);
    }

    private final ScriptDirectoryInfo suggestRootNode(Script script, Url url) {
        ScriptDirectoryInfo child;
        String rootName = null;
        Icon icon = PlatformIcons.FOLDER_ICON;
        int weight = 5;
        if (url.getScheme() == null && !url.isInLocalFileSystem()) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.no", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
        } else if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.evaluated", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
            --weight;
        } else if (!JavaScriptDebugProcessKt.hasWebpackScheme(url) && ScriptManagerBaseKt.isSpecial((Url)url)) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.lib", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
            icon = PlatformIcons.LIBRARY_ICON;
            ++weight;
        } else {
            return this.root;
        }
        Object object = this.root.getChildNameToInfo().get(rootName);
        ScriptDirectoryInfo scriptDirectoryInfo = child = object instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)object : null;
        if (child == null) {
            Url url2 = Urls.newUnparsable((String)rootName);
            object = icon;
            Intrinsics.checkNotNull((Object)object);
            child = new RootsDirectoryInfo(rootName, url2, (Icon)object, this.debugProcess, weight);
            this.root.getChildNameToInfo().put(rootName, child);
        }
        return child;
    }

    public final void removeScript(@NotNull Script script) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            if (JSDebugUtilsKt.isEvaluatedOneLineScript(script)) {
                return;
            }
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap != null) {
                SourceMap it = sourceMap;
                boolean bl = false;
                for (Url source : it.getSources()) {
                    this.doRemoveScript(script, source);
                }
            }
            this.doRemoveScript(script, script.getUrl());
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block3;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    private final void doRemoveScript(Script script, Url url) {
        ScriptDirectoryInfo directory = this.suggestRootNode(script, url);
        directory.removeChild(url);
        if (directory != this.root && !directory.hasChildren()) {
            this.root.getChildNameToInfo().remove(directory.getName());
        }
    }

    public final void setTreeModel(@NotNull StructureTreeModel<?> treeModel, @NotNull SourcesTreeStructure treeStructure) {
        block0: {
            Intrinsics.checkNotNullParameter(treeModel, (String)"treeModel");
            Intrinsics.checkNotNullParameter((Object)((Object)treeStructure), (String)"treeStructure");
            SingleAlarm singleAlarm = this.updateScriptsAlarm = SingleAlarm.Companion.pooledThreadSingleAlarm(500, (Disposable)treeModel, (Function0)new Function0<Unit>(treeStructure, treeModel){
                final /* synthetic */ SourcesTreeStructure $treeStructure;
                final /* synthetic */ StructureTreeModel<?> $treeModel;
                {
                    this.$treeStructure = $treeStructure;
                    this.$treeModel = $treeModel;
                    super(0);
                }

                public final void invoke() {
                    this.$treeStructure.clearCaches();
                    this.$treeModel.invalidateAsync();
                }
            });
            if (singleAlarm == null) break block0;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    public final void clear() {
        block0: {
            this.root.getChildNameToInfo().clear();
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block0;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }
}

