/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanelKt;
import com.intellij.javascript.debugger.execution.JSRemoteUrlMappingModel;
import com.intellij.javascript.debugger.execution.JSRemoteUrlMappingTableFactory;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ&\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingTableFactory;", "", "model", "Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;", "table", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "baseUrlGetter", "Lkotlin/Function0;", "", "(Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;Lcom/intellij/ui/table/JBTable;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "chooseFile", "", "toSelect", "Lcom/intellij/openapi/vfs/VirtualFile;", "handler", "Lkotlin/Function1;", "createPanel", "Ljavax/swing/JPanel;", "doAddAction", "doEditAction", "doRemoveAction", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJSLocalFilesMappingPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLocalFilesMappingPanel.kt\ncom/intellij/javascript/debugger/execution/JSRemoteUrlMappingTableFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
final class JSRemoteUrlMappingTableFactory {
    @NotNull
    private final JSRemoteUrlMappingModel model;
    @NotNull
    private final JBTable table;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<String> baseUrlGetter;

    public JSRemoteUrlMappingTableFactory(@NotNull JSRemoteUrlMappingModel model, @NotNull JBTable table, @NotNull Project project, @NotNull Function0<String> baseUrlGetter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(baseUrlGetter, (String)"baseUrlGetter");
        this.model = model;
        this.table = table;
        this.project = project;
        this.baseUrlGetter = baseUrlGetter;
    }

    @NotNull
    public final JPanel createPanel() {
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(this){
            final /* synthetic */ JSRemoteUrlMappingTableFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void acquireState(@NotNull JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                File file2 = new File((String)value);
                this.setIcon(file2.isDirectory() ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type);
                String parentPath = file2.getParent();
                if (parentPath != null) {
                    Object object;
                    String projectPath = JSRemoteUrlMappingTableFactory.access$getProject$p(this.this$0).getBasePath();
                    if (projectPath != null && StringsKt.startsWith$default((String)parentPath, (String)projectPath, (boolean)false, (int)2, null)) {
                        String string = parentPath.substring(projectPath.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        object = "..." + string;
                    } else {
                        object = parentPath;
                    }
                    String relativePath = object;
                    String string = FileUtil.toSystemDependentName((String)(relativePath + "/"));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
                    String presentablePath = string;
                    this.append(presentablePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                this.append(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).disableUpAction().disableDownAction().setAddAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$1(this, arg_0)).setEditAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$2(this, arg_0)).setEditActionUpdater(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$3(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void doAddAction() {
        VirtualFile virtualFile;
        String selectedTarget;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int row = this.table.getSelectedRow();
        String string = selectedTarget = row >= 0 ? this.model.getData().get((int)this.table.convertRowIndexToModel((int)row)).localFilePath : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        VirtualFile toSelect = virtualFile;
        this.chooseFile(toSelect, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
            final /* synthetic */ JSRemoteUrlMappingTableFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String baseUrl = (String)JSRemoteUrlMappingTableFactory.access$getBaseUrlGetter$p(this.this$0).invoke();
                MatchResult matchResult = JSLocalFilesMappingPanelKt.access$getURL_WITH_FILE_PATTERN$p().matchEntire((CharSequence)baseUrl);
                if (matchResult != null) {
                    baseUrl = (String)matchResult.getGroupValues().get(1);
                }
                JSRemoteUrlMappingTableFactory.access$getModel$p(this.this$0).getData().add(new RemoteUrlMappingBean(it.getPath(), baseUrl));
                JSRemoteUrlMappingTableFactory.access$getModel$p(this.this$0).fireTableDataChanged();
                ApplicationManager.getApplication().invokeLater(() -> doAddAction.1.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(JSRemoteUrlMappingTableFactory this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                JSRemoteUrlMappingTableFactory.access$getTable$p(this$0).editCellAt(JSRemoteUrlMappingTableFactory.access$getModel$p(this$0).getData().size() - 1, 1);
            }
        }));
    }

    private final void chooseFile(VirtualFile toSelect, Function1<? super VirtualFile, Unit> handler) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, true, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.project, (Component)((Component)this.table), (VirtualFile)toSelect, arg_0 -> JSRemoteUrlMappingTableFactory.chooseFile$lambda$5(handler, arg_0));
    }

    private final void doRemoveAction() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int[] nArray = this.table.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        Iterator iterator = ArraysKt.sortedDescending((int[])nArray).iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            this.model.getData().remove(i);
        }
        this.model.fireTableDataChanged();
    }

    private final void doEditAction() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int selectedRow = this.table.getSelectedRow();
        VirtualFile selectedFile = LocalFileSystem.getInstance().findFileByPath(this.model.getData().get((int)selectedRow).localFilePath);
        this.chooseFile(selectedFile, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this, selectedRow){
            final /* synthetic */ JSRemoteUrlMappingTableFactory this$0;
            final /* synthetic */ int $selectedRow;
            {
                this.this$0 = $receiver;
                this.$selectedRow = $selectedRow;
                super(1);
            }

            public final void invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JSRemoteUrlMappingTableFactory.access$getModel$p(this.this$0).getData().set(this.$selectedRow, new RemoteUrlMappingBean(it.getPath(), JSRemoteUrlMappingTableFactory.access$getModel$p(this.this$0).getData().get(this.$selectedRow).getRemoteUrl()));
                JSRemoteUrlMappingTableFactory.access$getModel$p(this.this$0).fireTableDataChanged();
            }
        }));
    }

    private static final void createPanel$lambda$0(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doAddAction();
    }

    private static final void createPanel$lambda$1(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doRemoveAction();
    }

    private static final void createPanel$lambda$2(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doEditAction();
    }

    private static final boolean createPanel$lambda$3(JSRemoteUrlMappingTableFactory this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getSelectedRowCount() > 0;
    }

    private static final void chooseFile$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(JSRemoteUrlMappingTableFactory $this) {
        return $this.project;
    }

    public static final /* synthetic */ Function0 access$getBaseUrlGetter$p(JSRemoteUrlMappingTableFactory $this) {
        return $this.baseUrlGetter;
    }

    public static final /* synthetic */ JSRemoteUrlMappingModel access$getModel$p(JSRemoteUrlMappingTableFactory $this) {
        return $this.model;
    }

    public static final /* synthetic */ JBTable access$getTable$p(JSRemoteUrlMappingTableFactory $this) {
        return $this.table;
    }
}

