/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageAnnotator;", "Lcom/intellij/coverage/SimpleCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getDirCoverageInformationString", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentSuite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "manager", "Lcom/intellij/coverage/CoverageDataManager;", "getFilesCoverageInformationString", "info", "Lcom/intellij/coverage/BaseCoverageAnnotator$DirCoverageInfo;", "getLinesCoverageInformationString", "Lcom/intellij/coverage/BaseCoverageAnnotator$FileCoverageInfo;", "shouldCollectCoverageInsideLibraryDirs", "", "Companion", "intellij.javascript.debugger"})
public final class WipCoverageAnnotator
extends SimpleCoverageAnnotator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WipCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return false;
    }

    @Nullable
    public String getDirCoverageInformationString(@NotNull Project project, @NotNull VirtualFile directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)currentSuite, (String)"currentSuite");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = this.getDirCoverageInfo(directory, currentSuite);
        if (dirCoverageInfo == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo = dirCoverageInfo;
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? JSDebuggerBundle.message("js.coverage.lines.covered", new Object[0]) : null;
        }
        String filesCoverageInfo = this.getFilesCoverageInformationString(coverageInfo);
        if (filesCoverageInfo != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(filesCoverageInfo);
            String linesCoverageInfo = this.getLinesCoverageInformationString((BaseCoverageAnnotator.FileCoverageInfo)coverageInfo);
            if (linesCoverageInfo != null) {
                builder.append(": ").append(linesCoverageInfo);
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String result = string;
            return result;
        }
        return null;
    }

    @Nullable
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        String string;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info.totalLineCount == 0) {
            string = null;
        } else if (info.coveredLineCount == 0) {
            string = JSDebuggerBundle.message("js.coverage.lines.not.covered", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{SimpleCoverageAnnotator.calcCoveragePercentage((BaseCoverageAnnotator.FileCoverageInfo)info)};
            string = JSDebuggerBundle.message("js.coverage.lines.covered.percent", objectArray);
        }
        return string;
    }

    @Nullable
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        String string;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info.totalFilesCount == 0) {
            string = null;
        } else {
            Object[] objectArray = new Object[]{info.totalFilesCount};
            string = JSDebuggerBundle.message("js.coverage.files.covered", objectArray);
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageAnnotator$Companion;", "", "()V", "getInstance", "Lcom/intellij/javascript/debugger/coverage/WipCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
    @SourceDebugExtension(value={"SMAP\nWipCoverageAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipCoverageAnnotator.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageAnnotator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,60:1\n31#2,2:61\n*S KotlinDebug\n*F\n+ 1 WipCoverageAnnotator.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageAnnotator$Companion\n*L\n57#1:61,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WipCoverageAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WipCoverageAnnotator> serviceClass$iv = WipCoverageAnnotator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WipCoverageAnnotator)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

