/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.MemberFilterVisitor;
import com.intellij.javascript.debugger.NavigatableVariable;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J>\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0)H\u0014J$\u0010*\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020-H\u0016J&\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020-H\u0002J2\u0010/\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002070\n2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0011J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010!2\u0006\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J,\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010!2\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\u001c\u0010<\u001a\u0004\u0018\u00010=2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u00104\u001a\u00020,H\u0016J\u001a\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020=2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010H\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010I\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010J\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010K\u001a\u0004\u0018\u00010!H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006L"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/debugger/Scope;", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "canNavigateToSource", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeReceiverVariable", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeReceiverVariableUsingEvaluate", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createFrameEvaluator", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "tryToResolveByUrl", "getMemberFilter", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "functionName", "scriptUrl", "line", "", "column", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "isInLibraryContent", "sourceInfo", "isMemberVisible", "rawNameToSource", "transformErrorOnGetUsedReferenceValue", "error", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJavaScriptDebuggerViewSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebuggerViewSupport.kt\ncom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1#2:364\n1#2:381\n109#3,3:365\n766#4:368\n857#4,2:369\n1603#4,9:371\n1855#4:380\n1856#4:382\n1612#4:383\n*S KotlinDebug\n*F\n+ 1 JavaScriptDebuggerViewSupport.kt\ncom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport\n*L\n128#1:381\n203#1:365,3\n127#1:368\n127#1:369,2\n128#1:371,9\n128#1:380\n128#1:382\n128#1:383\n*E\n"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ConcurrentHashMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = new ConcurrentHashMap();
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void resumed(@NotNull Vm vm) {
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                this.clear();
            }

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.debugProcess.getMainVm();
    }

    @Override
    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile(script, sourceInfo);
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || scope.getType() != ScopeType.LOCAL || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result = this.scopeToMemberFilter.get(scope);
        if (result != null) {
            return result;
        }
        result = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise2 = this.scopeToMemberFilter.putIfAbsent(scope, result);
        if (promise2 == null) {
            promise2 = result;
        }
        return promise2;
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Value value = variable.getValue();
        if (value == null) {
            return ThreeState.NO;
        }
        Value value2 = value;
        ValueType valueType = value2.getType();
        if (value2 instanceof ObjectValue && ((charSequence = (CharSequence)((ObjectValue)value2).getClassName()) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)value2.getValueString()) == null || charSequence.length() == 0) && JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow().isEmpty()) {
            return ThreeState.NO;
        }
        XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
        if (!(variable instanceof NavigatableVariable)) {
            if (valueType == ValueType.FUNCTION) {
                return ThreeState.NO;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable != null) {
                JSVariable it = jSVariable;
                boolean bl = false;
                PsiElement navigationElement = it.getNavigationElement();
                VirtualFile file2 = navigationElement.getContainingFile().getVirtualFile();
                VirtualFile virtualFile = file2;
                if (virtualFile != null) {
                    Intrinsics.checkNotNull((Object)virtualFile);
                    VirtualFile it2 = file2;
                    boolean bl2 = false;
                    Document document = FileDocumentManager.getInstance().getDocument(it2);
                    virtualFile = document;
                    if (document != null) {
                        it2 = virtualFile;
                        boolean bl3 = false;
                        callback2.computed(xDebuggerUtil.createPositionByOffset(file2, navigationElement.getTextOffset()));
                        return ThreeState.YES;
                    }
                }
            }
            return ThreeState.NO;
        }
        ReadAction.nonBlocking(() -> JavaScriptDebuggerViewSupport.computeInlineDebuggerData$lambda$5(variable, xDebuggerUtil, callback2, this)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return ThreeState.YES;
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script it = script2;
            boolean bl = false;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            Vm it = vm;
            boolean bl = false;
            sourceInfo = this.getSourceInfo(functionName, (Script)it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
            return;
        }
        if (value.getType() == ValueType.NODE) {
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;
                {
                    this.$string = $string;
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string = this.$string.substring(0, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        renderer.renderComment(string);
                        String string2 = this.$string.substring(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        renderer.renderValue(string2, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
            }, true);
            return;
        }
        if (!Intrinsics.areEqual((Object)value.getClassName(), (Object)value.getValueString())) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List propertiesToShow = JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow();
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, propertiesToShow)) {
            return;
        }
        if (propertiesToShow.isEmpty() || value.hasProperties() == ThreeState.NO) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        Promise promise2 = value.getProperties(propertiesToShow, context.getEvaluateContext(), (Obsolescent)node);
        boolean $i$f$onSuccess = false;
        Promise promise3 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<List<? extends Variable>>((Obsolescent)node, node, value, icon){
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;
            {
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void accept(Object param) {
                List it = (List)param;
                boolean bl = false;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onSuccess(...)");
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        promise3.onError((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkNotNullParameter((Object)objectValue, (String)"objectValue");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    @Override
    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @Override
    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return new ChromeEvaluator(frame);
    }

    @Override
    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"TypeError") || Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"ReferenceError")) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return ((NavigatableVariable)variable).hasSourcePosition();
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (scope.getType() != ScopeType.LOCAL && scope.getType() != ScopeType.CLOSURE) {
            if (scope.getType() != ScopeType.CATCH) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    @Override
    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
            if (variable instanceof NavigatableVariable) {
                navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
                return;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable == null) break block1;
            JSVariable it = jSVariable;
            boolean bl = false;
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)it));
        }
    }

    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        PsiElement psiElement;
        VariableContext variableContext = context.getParent();
        CallFrameView callFrameView = variableContext instanceof CallFrameView ? (CallFrameView)variableContext : null;
        if (callFrameView == null || (callFrameView = callFrameView.getSourcePosition()) == null) {
            return null;
        }
        CallFrameView sourcePosition2 = callFrameView;
        VirtualFile virtualFile = sourcePosition2.getFile();
        int n = sourcePosition2.getOffset();
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement2 = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement contextElement = psiElement2;
        JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        if (jSFunction != null) {
            psiElement = (PsiElement)jSFunction;
        } else {
            PsiFile psiFile = contextElement.getContainingFile();
            if (psiFile != null) {
                psiElement = (PsiElement)psiFile;
            } else {
                return null;
            }
        }
        PsiElement host = psiElement;
        Ref.ObjectRef result = new Ref.ObjectRef();
        ((NavigatablePsiElement)host).accept((PsiElementVisitor)new JSElementVisitor((Ref.ObjectRef<JSVariable>)result, variableSourceName){
            final /* synthetic */ Ref.ObjectRef<JSVariable> $result;
            final /* synthetic */ String $variableSourceName;
            {
                this.$result = $result;
                this.$variableSourceName = $variableSourceName;
            }

            public void visitElement(@NotNull PsiElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.$result.element == null) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSParameter(@NotNull JSParameter node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSParameter(node);
                }
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSVariable(node);
                }
            }
        });
        return (JSVariable)result.element;
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.debugProcess.normalizeMemberName(string);
    }

    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Script script, boolean tryToResolveByUrl) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        VmScriptFile vmScriptFile = (VmScriptFile)((Object)script.getUserData(VmScriptFileSystemKt.getVM_SCRIPT_FILE_KEY()));
        if (vmScriptFile != null && (virtualFile = vmScriptFile.ensureDownloaded()) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            return it;
        }
        Url url = script.getUrl();
        if (tryToResolveByUrl) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"!transpiled", (boolean)false, (int)2, null)) {
                JavaScriptDebugProcess<?> $this$getFileByUrlOrVmSource_u24lambda_u2411 = this.debugProcess;
                boolean bl = false;
                virtualFile = $this$getFileByUrlOrVmSource_u24lambda_u2411.findFile(script);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl2 = false;
                    return Promises.resolvedPromise((Object)it);
                }
            }
        }
        Promise promise2 = VmScriptFileSystemKt.getVmFile(script).ensureDownloaded().onSuccess(arg_0 -> JavaScriptDebuggerViewSupport.getFileByUrlOrVmSource$lambda$13((Function1)new Function1<VirtualFile, Unit>(this, url){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ Url $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(1);
            }

            public final void invoke(VirtualFile it) {
                JavaScriptDebugProcess<?> javaScriptDebugProcess = this.this$0.getDebugProcess();
                Intrinsics.checkNotNull((Object)it);
                javaScriptDebugProcess.saveResolvedFile(this.$url, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
        return promise2;
    }

    @Override
    @NotNull
    public Promise<?> computeReceiverVariable(@NotNull VariableContext context, @NotNull CallFrame callFrame, @NotNull XCompositeNode node) {
        Promise<?> promise2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!Registry.is((String)"js.debugger.use.vm.receiver", (boolean)false) && (promise2 = this.computeReceiverVariableUsingEvaluate(callFrame, context, node)) != null) {
            Promise<?> it = promise2;
            boolean bl = false;
            return it;
        }
        return super.computeReceiverVariable(context, callFrame, node);
    }

    private final Promise<?> computeReceiverVariableUsingEvaluate(CallFrame callFrame, VariableContext context, XCompositeNode node) {
        VariableContext parent;
        for (parent = context; parent != null && !(parent instanceof CallFrameView); parent = parent.getParent()) {
        }
        VariableContext variableContext = parent;
        CallFrameView callFrameView = variableContext instanceof CallFrameView ? (CallFrameView)variableContext : null;
        if (callFrameView == null || (callFrameView = callFrameView.getSourcePosition()) == null || (callFrameView = callFrameView.getFile()) == null) {
            return null;
        }
        CallFrameView file2 = callFrameView;
        return (Promise)ActionsKt.runReadAction((Function0)((Function0)new Function0<Promise<? extends Object>>(this, (VirtualFile)file2, callFrame, node, context){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ CallFrame $callFrame;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ VariableContext $context;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$callFrame = $callFrame;
                this.$node = $node;
                this.$context = $context;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Promise<? extends Object> invoke() {
                Project project = this.this$0.getDebugProcess().getSession().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(this.$file);
                if (psiFile == null) {
                    return null;
                }
                PsiFile psiFile2 = psiFile;
                try {
                    Document document;
                    Document document2 = document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
                    Intrinsics.checkNotNull((Object)document2);
                    int offset = document2.getLineStartOffset(this.$callFrame.getLine()) + this.$callFrame.getColumn();
                    PsiElement psiElement = psiFile2.findElementAt(offset);
                    if (psiElement == null) {
                        return null;
                    }
                    PsiElement elementAtOffset = psiElement;
                    PsiElement executionScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)elementAtOffset);
                    if (executionScope instanceof JSFunctionExpression && ((JSFunctionExpression)executionScope).isArrowFunction()) {
                        void $this$onError$iv;
                        Obsolescent node$iv;
                        Promise $this$onSuccess$iv;
                        Promise promise2 = EvaluateContext.evaluate$default((EvaluateContext)this.$callFrame.getEvaluateContext(), (String)"this", null, (boolean)false, null, (int)14, null);
                        Obsolescent obsolescent = (Obsolescent)this.$node;
                        XCompositeNode xCompositeNode = this.$node;
                        VariableContext variableContext = this.$context;
                        boolean $i$f$onSuccess = false;
                        Promise promise3 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, xCompositeNode, variableContext){
                            final /* synthetic */ XCompositeNode $node$inlined;
                            final /* synthetic */ VariableContext $context$inlined;
                            {
                                this.$node$inlined = xCompositeNode;
                                this.$context$inlined = variableContext;
                                super($node);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public void accept(Object param) {
                                EvaluateResult it = (EvaluateResult)param;
                                boolean bl = false;
                                this.$node$inlined.addChildren(XValueChildrenList.singleton((XNamedValue)VariableViewKt.VariableView((Variable)new VariableImpl("this", it.getValue()), this.$context$inlined)), true);
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onSuccess(...)");
                        $this$onSuccess$iv = promise3;
                        node$iv = (Obsolescent)this.$node;
                        xCompositeNode = this.$node;
                        boolean $i$f$onError = false;
                        Promise promise4 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, xCompositeNode){
                            final /* synthetic */ XCompositeNode $node$inlined;
                            {
                                this.$node$inlined = xCompositeNode;
                                super($node);
                            }

                            public void accept(@NotNull Throwable param) {
                                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                                Throwable it = param;
                                boolean bl = false;
                                this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"onError(...)");
                        return promise4;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final void computeInlineDebuggerData$lambda$5(Variable $variable, XDebuggerUtil $xDebuggerUtil, XInlineDebuggerDataCallback $callback, JavaScriptDebuggerViewSupport this$0) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        PsiElement declarationElement;
        Iterable position;
        Intrinsics.checkNotNullParameter((Object)$variable, (String)"$variable");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HashSet<Integer> lines = new HashSet<Integer>();
        NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)$variable;
        PsiElement psiElement = navigatableVariable.getElementPointer().getElement();
        if (psiElement instanceof JSReferenceExpression && (position = $xDebuggerUtil.createPositionByElement(declarationElement = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)psiElement))) != null && lines.add(position.getLine())) {
            $callback.computed((XSourcePosition)position);
        }
        position = navigatableVariable.getInlineReferences();
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SmartPsiElementPointer ref = (SmartPsiElementPointer)element$iv$iv;
            boolean bl = false;
            if (!(ref.getPsiRange() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            XSourcePosition it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SmartPsiElementPointer ref = (SmartPsiElementPointer)element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = ref.getVirtualFile();
            Segment segment = ref.getPsiRange();
            Intrinsics.checkNotNull((Object)segment);
            if ($xDebuggerUtil.createPositionByOffset(virtualFile, segment.getStartOffset()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List positions = (List)destination$iv$iv;
        XSourcePosition currentPosition = this$0.debugProcess.getSession().getCurrentPosition();
        if (currentPosition != null && positions.size() > 1) {
            int debugLine = currentPosition.getLine();
            int nearestLine = Integer.MAX_VALUE;
            Object e = positions.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            XSourcePosition bestPos = (XSourcePosition)e;
            for (XSourcePosition pos : positions) {
                int distance = Math.abs(debugLine - pos.getLine());
                if (distance >= nearestLine) continue;
                nearestLine = distance;
                Intrinsics.checkNotNull((Object)pos);
                bestPos = pos;
            }
            if (lines.add(bestPos.getLine())) {
                $callback.computed(bestPos);
            }
        } else {
            for (XSourcePosition pos : positions) {
                if (!lines.add(pos.getLine())) continue;
                $callback.computed(pos);
            }
        }
    }

    private static final void getFileByUrlOrVmSource$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

