/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ValueModifierUtil;

public final class JSDebuggerSupportUtils {
    @Nullable
    public static ExpressionInfo getExpressionAtOffset(@NotNull Project project, @NotNull Document document, int offset) {
        PsiFile file2;
        if (project == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(0);
        }
        if (document == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(1);
        }
        return (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null ? null : JSDebuggerSupportUtils.getExpressionAtOffset(document, file2, offset);
    }

    @Nullable
    public static ExpressionInfo getExpressionAtOffset(@NotNull Document document, @NotNull PsiFile file2, int offset) {
        PsiReference[] refs;
        PsiReference[] psiReferenceArray;
        if (document == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(3);
        }
        int injectionOffsetCorrection = 0;
        PsiReference ref = file2.findReferenceAt(offset);
        if (ref == null) {
            PsiElement at = file2.findElementAt(offset);
            TextRange rangeForNamedElement = JSDebuggerSupportUtils.getRangeForNamedElement(at, 0);
            if (rangeForNamedElement != null) {
                return new ExpressionInfo(rangeForNamedElement);
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)at, PsiLanguageInjectionHost.class);
            if (psiLanguageInjectionHost != null) {
                MyInjectedPsiVisitor visitor2 = new MyInjectedPsiVisitor(offset);
                InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)psiLanguageInjectionHost, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor2);
                ref = visitor2.result;
                if (ref == null) {
                    rangeForNamedElement = JSDebuggerSupportUtils.getRangeForNamedElement(visitor2.elementInInjected, visitor2.injectedOffset);
                    if (rangeForNamedElement != null) {
                        return new ExpressionInfo(rangeForNamedElement);
                    }
                } else {
                    injectionOffsetCorrection = visitor2.injectedOffset;
                }
            }
            if (ref == null) {
                return null;
            }
        }
        if (ref instanceof PsiMultiReference) {
            psiReferenceArray = ((PsiMultiReference)ref).getReferences();
        } else {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = ref;
        }
        for (PsiReference reference : refs = psiReferenceArray) {
            PsiElement element = reference.getElement();
            if (element instanceof JSProperty) {
                ExpressionInfo result = JSDebuggerSupportUtils.getEvaluationInfoForPropertyReference((JSProperty)element, document, null, injectionOffsetCorrection);
                if (result == null) continue;
                return result;
            }
            if (element instanceof JSDestructuringShorthandedProperty) {
                element = ((JSDestructuringShorthandedProperty)element).getDestructuringElement().getNameIdentifier();
                return new ExpressionInfo(element.getTextRange().shiftRight(injectionOffsetCorrection));
            }
            if (!(element instanceof JSElement)) continue;
            return new ExpressionInfo(element.getTextRange().shiftRight(injectionOffsetCorrection));
        }
        return null;
    }

    @Nullable
    private static ExpressionInfo getEvaluationInfoForPropertyReference(@NotNull JSProperty property, @NotNull Document document, @Nullable ExpressionInfoFactory expressionInfoFactory, int injectionOffsetCorrection) {
        PsiElement name;
        if (property == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(4);
        }
        if (document == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(5);
        }
        if ((name = property.getNameIdentifier()) == null) {
            return null;
        }
        ArrayList<String> expression = new ArrayList<String>();
        ArrayList<String> displayName = new ArrayList<String>();
        NameMapper nameMapper = null;
        boolean nameMapperComputed = expressionInfoFactory == null;
        JSProperty parent = property;
        do {
            VirtualFile file2;
            if (parent instanceof JSProperty || parent instanceof JSVariable) {
                PsiElement identifier = ((JSNamedElement)parent).getNameIdentifier();
                if (identifier == null) {
                    return null;
                }
                if (!nameMapperComputed) {
                    nameMapperComputed = true;
                    file2 = parent.getContainingFile().getVirtualFile();
                    if (file2 != null) {
                        nameMapper = expressionInfoFactory.createNameMapper(file2, document);
                    }
                }
                JSDebuggerSupportUtils.appendName(expression, identifier, nameMapper);
                displayName.add(identifier.getText());
                if (!(parent instanceof JSVariable)) continue;
                return JSDebuggerSupportUtils.createInfo(name, expression, displayName, injectionOffsetCorrection);
            }
            if (!(parent instanceof JSAssignmentExpression)) continue;
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand == null) {
                return null;
            }
            if (!nameMapperComputed && (file2 = parent.getContainingFile().getVirtualFile()) != null) {
                nameMapper = expressionInfoFactory.createNameMapper(file2, document);
            }
            JSDebuggerSupportUtils.appendName(expression, (PsiElement)operand, nameMapper);
            displayName.add(operand.getText());
            return JSDebuggerSupportUtils.createInfo(name, expression, displayName, injectionOffsetCorrection);
        } while (!JSDebuggerSupportUtils.isStopElement((PsiElement)(parent = parent.getParent())));
        return null;
    }

    @NotNull
    private static ExpressionInfo createInfo(@NotNull PsiElement name, @NotNull List<String> expression, @NotNull List<String> displayName, int injectionOffsetCorrection) {
        if (name == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(7);
        }
        if (displayName == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(8);
        }
        String expressionText = ValueModifierUtil.INSTANCE.propertyNamesToString(expression, true);
        String displayText = expression.equals(displayName) ? expressionText : ValueModifierUtil.INSTANCE.propertyNamesToString(displayName, true);
        return new ExpressionInfo(name.getTextRange().shiftRight(injectionOffsetCorrection), expressionText, displayText);
    }

    @Nullable
    private static TextRange getRangeForNamedElement(@Nullable PsiElement element, int offset) {
        PsiElement identifier;
        PsiElement parent;
        PsiElement psiElement = parent = element == null ? null : element.getParent();
        if (parent instanceof JSNamedElement && (identifier = ((JSNamedElement)parent).getNameIdentifier()) != null) {
            return identifier.getTextRange().shiftRight(offset);
        }
        return null;
    }

    private static void appendName(@NotNull List<String> names, @NotNull PsiElement element, @Nullable NameMapper nameMapper) {
        String rawName;
        if (names == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(10);
        }
        if (nameMapper != null && (rawName = nameMapper.map(element)) != null) {
            names.add(rawName);
            return;
        }
        names.add(element.getText());
    }

    @Nullable
    public static PsiElement resolve(@NotNull PsiPolyVariantReference referenceExpression) {
        ResolveResult[] results;
        if (referenceExpression == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(11);
        }
        return (results = referenceExpression.multiResolve(false)).length == 0 ? null : results[0].getElement();
    }

    @NotNull
    public static Promise<ExpressionInfo> getEvaluationInfo(@NotNull PsiElement elementAtOffset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        PsiElement identifier;
        if (elementAtOffset == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(12);
        }
        if (document == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(13);
        }
        if (expressionInfoFactory == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(14);
        }
        PsiElement parent = elementAtOffset;
        do {
            if (parent instanceof JSReferenceExpression) {
                JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
                AsyncPromise result = new AsyncPromise();
                AtomicInteger attempts = new AtomicInteger(0);
                ReadAction.nonBlocking(() -> {
                    attempts.incrementAndGet();
                    PsiElement target = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)referenceExpression);
                    if (target instanceof JSVariable || target instanceof JSProperty) {
                        expressionInfoFactory.create((PsiElement)referenceExpression, document).onSuccess(it -> result.setResult(it)).onError(it -> result.setError(it));
                    } else {
                        result.setResult((Object)new ExpressionInfo(referenceExpression.getTextRange()));
                    }
                    return null;
                }).expireWhen(() -> !referenceExpression.isValid() || attempts.get() > 1).submit((Executor)AppExecutorUtil.getAppExecutorService());
                AsyncPromise asyncPromise = result;
                if (asyncPromise == null) {
                    JSDebuggerSupportUtils.$$$reportNull$$$0(15);
                }
                return asyncPromise;
            }
            if (!(parent instanceof JSProperty)) continue;
            Promise promise2 = Promises.resolvedPromise((Object)JSDebuggerSupportUtils.getEvaluationInfoForPropertyReference((JSProperty)parent, document, expressionInfoFactory, 0));
            if (promise2 == null) {
                JSDebuggerSupportUtils.$$$reportNull$$$0(16);
            }
            return promise2;
        } while (!JSDebuggerSupportUtils.isStopElement(parent = parent.getParent()));
        parent = elementAtOffset.getParent();
        if (parent instanceof JSNamedElement && (identifier = ((JSNamedElement)parent).getNameIdentifier()) != null) {
            Promise<ExpressionInfo> promise3 = expressionInfoFactory.create(identifier, document);
            if (promise3 == null) {
                JSDebuggerSupportUtils.$$$reportNull$$$0(17);
            }
            return promise3;
        }
        Promise promise4 = Promises.resolvedPromise(null);
        if (promise4 == null) {
            JSDebuggerSupportUtils.$$$reportNull$$$0(18);
        }
        return promise4;
    }

    private static boolean isStopElement(@Nullable PsiElement element) {
        return element == null || element instanceof JSFunctionExpression || element instanceof JSArgumentList || element instanceof JSBlockStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtOffset";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionInfoFactory";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/JSDebuggerSupportUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/JSDebuggerSupportUtils";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationInfoForPropertyReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class MyInjectedPsiVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor {
        private final int offset;
        private PsiReference result;
        private PsiElement elementInInjected;
        private int injectedOffset;

        MyInjectedPsiVisitor(int offset) {
            this.offset = offset;
        }

        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                MyInjectedPsiVisitor.$$$reportNull$$$0(0);
            }
            if (places == null) {
                MyInjectedPsiVisitor.$$$reportNull$$$0(1);
            }
            int injectedStart = InjectedLanguageUtil.getInjectedStart(places);
            int offsetInInjected = this.offset - injectedStart;
            this.result = injectedPsi.findReferenceAt(offsetInInjected);
            this.elementInInjected = injectedPsi.findElementAt(offsetInInjected);
            this.injectedOffset = injectedStart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injectedPsi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "places";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/debugger/JSDebuggerSupportUtils$MyInjectedPsiVisitor";
            objectArray[2] = "visit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

