/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.AbstractSshFileSystem;
import com.pastdev.jsch.nio.file.StandardGroupPrincipal;
import com.pastdev.jsch.nio.file.StandardUserPrincipal;
import com.pastdev.jsch.nio.file.UnixSshFileSystemProvider;
import com.pastdev.jsch.nio.file.UnixSshFileSystemWatchService;
import com.pastdev.jsch.nio.file.UnixSshPath;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class UnixSshFileSystem
extends AbstractSshFileSystem {
    private UnixSshPath defaultDirectory;
    private UnixSshPath rootDirectory;

    public UnixSshFileSystem(UnixSshFileSystemProvider provider, URI uri, Map<String, ?> environment) throws IOException {
        super(provider, uri, environment);
        this.defaultDirectory = new UnixSshPath(this, uri.getPath());
        if (!this.defaultDirectory.isAbsolute()) {
            throw new RuntimeException("default directory must be absolute");
        }
        this.rootDirectory = new UnixSshPath(this, "/");
    }

    @Override
    public void close() throws IOException {
        this.getCommandRunner().close();
        this.provider().removeFileSystem(this);
    }

    UnixSshPath getDefaultDirectory() {
        return this.defaultDirectory;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnixSshPath getPath(String first, String ... more) {
        if (more == null || more.length == 0) {
            return new UnixSshPath(this, first);
        }
        StringBuilder builder = new StringBuilder(first);
        for (String part : more) {
            builder.append('/').append(part);
        }
        return new UnixSshPath(this, builder.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        int firstColon = syntaxAndPattern.indexOf(58);
        if (firstColon == -1) {
            throw new IllegalArgumentException("must be of the form 'syntax:pattern'");
        }
        String syntax = syntaxAndPattern.substring(0, firstColon);
        String patternString = syntaxAndPattern.substring(firstColon + 1);
        if (syntax.equalsIgnoreCase("glob")) {
            StringBuilder builder = new StringBuilder().append('^');
            char[] chars = patternString.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '*') {
                    if (chars[i + 1] == '*') {
                        builder.append(".*");
                        ++i;
                        continue;
                    }
                    builder.append("[^/]*");
                    continue;
                }
                if (c == '?') {
                    builder.append('.');
                    continue;
                }
                if (c == '{') {
                    builder.append("(?:");
                    while (true) {
                        if (++i >= chars.length) {
                            throw new IllegalArgumentException("invalid glob '" + patternString + "'");
                        }
                        c = chars[i];
                        if (c == ',') {
                            builder.append('|');
                            continue;
                        }
                        if (c == '}') break;
                        builder.append(c);
                    }
                    builder.append(")");
                    continue;
                }
                if (c == '[') {
                    builder.append('[');
                    boolean first = true;
                    boolean caratEncountered = false;
                    while (true) {
                        if (++i >= chars.length) {
                            throw new IllegalArgumentException("invalid glob '" + patternString + "', unclosed range");
                        }
                        c = chars[i];
                        if (first) {
                            if (c == '!') {
                                builder.append("^");
                            } else if (c == '^') {
                                caratEncountered = true;
                            } else {
                                builder.append(c);
                            }
                            first = false;
                            continue;
                        }
                        if (c == ']') break;
                        if (c == '\\') {
                            builder.append("\\\\");
                            continue;
                        }
                        builder.append(c);
                    }
                    if (caratEncountered) {
                        builder.append('^');
                    }
                    builder.append(']');
                    continue;
                }
                if (c == '\\') {
                    if (++i < chars.length) {
                        builder.append(chars[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("invalid glob '" + patternString + "'");
                }
                if (c == '.') {
                    builder.append("\\.");
                    continue;
                }
                if (c == '+') {
                    builder.append("\\+");
                    continue;
                }
                if (c == '(') {
                    builder.append("\\(");
                    continue;
                }
                builder.append(c);
            }
            patternString = builder.append('$').toString();
        } else if (!syntax.equalsIgnoreCase("regex")) {
            throw new UnsupportedOperationException("i dont have any clue what '" + syntax + "' is supposed to mean");
        }
        final Pattern pattern = Pattern.compile(patternString);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.unmodifiableList(Arrays.asList(this.rootDirectory));
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return new UserPrincipalLookupService(){

            @Override
            public UserPrincipal lookupPrincipalByName(String user) throws IOException {
                if (UnixSshFileSystem.this.getCommandRunner().execute("id " + user).getExitCode() == 0) {
                    return new StandardUserPrincipal(user);
                }
                throw new UserPrincipalNotFoundException(user + " does not exist");
            }

            @Override
            public GroupPrincipal lookupPrincipalByGroupName(String group2) throws IOException {
                if (UnixSshFileSystem.this.getCommandRunner().execute("egrep -i \"^" + group2 + "\" /etc/group").getExitCode() == 0) {
                    return new StandardGroupPrincipal(group2);
                }
                throw new UserPrincipalNotFoundException(group2 + " does not exist");
            }
        };
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        if (this.getBooleanFromEnvironment("watchservice.inotify")) {
            return UnixSshFileSystemWatchService.inotifyWatchService();
        }
        return UnixSshFileSystemWatchService.pollingWatchService(this.getLongFromEnvironment("watchservice.polling.interval"), this.getTimeUnitFromEnvironment("watchservice.polling.timeunit"));
    }

    @Override
    public UnixSshFileSystemProvider provider() {
        return (UnixSshFileSystemProvider)super.provider();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> supportedFileAttributeViews = new HashSet<String>();
        supportedFileAttributeViews.addAll(Arrays.asList("basic", "posix"));
        return Collections.unmodifiableSet(supportedFileAttributeViews);
    }
}

