/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.workspaceModelBridge;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocationUtilKt;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.workspace.CidrKnownModuleDetector;
import com.jetbrains.cidr.project.workspace.OCRootsBuilder;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.workspaceModelBridge.OCEntitySource;
import com.jetbrains.cidr.workspaceModelBridge.OCImportedModuleEntitySource;
import com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsBuilder;
import com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsSynchronizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0015J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsSynchronizer;", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyRoots", "", "enableRootConfiguration", "", "findModuleOrCreateNew", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "getModuleIfExists", "Lcom/intellij/openapi/module/Module;", "getModuleOrCreateNew", "Companion", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nOCWorkspaceModelRootsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCWorkspaceModelRootsSynchronizer.kt\ncom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n1#2:172\n3792#3:173\n4307#3,2:174\n*S KotlinDebug\n*F\n+ 1 OCWorkspaceModelRootsSynchronizer.kt\ncom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsSynchronizer\n*L\n115#1:173\n115#1:174,2\n*E\n"})
public final class OCWorkspaceModelRootsSynchronizer
extends OCRootsSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @JvmField
    @NotNull
    public static final Logger LOG;

    public OCWorkspaceModelRootsSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.project.getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Sequence entitiesWithDummyEntitySource2 = event.getStorageAfter().entitiesBySource((Function1)changed.entitiesWithDummyEntitySource.1.INSTANCE);
                if (SequencesKt.none((Sequence)entitiesWithDummyEntitySource2)) {
                    return;
                }
                this.applyRoots(false);
            }
        });
    }

    @Override
    @RequiresWriteLock
    protected void applyRoots(boolean enableRootConfiguration) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        OCRootsBuilder<?> rootsBuilder = OCRootsBuilder.Provider.findRootsBuilder(this.project);
        if (rootsBuilder == null) {
            LOG.error("Cannot find implementation of OCRootsBuilder. Please register OCRootsBuilder");
            return;
        }
        if (!(rootsBuilder instanceof OCWorkspaceModelRootsBuilder)) {
            LOG.error("Fix me: Only OCWorkspaceModelRootsBuilder is currently supported. Actual rootsBuilder is " + rootsBuilder.getClass().getName());
            return;
        }
        ModuleBridge module = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getModule();
        ModuleEntity moduleEntity = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getModuleEntity();
        MutableEntityStorage builder = ((OCWorkspaceModelRootsBuilder)rootsBuilder).getBuilder();
        this.registerRoots(rootsBuilder);
        workspaceModel.updateProjectModel("CIDR: apply roots", (Function1)new Function1<MutableEntityStorage, Unit>(builder, moduleEntity){
            final /* synthetic */ MutableEntityStorage $builder;
            final /* synthetic */ ModuleEntity $moduleEntity;
            {
                this.$builder = $builder;
                this.$moduleEntity = $moduleEntity;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.replaceBySource((Function1)new Function1<EntitySource, Boolean>(this.$moduleEntity){
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    {
                        this.$moduleEntity = $moduleEntity;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull EntitySource entitySource) {
                        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
                        return com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsSynchronizer$Companion.access$isSupportedSource(OCWorkspaceModelRootsSynchronizer.Companion, entitySource, this.$moduleEntity);
                    }
                }, (EntityStorage)this.$builder);
            }
        });
        if (enableRootConfiguration) {
            CidrRootConfiguration.Companion.setEnabledFor(this.getModuleOrCreateNew(), true);
        }
        Facet[] facetArray = FacetManager.getInstance((Module)((Module)module)).getAllFacets();
        Intrinsics.checkNotNullExpressionValue((Object)facetArray, (String)"getAllFacets(...)");
        for (Facet f : facetArray) {
            f.initFacet();
        }
    }

    @NotNull
    public final Pair<ModuleBridge, ModuleEntity> findModuleOrCreateNew(@NotNull WorkspaceModel workspaceModel) {
        Intrinsics.checkNotNullParameter((Object)workspaceModel, (String)"workspaceModel");
        Module module = this.getModuleOrCreateNew();
        Intrinsics.checkNotNull((Object)module, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
        ModuleBridge module2 = (ModuleBridge)module;
        WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = workspaceModel.getCurrentSnapshot().resolve((SymbolicEntityId)module2.getModuleEntityId());
        Intrinsics.checkNotNull((Object)workspaceEntityWithSymbolicId);
        ModuleEntity moduleEntity = (ModuleEntity)workspaceEntityWithSymbolicId;
        return new Pair((Object)module2, (Object)moduleEntity);
    }

    @Override
    @Nullable
    public Module getModuleIfExists() {
        Module module;
        Object v0;
        ModuleEntity it;
        Sequence sequence;
        Sequence moduleEntities2;
        block4: {
            sequence = moduleEntities2 = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().entities(ModuleEntity.class);
            for (Object e : sequence) {
                it = (ModuleEntity)e;
                boolean bl = false;
                if (!(it.getEntitySource() instanceof OCEntitySource)) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        ModuleEntity moduleEntity = v0;
        if (moduleEntity == null) {
            Object v1;
            block5: {
                sequence = moduleEntities2;
                for (Object e : sequence) {
                    it = (ModuleEntity)e;
                    boolean bl = false;
                    if (!(it.getEntitySource() instanceof JpsProjectFileEntitySource.FileInDirectory && it.getType() == null)) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            moduleEntity = v1;
        }
        if (moduleEntity != null && (module = ModuleManager.Companion.getInstance(this.project).findModuleByName(moduleEntity.getName())) != null) {
            return module;
        }
        return super.getModuleIfExists();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Module getModuleOrCreateNew() {
        Module module = this.getModuleIfExists();
        if (module == null) {
            Application application = ApplicationManager.getApplication();
            if (!application.isUnitTestMode() && application.isInternal() && PluginUtils.hasCLion()) {
                void $this$filterTo$iv$iv;
                Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.project).getModules();
                boolean $i$f$filter = false;
                Module[] moduleArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!(!CidrKnownModuleDetector.Companion.isKnownModule((Module)it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List modules = (List)destination$iv$iv;
                if (!((Collection)modules).isEmpty()) {
                    ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
                    String modulesString2 = CollectionsKt.joinToString$default((Iterable)modules, null, null, null, (int)0, null, (Function1)getModuleOrCreateNew.modulesString.1.INSTANCE, (int)31, null);
                    String moduleEntities2 = SequencesKt.joinToString$default((Sequence)storage.entities(ModuleEntity.class), null, null, null, (int)0, null, (Function1)getModuleOrCreateNew.moduleEntities.1.INSTANCE, (int)31, null);
                    String errorMessage = StringsKt.trimMargin$default((String)("CLion doesn't support multi-module projects. \n            |Current modules: " + modulesString2 + "\n            |Module entities: " + moduleEntities2), null, (int)1, null);
                    LOG.error(errorMessage);
                }
            }
            String string = UniqueNameGenerator.generateUniqueName((String)this.project.getName(), arg_0 -> OCWorkspaceModelRootsSynchronizer.getModuleOrCreateNew$lambda$3((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ OCWorkspaceModelRootsSynchronizer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(String it) {
                    ModuleManager moduleManager = ModuleManager.Companion.getInstance(OCWorkspaceModelRootsSynchronizer.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNull((Object)it);
                    return moduleManager.findModuleByName(it) == null;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            String moduleName2 = string;
            WorkspaceModel.Companion.getInstance(this.project).updateProjectModel("CIDR: create module entity", (Function1)new Function1<MutableEntityStorage, Unit>(this, moduleName2){
                final /* synthetic */ OCWorkspaceModelRootsSynchronizer this$0;
                final /* synthetic */ String $moduleName;
                {
                    this.this$0 = $receiver;
                    this.$moduleName = $moduleName;
                    super(1);
                }

                public final void invoke(@NotNull MutableEntityStorage it) {
                    VirtualFileUrl virtualFileUrl;
                    JpsProjectConfigLocation projectLocation;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation((Project)OCWorkspaceModelRootsSynchronizer.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNull((Object)jpsProjectConfigLocation);
                    JpsProjectConfigLocation jpsProjectConfigLocation2 = projectLocation = jpsProjectConfigLocation;
                    if (jpsProjectConfigLocation2 instanceof JpsProjectConfigLocation.DirectoryBased) {
                        virtualFileUrl = ((JpsProjectConfigLocation.DirectoryBased)projectLocation).getProjectDir().append(".idea");
                    } else if (jpsProjectConfigLocation2 instanceof JpsProjectConfigLocation.FileBased) {
                        virtualFileUrl = ((JpsProjectConfigLocation.FileBased)projectLocation).getIprFileParent();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    VirtualFileUrl imlFileDir = virtualFileUrl;
                    Intrinsics.checkNotNull((Object)imlFileDir);
                    OCImportedModuleEntitySource source = new OCImportedModuleEntitySource((JpsFileEntitySource)new JpsProjectFileEntitySource.FileInDirectory(imlFileDir, projectLocation));
                    it.addEntity((WorkspaceEntity.Builder)ModuleEntity.Companion.create(this.$moduleName, CollectionsKt.listOf((Object)ModuleSourceDependency.INSTANCE), (EntitySource)source, (Function1)getModuleOrCreateNew.1.INSTANCE));
                }
            });
            Module module2 = this.getModuleIfExists();
            if (module2 == null) {
                boolean bl = false;
                String string2 = "Cannot find module to synchronize roots, modules = " + ModuleManager.Companion.getInstance(this.project).getModules();
                throw new IllegalStateException(string2.toString());
            }
            module = module2;
            ClasspathStorage.setStorageType((ModuleRootModel)((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), (String)"CIDR");
        }
        return module;
    }

    private static final boolean getModuleOrCreateNew$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(OCWorkspaceModelRootsSynchronizer $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(OCWorkspaceModelRootsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsSynchronizer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getWorkspaceModelOCRootsSynchronizer", "Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "isSupportedSource", "", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "intellij.cidr.workspaceModel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OCWorkspaceModelRootsSynchronizer getWorkspaceModelOCRootsSynchronizer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            OCRootsSynchronizer oCRootsSynchronizer = OCRootsSynchronizer.getInstance(project);
            Intrinsics.checkNotNull((Object)oCRootsSynchronizer, (String)"null cannot be cast to non-null type com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsSynchronizer");
            return (OCWorkspaceModelRootsSynchronizer)oCRootsSynchronizer;
        }

        private final boolean isSupportedSource(EntitySource entitySource, ModuleEntity moduleEntity) {
            return entitySource instanceof JpsImportedEntitySource || entitySource instanceof JpsFileEntitySource || entitySource instanceof OCEntitySource || Intrinsics.areEqual((Object)entitySource, (Object)moduleEntity.getEntitySource());
        }

        public static final /* synthetic */ boolean access$isSupportedSource(Companion $this, EntitySource entitySource, ModuleEntity moduleEntity) {
            return $this.isSupportedSource(entitySource, moduleEntity);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

