/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.PathTreeBase;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.project.CidrClasspathStorageProvider;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.workspace.CidrKnownModuleDetector;
import com.jetbrains.cidr.project.workspace.CidrOwnModuleDetector;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootTree;
import com.jetbrains.cidr.project.workspace.OCRootsBuilder;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizerListener;
import com.jetbrains.cidr.workspaceModelBridge.OCExcludeWorkspaceModelRootsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class OCRootsSynchronizer
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)("#" + OCRootsSynchronizer.class.getPackage().getName()));
    private static boolean onlyWarnOnRootInTests;
    private static final NotificationGroup myNotificationGroup;
    private final Map<CidrWorkspace, OCRootTree> myActiveRoots;
    private boolean myUpdateContentRootsRecursionProtection;
    private volatile boolean isStarted;
    @Nullable
    private MessageBusConnection myBusConnection;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Collection<String> myRootUrls;
    @NotNull
    private final Collection<String> myRefusedRootUrls;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;
    @NotNull
    private volatile String myStorageId;

    @TestOnly
    static void setOnlyWarnOnRootInTests(boolean onlyWarn) {
        onlyWarnOnRootInTests = onlyWarn;
    }

    @NotNull
    public static OCRootsSynchronizer getInstance(@NotNull Project project) {
        if (project == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(0);
        }
        OCRootsSynchronizer oCRootsSynchronizer = (OCRootsSynchronizer)project.getService(OCRootsSynchronizer.class);
        if (oCRootsSynchronizer == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(1);
        }
        return oCRootsSynchronizer;
    }

    public OCRootsSynchronizer(@NotNull Project project) {
        String systemDrive;
        if (project == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(2);
        }
        this.myActiveRoots = new HashMap<CidrWorkspace, OCRootTree>();
        this.myStorageId = "CIDR";
        this.myProject = project;
        ArrayList<String> rootUrls = new ArrayList<String>(2);
        if (SystemInfo.isWindows && (systemDrive = System.getenv("SystemDrive")) != null) {
            rootUrls.add(VfsUtilCore.pathToUrl((String)(systemDrive + "\\")));
        }
        rootUrls.add(VfsUtilCore.pathToUrl((String)"/"));
        this.myRootUrls = List.copyOf(rootUrls);
        this.myRefusedRootUrls = new ArrayList<String>(this.myRootUrls.size());
    }

    private static boolean shouldMigrateToModernCidrStorage() {
        return Registry.is((String)"cidr.workspace.migrate.to.modern.storage", (boolean)false);
    }

    @Deprecated
    public void installLegacyClasspathStorage(@NotNull String id) {
        if (id == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(3);
        }
        this.myStorageId = OCRootsSynchronizer.shouldMigrateToModernCidrStorage() ? "CIDR" : id;
    }

    public void startListening() {
        if (this.isStarted) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already started");
        }
        this.myBusConnection = this.myProject.getMessageBus().connect();
        this.synchronizeOnFileMoves(this.myBusConnection);
        this.isStarted = true;
    }

    public void shutdown() {
        if (this.isStarted) {
            this.isStarted = false;
            if (this.myBusConnection != null) {
                this.myBusConnection.disconnect();
            }
            this.myBusConnection = null;
            this.registerWatchRoots(null);
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace) {
        if (workspace == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(4);
        }
        this.updateRoots(workspace, null);
    }

    @RequiresWriteLock
    public final void updateRoots(@NotNull CidrWorkspace workspace, @Nullable File contentRoot) {
        if (workspace == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertWriteAccess();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            File actualContentRoot = workspace.beforeUpdateContentRoots(contentRoot != null ? contentRoot : workspace.getContentRoot());
            RootsInfo rootsInfo = workspace.collectRootsInfo(actualContentRoot);
            this.batchUpdateRoots(Collections.singletonList(workspace), Collections.singletonList(rootsInfo));
        });
        ((OCRootsSynchronizerListener)this.myProject.getMessageBus().syncPublisher(OCRootsSynchronizerListener.TOPIC)).afterRootsUpdated(workspace);
        LOG.debug("Updating roots took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    @TestOnly
    @RequiresWriteLock
    final void updateRootsWithInfo(@NotNull CidrWorkspace workspace, @NotNull RootsInfo rootsInfo) {
        if (workspace == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(6);
        }
        if (rootsInfo == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertWriteAccess();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> this.batchUpdateRoots(Collections.singletonList(workspace), Collections.singletonList(rootsInfo)));
    }

    @RequiresWriteLock
    final void batchUpdateRoots(@NotNull @NotNull List<@NotNull CidrWorkspace> workspaces) {
        if (workspaces == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertWriteAccess();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            ArrayList<@NotNull RootsInfo> rootsInfos = new ArrayList<RootsInfo>(workspaces.size());
            for (CidrWorkspace workspace : workspaces) {
                File contentRoot = workspace.beforeUpdateContentRoots(workspace.getContentRoot());
                rootsInfos.add(workspace.collectRootsInfo(contentRoot));
            }
            this.batchUpdateRoots(workspaces, rootsInfos);
        });
        LOG.debug("Updating roots in batch took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    private synchronized void batchUpdateRoots(@NotNull @NotNull List<@NotNull CidrWorkspace> workspaces, @NotNull @NotNull List<@NotNull RootsInfo> rootsInfos) {
        if (workspaces == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(9);
        }
        if (rootsInfos == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertWriteAccess();
        assert (workspaces.size() == rootsInfos.size());
        if (this.myUpdateContentRootsRecursionProtection) {
            return;
        }
        this.myUpdateContentRootsRecursionProtection = true;
        try {
            this.setCurrentCidrStorage(this.getModuleOrCreateNew());
            CidrRootConfiguration rootsConfiguration = null;
            Iterator<@NotNull RootsInfo> rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace workspace : workspaces) {
                RootsInfo rootsInfo = rootsInfoIterator.next();
                if (workspace.shouldEnableRootConfiguration()) {
                    if (rootsConfiguration == null) {
                        rootsConfiguration = CidrRootConfiguration.getInstance(this.myProject);
                    }
                    rootsInfo.explicitSourceFolders.addAll(rootsConfiguration.getSourceRoots());
                    rootsInfo.explicitLibraryRoots.addAll(rootsConfiguration.getLibraryRoots());
                    rootsInfo.explicitExcludeFolders.addAll(rootsConfiguration.getExcludeRoots());
                }
                this.myActiveRoots.put(workspace, OCRootsSynchronizer.prepareRootsTree(rootsInfo));
            }
            this.applyRoots(rootsConfiguration != null);
            rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace workspace : workspaces) {
                workspace.afterUpdateContentRoots(rootsInfoIterator.next());
            }
        }
        finally {
            this.myUpdateContentRootsRecursionProtection = false;
        }
    }

    @RequiresWriteLock
    protected abstract void applyRoots(boolean var1);

    protected void registerRoots(@NotNull OCRootsBuilder<?> builder) {
        OCRootTree tree;
        if (builder == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(11);
        }
        if ((tree = (OCRootTree)PathTreeBase.merge(this.myActiveRoots.values(), (boolean)true)) != null) {
            tree.accept(new TreeVisitor(builder, null));
        }
    }

    private static void migrateToModernCidrStorage(@NotNull Module module) {
        if (module == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(12);
        }
        OCRootsSynchronizer.setStorage(module, "CIDR");
    }

    private void setCurrentCidrStorage(@NotNull Module module) {
        String storageType;
        if (module == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(13);
        }
        if ("default".equals(storageType = ClassPathStorageUtil.getStorageType((Module)module)) || "CIDR".equals(storageType)) {
            OCRootsSynchronizer.setStorage(module, this.myStorageId);
        }
    }

    private static void setStorage(@NotNull Module module, @NotNull String storageId) {
        if (module == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(14);
        }
        if (storageId == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(15);
        }
        ClasspathStorage.setStorageType((ModuleRootModel)ModuleRootManager.getInstance((Module)module), (String)storageId);
    }

    public boolean isFromCidrModule(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        return this.isCidrModule(ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.myProject));
    }

    public boolean isCidrModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        if (CidrOwnModuleDetector.Companion.isOwnModule(module)) {
            return true;
        }
        return module == this.getModuleIfExists();
    }

    @Nullable
    public Module getModuleIfExists() {
        Application application;
        Module[] modules;
        Module foundModule = null;
        Module fallbackModule = null;
        boolean foundFallbackCandidate = false;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String storageType;
            boolean isModernCidrStorage;
            if (CidrKnownModuleDetector.isKnownModule(module)) continue;
            if (foundFallbackCandidate) {
                fallbackModule = null;
            }
            if (!(isModernCidrStorage = "CIDR".equals(storageType = ClassPathStorageUtil.getStorageType((Module)module))) && !(ClasspathStorage.getProvider((String)storageType) instanceof CidrClasspathStorageProvider)) {
                String moduleTypeName = module.getModuleTypeName();
                if (foundFallbackCandidate || !ModuleTypeManager.getInstance().getDefaultModuleType().getId().equals(moduleTypeName) && moduleTypeName != null) continue;
                foundFallbackCandidate = true;
                fallbackModule = module;
                continue;
            }
            if (foundModule != null) {
                LOG.warn(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + foundModule.getName() + "' will be used.");
                break;
            }
            if (!isModernCidrStorage && OCRootsSynchronizer.shouldMigrateToModernCidrStorage()) {
                OCRootsSynchronizer.migrateToModernCidrStorage(module);
            }
            foundModule = module;
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode() && application.isInternal() && PluginUtils.hasCLion() && modules.length > 1 && Arrays.stream(modules).filter(m -> !CidrKnownModuleDetector.isKnownModule(m)).count() > 1L) {
            String foundModuleName = foundModule != null ? foundModule.getName() : null;
            String fallbackModuleName = fallbackModule != null ? fallbackModule.getName() : null;
            LOG.error(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + foundModuleName + "' will be used. Also fallbackModule is " + fallbackModuleName);
        }
        if (foundModule != null || fallbackModule == null) {
            return foundModule;
        }
        if (OCRootsSynchronizer.shouldMigrateToModernCidrStorage()) {
            OCRootsSynchronizer.migrateToModernCidrStorage(fallbackModule);
        }
        return fallbackModule;
    }

    @NotNull
    public Module getModuleOrCreateNew() {
        ThreadingAssertions.assertEventDispatchThread();
        Module module = this.getModuleIfExists();
        if (module != null) {
            Module module2 = module;
            if (module2 == null) {
                OCRootsSynchronizer.$$$reportNull$$$0(16);
            }
            return module2;
        }
        Module module3 = (Module)WriteAction.compute(() -> {
            VirtualFile baseDir;
            IProjectStore store = ProjectKt.getStateStore((Project)this.myProject);
            Path moduleDirPath = store.getDirectoryStorePath();
            if (moduleDirPath == null) {
                moduleDirPath = store.getProjectBasePath();
            }
            String moduleName2 = store.getProjectName();
            File moduleDir = moduleDirPath.toFile();
            File imlFile = new File(moduleDir, FileUtil.createSequentFileName((File)moduleDir, (String)moduleName2, (String)"iml"));
            Module newModule = ModuleManager.getInstance((Project)this.myProject).newModule(imlFile.getPath(), ModuleTypeManager.getInstance().getDefaultModuleType().getId());
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)newModule);
            ClasspathStorage.setStorageType((ModuleRootModel)rootManager, (String)"CIDR");
            ModifiableRootModel rootModel = rootManager.getModifiableModel();
            if (rootModel.getContentRoots().length == 0 && (baseDir = LocalFileSystem.getInstance().findFileByNioFile(store.getProjectBasePath())) != null) {
                rootModel.addContentEntry(baseDir);
            }
            rootModel.commit();
            return newModule;
        });
        if (module3 == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(17);
        }
        return module3;
    }

    private void registerWatchRoots(@Nullable Collection<String> toStartWatching) {
        Set toStopWatching = (Set)ObjectUtils.notNull(this.myWatchRequest, Collections.emptySet());
        this.myWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoots((Collection)toStopWatching, toStartWatching, null);
    }

    @NotNull
    private static OCRootTree prepareRootsTree(@NotNull RootsInfo info) {
        if (info == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(18);
        }
        final OCRootTree tree = new OCRootTree();
        tree.addAll((Collection<File>)info.contentRoots, OCRootTree.RootKind.CONTENT);
        if (info.registerSystemHeaderRootUnderContentRootAsLibraries) {
            tree.addAll((Collection<File>)info.contentRoots, OCRootTree.RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT);
        }
        tree.addAll((Collection<File>)info.sourceFiles, OCRootTree.RootKind.SOURCE);
        tree.addAll((Collection<File>)info.generatedSourceFiles, OCRootTree.RootKind.SOURCE_GENERATED);
        tree.addAll(info.additionalBuildDirs, OCRootTree.RootKind.EXCLUDE, OCRootTree.RootKind.WATCHED);
        tree.addAll((Collection<File>)info.explicitLibraryRoots, OCRootTree.RootKind.EXPLICIT_LIBRARY);
        tree.addAll((Collection<File>)info.explicitSourceFolders, OCRootTree.RootKind.EXPLICIT_SOURCE);
        tree.addAll((Collection<File>)info.explicitExcludeFolders, OCRootTree.RootKind.EXPLICIT_EXCLUDE);
        tree.addAll((Collection<File>)info.watchRoots, OCRootTree.RootKind.WATCHED);
        long before = System.currentTimeMillis();
        final HashSet userHeaderRoots = new HashSet();
        HashSet<HeadersSearchRoot> seenRoots = new HashSet<HeadersSearchRoot>();
        for (final HeadersSearchRoot root : info.headersSearchRoots) {
            if (!seenRoots.add(root)) continue;
            root.processChildren(new HeadersSearchRootProcessor(){

                @Override
                public boolean shouldProcessRootsOnly() {
                    return true;
                }

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    VirtualFile virtualFile;
                    if (framework == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((virtualFile = framework.getVirtualFile()) != null) {
                        tree.addItem(virtualFile.getUrl(), (Object)OCRootTree.RootKind.LIBRARY_EXCLUDE);
                    }
                    HeadersSearchRootProcessor.FrameworkResult frameworkResult = HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                    if (frameworkResult == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return frameworkResult;
                }

                @Override
                public boolean process(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (file.isDirectory()) {
                        switch (root.getKind()) {
                            case BUILTIN: 
                            case FRAMEWORK: 
                            case SYSTEM: {
                                tree.addItem(file.getUrl(), (Object)OCRootTree.RootKind.LIBRARY);
                                break;
                            }
                            case USER: {
                                userHeaderRoots.add(file);
                            }
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "framework";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "processFramework";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "processFramework";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
        }
        for (VirtualFile each : OCRootsSynchronizer.removeDuplicatesAndSubdirs(userHeaderRoots)) {
            tree.addItem(each.getUrl(), (Object)OCRootTree.RootKind.CONTENT);
        }
        LOG.debug("Roots collection took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)) + " for " + info.headersSearchRoots.size() + " roots");
        OCRootTree oCRootTree = tree;
        if (oCRootTree == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(19);
        }
        return oCRootTree;
    }

    private void synchronizeOnFileMoves(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(20);
        }
        if (OCExcludeWorkspaceModelRootsBuilder.isEnabled()) {
            return;
        }
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                Module module;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((module = OCRootsSynchronizer.this.getModuleIfExists()) == null) {
                    return;
                }
                Iterator it = events.stream().filter(event -> event instanceof VFileMoveEvent).map(event -> (VFileMoveEvent)event).iterator();
                if (!it.hasNext()) {
                    return;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                ModuleFileIndex index = rootManager.getFileIndex();
                Map libraryModels = FactoryMap.create(key -> (LibraryEx.ModifiableModelEx)((LibraryOrderEntry)key).getLibrary().getModifiableModel());
                ExcludedRootsTree rootsToExclude = new ExcludedRootsTree(rootManager.getContentEntries());
                do {
                    VFileMoveEvent moveEvent;
                    ExcludedRootsTree rootsToExcludeUnderMovedFile;
                    if ((rootsToExcludeUnderMovedFile = rootsToExclude.getExcludedRootsSubTreeUnder((moveEvent = (VFileMoveEvent)it.next()).getFile())) == null) continue;
                    OrderEntry wasInLibrary = index.getOrderEntryForFile(moveEvent.getOldParent());
                    boolean wasInModuleLibrary = OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)wasInLibrary);
                    rootsToExcludeUnderMovedFile.processRoots((Processor<VirtualFile>)((Processor)eachRoot -> {
                        OrderEntry isInLibrary = index.getOrderEntryForFile(eachRoot.getParent());
                        boolean isInModuleLibrary = OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)isInLibrary);
                        if (isInModuleLibrary && !wasInModuleLibrary) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(isInLibrary)).addExcludedRoot(eachRoot.getUrl());
                        } else if (wasInModuleLibrary && !isInModuleLibrary) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(wasInLibrary)).removeExcludedRoot(eachRoot.getUrl());
                        }
                        return true;
                    }));
                } while (it.hasNext());
                for (LibraryEx.ModifiableModelEx each : libraryModels.values()) {
                    each.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer$2", "after"));
            }
        });
    }

    @NotNull
    public static Set<File> collectFilesNotUnder(@Nullable Collection<File> parents, @Nullable Collection<File> files) {
        if (files == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                OCRootsSynchronizer.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<File> set = files.stream().filter(file -> !OCRootsSynchronizer.isUnder(parents, file)).collect(Collectors.toSet());
        if (set == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(22);
        }
        return set;
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable Collection<File> files) {
        return files != null && ContainerUtil.all(files, file -> OCRootsSynchronizer.isUnder(parents, file));
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file) {
        return OCRootsSynchronizer.isUnder(parents, file, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file, boolean strict) {
        if (parents == null || file == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> removeDuplicatesAndSubdirs(Collection<? extends VirtualFile> files) {
        ArrayList<VirtualFile> answer = new ArrayList<VirtualFile>(files);
        answer.sort((o1, o2) -> FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath()));
        Iterator it = answer.iterator();
        VirtualFile prev = null;
        while (it.hasNext()) {
            VirtualFile next = (VirtualFile)it.next();
            if (prev != null && VfsUtilCore.isAncestor((VirtualFile)prev, (VirtualFile)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        ArrayList<VirtualFile> arrayList = answer;
        if (arrayList == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    static {
        myNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Project Roots");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 16, 17, 19, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaces";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsInfos";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOrCreateNew";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRootsTree";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesNotUnder";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesAndSubdirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installLegacyClasspathStorage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateRootsWithInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "batchUpdateRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "migrateToModernCidrStorage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentCidrStorage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setStorage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prepareRootsTree";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeOnFileMoves";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 16, 17, 19, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static final class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> generatedSourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> additionalBuildDirs = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final List<HeadersSearchRoot> headersSearchRoots = new ArrayList<HeadersSearchRoot>();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = false;
    }

    private final class TreeVisitor<TState extends OCRootsBuilder.State>
    implements PathTreeBase.Visitor<OCRootTree> {
        @NotNull
        private final OCRootsBuilder<TState> builder;
        @Nullable
        private final Collection<String> watchedRoots;
        @NotNull
        private final Stack<TState> stack;
        private TState state;

        private TreeVisitor(@Nullable OCRootsBuilder<TState> builder, Collection<String> watchedRoots) {
            if (builder == null) {
                TreeVisitor.$$$reportNull$$$0(0);
            }
            this.stack = new Stack();
            this.builder = builder;
            this.watchedRoots = watchedRoots;
        }

        public void enter() {
            ProgressManager.checkCanceled();
            this.stack.push(this.state);
            this.state = this.state == null ? this.builder.createEmptyState() : this.state.copy();
        }

        public boolean visit(@Nullable String url, @NotNull OCRootTree subTree) {
            if (subTree == null) {
                TreeVisitor.$$$reportNull$$$0(1);
            }
            LOG.assertTrue(this.state != null);
            subTree = this.builder.visitSubTree(url, subTree);
            Set items = subTree.getItems();
            if (items.isEmpty() || this.shouldSkip(url, items)) {
                return true;
            }
            LOG.assertTrue(url != null);
            if (items.contains((Object)OCRootTree.RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT)) {
                this.state.setAllowLibraryRootInContent(true);
            }
            if (this.watchedRoots != null && items.contains((Object)OCRootTree.RootKind.WATCHED)) {
                this.watchedRoots.add(VfsUtilCore.urlToPath((String)url));
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_EXCLUDE)) {
                if (this.state.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(this.state, url);
                }
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
                return false;
            }
            boolean isContentRoot = items.contains((Object)OCRootTree.RootKind.CONTENT);
            if (isContentRoot && !this.state.isInContentRoot()) {
                this.builder.addContentRoot(this.state, url);
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_SOURCE)) {
                this.builder.addSourceFolder(this.state, url, false);
                this.state.setExplicitRoot(true);
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.EXPLICIT_LIBRARY)) {
                this.builder.addLibraryRoot(this.state, url);
                this.state.setExplicitRoot(true);
                return true;
            }
            if (this.state.isExplicitRoot()) {
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.SOURCE_GENERATED)) {
                this.builder.addSourceFolder(this.state, url, true);
                return true;
            }
            if (items.contains((Object)OCRootTree.RootKind.SOURCE)) {
                this.builder.addSourceFolder(this.state, url, false);
                return true;
            }
            if (this.state.allowLibraryRoot()) {
                if (items.contains((Object)OCRootTree.RootKind.LIBRARY_EXCLUDE) && this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                    return true;
                }
                if (!isContentRoot && items.contains((Object)OCRootTree.RootKind.LIBRARY)) {
                    this.builder.addLibraryRoot(this.state, url);
                    return true;
                }
            }
            if (items.contains((Object)OCRootTree.RootKind.EXCLUDE)) {
                if (this.state.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(this.state, url);
                }
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
                return true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Contract(value="null,_->fail")
        private boolean shouldSkip(@Nullable String url, @NotNull Collection<OCRootTree.RootKind> kinds) {
            if (kinds == null) {
                TreeVisitor.$$$reportNull$$$0(2);
            }
            if (!LOG.assertTrue(url != null, (Object)"Synthetic root should not be registered")) {
                return true;
            }
            if (ContainerUtil.find(OCRootsSynchronizer.this.myRootUrls, rootUrl -> FileUtil.startsWith((String)rootUrl, (String)url)) == null) {
                return false;
            }
            @NonNls String logMessage = "Refusing to register file system root " + url + " as " + kinds + " for indexing as this may lead to degraded performance.";
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(logMessage);
                Collection<String> collection = OCRootsSynchronizer.this.myRefusedRootUrls;
                synchronized (collection) {
                    if (OCRootsSynchronizer.this.myRefusedRootUrls.contains(url)) {
                        return true;
                    }
                    OCRootsSynchronizer.this.myRefusedRootUrls.add(url);
                }
                myNotificationGroup.createNotification(CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory", new Object[0]), CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory.description", url), NotificationType.WARNING).notify(OCRootsSynchronizer.this.myProject);
            } else if (onlyWarnOnRootInTests) {
                LOG.warn(logMessage);
            } else {
                LOG.error(logMessage);
            }
            return true;
        }

        public void exit() {
            this.state = (OCRootsBuilder.State)this.stack.pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subTree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kinds";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer$TreeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldSkip";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExcludedRootsTree
    extends PathTreeBase<ExcludedRootsTree> {
        private boolean myIsExcluded;
        private VirtualFile myVirtualFile;

        private ExcludedRootsTree() {
        }

        ExcludedRootsTree(@NotNull @NotNull ContentEntry @NotNull [] contentEntries) {
            if (contentEntries == null) {
                ExcludedRootsTree.$$$reportNull$$$0(0);
            }
            for (ContentEntry contentEntry : contentEntries) {
                ProgressManager.checkCanceled();
                ((ExcludedRootsTree)this.getNotNullSubTree((String)contentEntry.getUrl())).myIsExcluded = true;
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    ProgressManager.checkCanceled();
                    ((ExcludedRootsTree)this.getNotNullSubTree((String)sourceFolder.getUrl())).myIsExcluded = true;
                }
                for (SourceFolder sourceFolder : contentEntry.getExcludeFolders()) {
                    ProgressManager.checkCanceled();
                    ((ExcludedRootsTree)this.getNotNullSubTree((String)sourceFolder.getUrl())).myIsExcluded = true;
                }
            }
        }

        @NotNull
        protected ExcludedRootsTree createNewTree(@Nullable ExcludedRootsTree parent) {
            return new ExcludedRootsTree();
        }

        @Nullable
        ExcludedRootsTree getExcludedRootsSubTreeUnder(@NotNull VirtualFile file) {
            ExcludedRootsTree subTree;
            if (file == null) {
                ExcludedRootsTree.$$$reportNull$$$0(1);
            }
            if ((subTree = (ExcludedRootsTree)this.getSubTree(file.getUrl(), PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND)) != null) {
                VirtualFile cachedFile = subTree.myVirtualFile;
                LOG.assertTrue(cachedFile == null || cachedFile.equals(file), (Object)"Virtual file does not match tree!");
                if (cachedFile == null) {
                    subTree.myVirtualFile = file;
                }
            }
            return subTree;
        }

        boolean processRoots(@NotNull @NotNull Processor<@NotNull VirtualFile> processor) {
            if (processor == null) {
                ExcludedRootsTree.$$$reportNull$$$0(2);
            }
            if (this.myVirtualFile == null) {
                throw new IllegalStateException("Missing virtual file.");
            }
            if (NullVirtualFile.INSTANCE.equals(this.myVirtualFile)) {
                return true;
            }
            if (this.myIsExcluded && !processor.process((Object)this.myVirtualFile)) {
                return false;
            }
            if (ContainerUtil.isEmpty((Map)this.myChildren)) {
                return true;
            }
            for (Map.Entry childEntry : this.myChildren.entrySet()) {
                ProgressManager.checkCanceled();
                ExcludedRootsTree child = (ExcludedRootsTree)((Object)childEntry.getValue());
                if (child.myVirtualFile == null) {
                    child.myVirtualFile = (VirtualFile)ObjectUtils.notNull((Object)this.myVirtualFile.findFileByRelativePath((String)childEntry.getKey()), (Object)NullVirtualFile.INSTANCE);
                }
                if (child.processRoots(processor)) continue;
                return false;
            }
            return true;
        }

        protected boolean isLeaf() {
            return this.myIsExcluded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentEntries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/project/workspace/OCRootsSynchronizer$ExcludedRootsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getExcludedRootsSubTreeUnder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRoots";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

