/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.cidr.project.workspace.AtomicChangeAwareStorage;
import com.jetbrains.cidr.project.workspace.Change;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceInstantaneousStateChangeListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManagerKt;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceState;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizerHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0007\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J8\u0010$\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\f2%\b\u0004\u0010%\u001a\u001f\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0006\u0012\u0004\u0018\u00010\u001a0&H\u0082\bJ\b\u0010*\u001a\u00020\u001eH\u0016J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020\u001eH\u0002J\u001c\u0010-\u001a\u00020\u001e2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\b\u0010/\u001a\u00020\u001eH\u0002J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u00101\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00103\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00104\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00105\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00106\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u00107\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u00108\u001a\u00020\u001eR \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006;"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "eventNotifier", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lcom/jetbrains/cidr/project/workspace/AtomicChangeAwareStorage$Update;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Snapshot;", "Lcom/jetbrains/cidr/project/workspace/Change;", "initializedWorkspaces", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "getInitializedWorkspaces", "()Ljava/util/List;", "isDisposed", "", "modelsAreReady", "getModelsAreReady", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "workspaceStorage", "Lcom/jetbrains/cidr/project/workspace/AtomicChangeAwareStorage;", "workspaces", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceState;", "getWorkspaces", "()Ljava/util/Map;", "assertCurrentState", "", "workspace", "newState", "curState", "expectedStates", "", "changeState", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "currentState", "dispose", "dumpWorkspaceState", "", "fireWorkspaceChanged", "update", "fireWorkspaceInstantaneousStateChanged", "getProvidedWorkspaces", "getState", "markInitialized", "markInitializing", "markLoaded", "markLoading", "markNotLoaded", "markShutdown", "notifyCidrWorkspaceInstantaneousStateChanged", "Companion", "Snapshot", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nCidrWorkspaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspaceManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n62#1,11:267\n62#1,11:278\n62#1,11:289\n62#1,11:300\n62#1,11:311\n62#1,11:322\n135#2,9:237\n215#2:246\n216#2:249\n144#2:250\n167#2,3:251\n1#3:247\n1#3:248\n1#3:264\n1603#4,9:254\n1855#4:263\n1856#4:265\n1612#4:266\n*S KotlinDebug\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspaceManager\n*L\n75#1:267,11\n79#1:278,11\n84#1:289,11\n93#1:300,11\n98#1:311,11\n102#1:322,11\n38#1:237,9\n38#1:246\n38#1:249\n38#1:250\n48#1:251,3\n38#1:248\n55#1:264\n55#1:254,9\n55#1:263\n55#1:265\n55#1:266\n*E\n"})
public final class CidrWorkspaceManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicChangeAwareStorage<Snapshot, Change> workspaceStorage;
    private volatile boolean isDisposed;
    @NotNull
    private final QueueProcessor<AtomicChangeAwareStorage.Update<Snapshot, Change>> eventNotifier;

    public CidrWorkspaceManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspaceStorage = new AtomicChangeAwareStorage(Snapshot.Companion.empty());
        this.eventNotifier = new QueueProcessor(arg_0 -> CidrWorkspaceManager.eventNotifier$lambda$0((Function1)new Function1<AtomicChangeAwareStorage.Update<Snapshot, Change>, Unit>(this){
            final /* synthetic */ CidrWorkspaceManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AtomicChangeAwareStorage.Update<Snapshot, Change> update) {
                Intrinsics.checkNotNull(update);
                CidrWorkspaceManager.access$fireWorkspaceChanged(this.this$0, update);
            }
        }, arg_0), arg_0 -> CidrWorkspaceManager.eventNotifier$lambda$1(this, arg_0));
        new OCRootsSynchronizerHandler(this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CidrWorkspace> getInitializedWorkspaces() {
        void $this$mapNotNullTo$iv$iv;
        Map<CidrWorkspace, CidrWorkspaceState> $this$mapNotNull$iv = this.getWorkspaces();
        boolean $i$f$mapNotNull = false;
        Map<CidrWorkspace, CidrWorkspaceState> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            CidrWorkspace it$iv$iv;
            CidrWorkspace cidrWorkspace;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            CidrWorkspace workspace = (CidrWorkspace)entry.getKey();
            CidrWorkspaceState state = (CidrWorkspaceState)((Object)entry.getValue());
            CidrWorkspace it = cidrWorkspace = workspace;
            boolean bl3 = false;
            if ((state.getExists() ? cidrWorkspace : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public final boolean getModelsAreReady() {
        boolean bl;
        block3: {
            Map<CidrWorkspace, CidrWorkspaceState> $this$all$iv = this.getWorkspaces();
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<CidrWorkspace, CidrWorkspaceState>> iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<CidrWorkspace, CidrWorkspaceState> element$iv;
                    Map.Entry<CidrWorkspace, CidrWorkspaceState> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    CidrWorkspaceState state = entry.getValue();
                    if (state.isReady()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final Map<CidrWorkspace, CidrWorkspaceState> getWorkspaces() {
        return this.workspaceStorage.get().getMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CidrWorkspace> getProvidedWorkspaces() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CidrWorkspaceProvider.EP_NAME.getExtensionList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CidrWorkspace it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CidrWorkspaceProvider provider = (CidrWorkspaceProvider)element$iv$iv;
            boolean bl2 = false;
            if (provider.getWorkspace(this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final CidrWorkspaceState getState(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceState cidrWorkspaceState = this.getWorkspaces().get(workspace);
        if (cidrWorkspaceState == null) {
            cidrWorkspaceState = CidrWorkspaceState.Uninitialized;
        }
        return cidrWorkspaceState;
    }

    private final boolean changeState(CidrWorkspace workspace, Function1<? super CidrWorkspaceState, ? extends CidrWorkspaceState> block) {
        boolean $i$f$changeState = false;
        this.fireWorkspaceInstantaneousStateChanged();
        boolean updated2 = this.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace, block){
            final /* synthetic */ CidrWorkspace $workspace;
            final /* synthetic */ Function1<CidrWorkspaceState, CidrWorkspaceState> $block;
            {
                this.$workspace = $workspace;
                this.$block = $block;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block3: {
                    block2: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        curState = curSnapshot.getState(this.$workspace);
                        cidrWorkspaceState = (CidrWorkspaceState)((Object)this.$block.invoke((Object)((Object)curState)));
                        if (cidrWorkspaceState == null) break block2;
                        CidrWorkspaceState it = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl = false;
                        cidrWorkspaceState = !(it == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block3;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated2) {
            this.fireWorkspaceChanged();
        }
        return updated2;
    }

    public final boolean markInitializing(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            {
                this.$workspace = $workspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block4: {
                    block3: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        CidrWorkspaceState cidrWorkspaceState3;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState curState2 = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        CidrWorkspaceState it = cidrWorkspaceState3 = CidrWorkspaceState.Initializing;
                        boolean bl2 = false;
                        CidrWorkspaceState cidrWorkspaceState4 = !curState2.getExists() ? cidrWorkspaceState3 : null;
                        cidrWorkspaceState = cidrWorkspaceState4;
                        if (cidrWorkspaceState4 == null) break block3;
                        CidrWorkspaceState it2 = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl3 = false;
                        cidrWorkspaceState = !(it2 == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block4;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final boolean markInitialized(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace, this, workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            final /* synthetic */ CidrWorkspaceManager this$0;
            final /* synthetic */ CidrWorkspace $workspace$inlined;
            {
                this.$workspace = $workspace;
                this.this$0 = cidrWorkspaceManager;
                this.$workspace$inlined = cidrWorkspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block3: {
                    block2: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState curState2 = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        CidrWorkspaceManager.access$assertCurrentState(this.this$0, this.$workspace$inlined, CidrWorkspaceState.Initialized, curState2, SetsKt.setOf((Object)((Object)CidrWorkspaceState.Initializing)));
                        cidrWorkspaceState = CidrWorkspaceState.Initialized;
                        if (cidrWorkspaceState == null) break block2;
                        CidrWorkspaceState it = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl2 = false;
                        cidrWorkspaceState = !(it == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block3;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final boolean markLoading(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace, this, workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            final /* synthetic */ CidrWorkspaceManager this$0;
            final /* synthetic */ CidrWorkspace $workspace$inlined;
            {
                this.$workspace = $workspace;
                this.this$0 = cidrWorkspaceManager;
                this.$workspace$inlined = cidrWorkspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block6: {
                    block5: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        CidrWorkspaceState cidrWorkspaceState3;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState curState2 = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        if (curState2 == CidrWorkspaceState.Loading || curState2 == CidrWorkspaceState.Loaded) {
                            cidrWorkspaceState3 = null;
                        } else {
                            CidrWorkspaceManager.access$assertCurrentState(this.this$0, this.$workspace$inlined, CidrWorkspaceState.Loading, curState2, SetsKt.setOf((Object)((Object)CidrWorkspaceState.Initialized)));
                            cidrWorkspaceState3 = cidrWorkspaceState = CidrWorkspaceState.Loading;
                        }
                        if (cidrWorkspaceState3 == null) break block5;
                        CidrWorkspaceState it = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl2 = false;
                        cidrWorkspaceState = !(it == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block6;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final boolean markLoaded(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace, this, workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            final /* synthetic */ CidrWorkspaceManager this$0;
            final /* synthetic */ CidrWorkspace $workspace$inlined;
            {
                this.$workspace = $workspace;
                this.this$0 = cidrWorkspaceManager;
                this.$workspace$inlined = cidrWorkspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block3: {
                    block2: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState curState2 = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        CidrWorkspaceState[] cidrWorkspaceStateArray = new CidrWorkspaceState[]{CidrWorkspaceState.Initialized, CidrWorkspaceState.Loading, CidrWorkspaceState.Loaded};
                        CidrWorkspaceManager.access$assertCurrentState(this.this$0, this.$workspace$inlined, CidrWorkspaceState.Loaded, curState2, SetsKt.setOf((Object[])cidrWorkspaceStateArray));
                        cidrWorkspaceState = CidrWorkspaceState.Loaded;
                        if (cidrWorkspaceState == null) break block2;
                        CidrWorkspaceState it = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl2 = false;
                        cidrWorkspaceState = !(it == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block3;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final boolean markNotLoaded(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            {
                this.$workspace = $workspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block4: {
                    block3: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        CidrWorkspaceState cidrWorkspaceState3;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState curState2 = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        CidrWorkspaceState it = cidrWorkspaceState3 = CidrWorkspaceState.NotLoaded;
                        boolean bl2 = false;
                        CidrWorkspaceState cidrWorkspaceState4 = curState2 == CidrWorkspaceState.Uninitialized ? cidrWorkspaceState3 : null;
                        cidrWorkspaceState = cidrWorkspaceState4;
                        if (cidrWorkspaceState4 == null) break block3;
                        CidrWorkspaceState it2 = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl3 = false;
                        cidrWorkspaceState = !(it2 == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block4;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final boolean markShutdown(@NotNull CidrWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CidrWorkspaceManager this_$iv = this;
        boolean $i$f$changeState = false;
        this_$iv.fireWorkspaceInstantaneousStateChanged();
        boolean updated$iv = this_$iv.workspaceStorage.update((Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>)((Function1)new Function1<Snapshot, AtomicChangeAwareStorage.Update<Snapshot, Change>>(workspace){
            final /* synthetic */ CidrWorkspace $workspace;
            {
                this.$workspace = $workspace;
                super(1);
            }

            @Nullable
            public final AtomicChangeAwareStorage.Update<Snapshot, Change> invoke(@NotNull Snapshot curSnapshot) {
                CidrWorkspaceState cidrWorkspaceState;
                CidrWorkspaceState curState;
                block3: {
                    block2: {
                        CidrWorkspaceState cidrWorkspaceState2;
                        Intrinsics.checkNotNullParameter((Object)curSnapshot, (String)"curSnapshot");
                        CidrWorkspaceState it = curState = curSnapshot.getState(this.$workspace);
                        boolean bl = false;
                        cidrWorkspaceState = CidrWorkspaceState.NotLoaded;
                        if (cidrWorkspaceState == null) break block2;
                        CidrWorkspaceState it2 = cidrWorkspaceState2 = cidrWorkspaceState;
                        boolean bl2 = false;
                        cidrWorkspaceState = !(it2 == curState) ? cidrWorkspaceState2 : null;
                        if (cidrWorkspaceState != null) break block3;
                    }
                    return null;
                }
                CidrWorkspaceState newState = cidrWorkspaceState;
                Snapshot newSnapshot = curSnapshot.update(this.$workspace, newState);
                return new AtomicChangeAwareStorage.Update<Snapshot, Change>(newSnapshot, new Change(this.$workspace, curState, newState));
            }
        }));
        if (updated$iv) {
            this_$iv.fireWorkspaceChanged();
        }
        return updated$iv;
    }

    public final void notifyCidrWorkspaceInstantaneousStateChanged() {
        this.fireWorkspaceInstantaneousStateChanged();
    }

    private final void assertCurrentState(CidrWorkspace workspace, CidrWorkspaceState newState, CidrWorkspaceState curState, Set<? extends CidrWorkspaceState> expectedStates) {
        if (!expectedStates.contains((Object)curState)) {
            CidrWorkspaceManagerKt.access$getLog$p().error("marking " + workspace + " with " + newState + " state, but the current state is " + curState);
        }
    }

    private final void fireWorkspaceChanged() {
        while (this.workspaceStorage.getNextChange() != null) {
            AtomicChangeAwareStorage.Update<Snapshot, Change> change;
            this.eventNotifier.add(change);
        }
        return;
    }

    private final void fireWorkspaceChanged(AtomicChangeAwareStorage.Update<Snapshot, Change> update) {
        if (this.project.isDisposed()) {
            return;
        }
        Change change = update.getChange();
        CidrWorkspace workspace = change.component1();
        CidrWorkspaceState prevState = change.component2();
        CidrWorkspaceState newState = change.component3();
        ((CidrWorkspaceListener)this.project.getMessageBus().syncPublisher(CidrWorkspaceListener.TOPIC)).workspaceStateChanged(workspace, prevState, newState, update.getData().getMap());
    }

    private final void fireWorkspaceInstantaneousStateChanged() {
        if (this.project.isDisposed()) {
            return;
        }
        ((CidrWorkspaceInstantaneousStateChangeListener)this.project.getMessageBus().syncPublisher(CidrWorkspaceInstantaneousStateChangeListener.TOPIC)).workspaceInstantaneousStateChanged();
    }

    @TestOnly
    @NotNull
    public final String dumpWorkspaceState() {
        StringBuilder stringBuilder;
        StringBuilder $this$dumpWorkspaceState_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Set providedWorkspaces = CollectionsKt.toSet((Iterable)this.getProvidedWorkspaces());
        $this$dumpWorkspaceState_u24lambda_u2414.append("CidrWorkspaceManagerState:\n");
        for (Map.Entry<CidrWorkspace, CidrWorkspaceState> entry : this.getWorkspaces().entrySet()) {
            CidrWorkspace workspace = entry.getKey();
            CidrWorkspaceState state = entry.getValue();
            $this$dumpWorkspaceState_u24lambda_u2414.append("  ").append(workspace).append(" = ").append((Object)state);
            if (providedWorkspaces.contains(workspace)) {
                $this$dumpWorkspaceState_u24lambda_u2414.append(" [provided]");
            } else {
                $this$dumpWorkspaceState_u24lambda_u2414.append(" [unexpected!]");
            }
            $this$dumpWorkspaceState_u24lambda_u2414.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void eventNotifier$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean eventNotifier$lambda$1(CidrWorkspaceManager this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.isDisposed;
    }

    @JvmStatic
    @NotNull
    public static final CidrWorkspaceManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final CidrWorkspaceManager getInstanceOrNull(@NotNull Project project) {
        return Companion.getInstanceOrNull(project);
    }

    public static final /* synthetic */ void access$assertCurrentState(CidrWorkspaceManager $this, CidrWorkspace workspace, CidrWorkspaceState newState, CidrWorkspaceState curState, Set expectedStates) {
        $this.assertCurrentState(workspace, newState, curState, expectedStates);
    }

    public static final /* synthetic */ void access$fireWorkspaceChanged(CidrWorkspaceManager $this, AtomicChangeAwareStorage.Update update) {
        $this.fireWorkspaceChanged(update);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceOrNull", "intellij.cidr.workspaceModel"})
    @SourceDebugExtension(value={"SMAP\nCidrWorkspaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,236:1\n31#2,2:237\n51#2:239\n*S KotlinDebug\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Companion\n*L\n162#1:237,2\n165#1:239\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CidrWorkspaceManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CidrWorkspaceManager> serviceClass$iv = CidrWorkspaceManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CidrWorkspaceManager)object;
        }

        @JvmStatic
        @Nullable
        public final CidrWorkspaceManager getInstanceOrNull(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceOrNull$iv = (ComponentManager)project;
            boolean $i$f$serviceOrNull = false;
            return (CidrWorkspaceManager)$this$serviceOrNull$iv.getService(CidrWorkspaceManager.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0005R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Snapshot;", "", "map", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceState;", "(Ljava/util/Map;)V", "getMap", "()Ljava/util/Map;", "getState", "workspace", "update", "newValue", "Companion", "intellij.cidr.workspaceModel"})
    private static final class Snapshot {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<CidrWorkspace, CidrWorkspaceState> map;

        public Snapshot(@NotNull Map<CidrWorkspace, ? extends CidrWorkspaceState> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final Map<CidrWorkspace, CidrWorkspaceState> getMap() {
            return this.map;
        }

        @NotNull
        public final CidrWorkspaceState getState(@NotNull CidrWorkspace workspace) {
            Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
            CidrWorkspaceState cidrWorkspaceState = this.map.get(workspace);
            if (cidrWorkspaceState == null) {
                cidrWorkspaceState = CidrWorkspaceState.Uninitialized;
            }
            return cidrWorkspaceState;
        }

        @NotNull
        public final Snapshot update(@NotNull CidrWorkspace workspace, @NotNull CidrWorkspaceState newValue) {
            Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
            Intrinsics.checkNotNullParameter((Object)((Object)newValue), (String)"newValue");
            return new Snapshot(MapsKt.plus(this.map, (Pair)TuplesKt.to((Object)workspace, (Object)((Object)newValue))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Snapshot$Companion;", "", "()V", "empty", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager$Snapshot;", "intellij.cidr.workspaceModel"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Snapshot empty() {
                return new Snapshot(MapsKt.emptyMap());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

