/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.ui.widget;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.popup.Docked;
import com.jetbrains.cidr.project.ui.popup.PopupService;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesPopup;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import com.jetbrains.cidr.project.ui.widget.WidgetStatusProvider;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceInstantaneousStateChangeListener;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/project/ui/widget/ProjectStatusWidget;", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ID", "", "createInstance", "Lcom/intellij/openapi/wm/StatusBarWidget;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getIcon", "Ljavax/swing/Icon;", "status", "Lcom/jetbrains/cidr/project/ui/widget/Status;", "getWidgetState", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "registerCidrWorkspaceListener", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "registerCustomListeners", "registerDumbModeListener", "registerRunConfigurationListener", "Companion", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nProjectStatusWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStatusWidget.kt\ncom/jetbrains/cidr/project/ui/widget/ProjectStatusWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,121:1\n1#2:122\n31#3,2:123\n*S KotlinDebug\n*F\n+ 1 ProjectStatusWidget.kt\ncom/jetbrains/cidr/project/ui/widget/ProjectStatusWidget\n*L\n61#1:123,2\n*E\n"})
public final class ProjectStatusWidget
extends EditorBasedStatusBarPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "ProjectStatusWidget";

    public ProjectStatusWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        EditorBasedStatusBarPopup.WidgetState widgetState;
        WidgetStatus projectInfo;
        block3: {
            Object object;
            if (!ProjectStatusHelperKt.isWidgetEnabled()) {
                return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            }
            for (Object it : (Iterable)WidgetStatusProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                if ((it = it.getWidgetStatus(this.getProject(), file)) == null) continue;
                object = it;
                break block3;
            }
            object = projectInfo = null;
        }
        if (projectInfo == null) {
            throw new IllegalStateException("Default implementation missing.");
        }
        EditorBasedStatusBarPopup.WidgetState $this$getWidgetState_u24lambda_u241 = widgetState = new EditorBasedStatusBarPopup.WidgetState(projectInfo.getDescription(), null, projectInfo.getStatus() != Status.OK);
        boolean bl = false;
        $this$getWidgetState_u24lambda_u241.setIcon(this.getIcon(projectInfo.getStatus()));
        return widgetState;
    }

    private final Icon getIcon(Status status) {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                Icon icon2 = AllIcons.Toolwindows.ToolWindowProject;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolWindowProject");
                break;
            }
            case 2: {
                Icon icon3 = AllIcons.General.Warning;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Warning");
                break;
            }
            case 3: {
                Icon icon4 = AllIcons.General.Information;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Information");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    protected ListPopup createPopup(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectFixesPopup popup = new ProjectFixesPopup(context, Docked.BOTTOM);
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<PopupService> serviceClass$iv = PopupService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PopupService)object).collectFixesAndUpdate(popup, context);
        return (ListPopup)popup;
    }

    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.registerCidrWorkspaceListener(connection);
        this.registerDumbModeListener(connection);
        this.registerRunConfigurationListener(connection);
    }

    private final void registerCidrWorkspaceListener(MessageBusConnection connection) {
        connection.subscribe(CidrWorkspaceInstantaneousStateChangeListener.TOPIC, (Object)new CidrWorkspaceInstantaneousStateChangeListener(this){
            final /* synthetic */ ProjectStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void workspaceInstantaneousStateChanged() {
                this.this$0.update();
            }
        });
    }

    private final void registerDumbModeListener(MessageBusConnection connection) {
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ ProjectStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void exitDumbMode() {
                if (!ProjectStatusWidget.access$getProject(this.this$0).isDisposed()) {
                    this.this$0.update();
                }
            }
        });
    }

    private final void registerRunConfigurationListener(MessageBusConnection connection) {
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new RunManagerListener(this){
            final /* synthetic */ ProjectStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.this$0.update();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.this$0.update();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, @Nullable String existingId) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.this$0.update();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.this$0.update();
            }
        });
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (StatusBarWidget)new ProjectStatusWidget(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public static final /* synthetic */ Project access$getProject(ProjectStatusWidget $this) {
        return $this.getProject();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/project/ui/widget/ProjectStatusWidget$Companion;", "", "()V", "ID", "", "intellij.cidr.workspaceModel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

