/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.ui.notifications;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.notifications.EditorNotificationWarningProvider;
import com.jetbrains.cidr.project.ui.notifications.EditorProjectNotificationPanel;
import com.jetbrains.cidr.project.ui.notifications.EditorProjectNotificationProvider;
import com.jetbrains.cidr.project.ui.notifications.ProjectNotification;
import com.jetbrains.cidr.project.ui.popup.Docked;
import com.jetbrains.cidr.project.ui.popup.PopupService;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesPopup;
import java.awt.Component;
import java.awt.Point;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/project/ui/notifications/EditorProjectNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nEditorProjectNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorProjectNotificationProvider.kt\ncom/jetbrains/cidr/project/ui/notifications/EditorProjectNotificationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n1#2:74\n31#3,2:75\n*S KotlinDebug\n*F\n+ 1 EditorProjectNotificationProvider.kt\ncom/jetbrains/cidr/project/ui/notifications/EditorProjectNotificationProvider\n*L\n62#1:75,2\n*E\n"})
public final class EditorProjectNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectNotification projectNotification;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (ProjectStatusHelperKt.isWidgetEnabled()) {
                return null;
            }
            for (EditorNotificationWarningProvider it : (Iterable)EditorNotificationWarningProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                ProjectNotification projectNotification2 = it.getProjectNotification(project, file);
                if (projectNotification2 == null) continue;
                projectNotification = projectNotification2;
                break block3;
            }
            projectNotification = null;
        }
        if (projectNotification == null) {
            return null;
        }
        ProjectNotification notification2 = projectNotification;
        return arg_0 -> EditorProjectNotificationProvider.collectNotificationData$lambda$3(notification2, project, file, arg_0);
    }

    private static final void collectNotificationData$lambda$3$lambda$2$lambda$1(collectNotificationData.1.1.labelHolder.1 $labelHolder, Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$labelHolder, (String)"$labelHolder");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        HyperlinkLabel hyperlinkLabel = $labelHolder.getLabel();
        if (hyperlinkLabel == null) {
            return;
        }
        HyperlinkLabel component = hyperlinkLabel;
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)$project).add(CommonDataKeys.VIRTUAL_FILE, (Object)$file).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        ProjectFixesPopup popup = new ProjectFixesPopup(dataContext2, Docked.TOP);
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<PopupService> serviceClass$iv = PopupService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PopupService)object).collectFixesAndUpdate(popup, dataContext2);
        popup.show(new RelativePoint((Component)component, new Point(0, component.getPreferredSize().height)));
    }

    private static final void collectNotificationData$lambda$3$lambda$2(Project $project, VirtualFile $file, EditorProjectNotificationPanel $panel) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)((Object)$panel), (String)"$panel");
        if ($project.isDisposed() || !$file.isValid()) {
            return;
        }
        var labelHolder2 = new Object(){
            @Nullable
            private HyperlinkLabel label;

            @Nullable
            public final HyperlinkLabel getLabel() {
                return this.label;
            }

            public final void setLabel(@Nullable HyperlinkLabel hyperlinkLabel) {
                this.label = hyperlinkLabel;
            }
        };
        labelHolder2.setLabel($panel.createActionLabel(CidrWorkspaceBundle.message("project.notifications.show.fixes.text", new Object[0]), () -> EditorProjectNotificationProvider.collectNotificationData$lambda$3$lambda$2$lambda$1(labelHolder2, $project, $file), false));
    }

    private static final JComponent collectNotificationData$lambda$3(ProjectNotification $notification, Project $project, VirtualFile $file, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorProjectNotificationPanel panel = new EditorProjectNotificationPanel($notification.getNotificationText(), $notification.getType(), fileEditor);
        ReadAction.run(() -> EditorProjectNotificationProvider.collectNotificationData$lambda$3$lambda$2($project, $file, panel));
        return (JComponent)((Object)panel);
    }
}

