/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.ui;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.project.ui.notifications.NotificationType;
import com.jetbrains.cidr.project.ui.notifications.ProjectNotification;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\b\u0010\u000b\u001a\u00020\u0005H\u0000\u00a8\u0006\f"}, d2={"convertStatus", "Lcom/jetbrains/cidr/project/ui/notifications/ProjectNotification;", "status", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatus;", "isExternalFileOrSingleFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectAwareFile", "isWidgetEnabled", "intellij.cidr.workspaceModel"})
public final class ProjectStatusHelperKt {
    public static final boolean isProjectAwareFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return OCLanguageUtilsBase.isSupported(file.getFileType()) && !ProjectFileIndex.getInstance((Project)project).isExcluded(file) && !ScratchUtil.isScratch((VirtualFile)file);
    }

    public static final boolean isWidgetEnabled() {
        return Registry.is((String)"ide.widget.project.status");
    }

    public static final boolean isExternalFileOrSingleFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        VirtualFile contentRoot = rootManager.getFileIndex().getContentRootForFile(file);
        return contentRoot == null || Intrinsics.areEqual((Object)contentRoot, (Object)file) && rootManager.getContentRoots().length == 1;
    }

    @Nullable
    public static final ProjectNotification convertStatus(@Nullable WidgetStatus status) {
        NotificationType notificationType;
        if (status == null) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[status.getStatus().ordinal()]) {
            case 1: {
                notificationType = NotificationType.Warning;
                break;
            }
            case 2: {
                notificationType = NotificationType.Info;
                break;
            }
            default: {
                return null;
            }
        }
        NotificationType notificationStatus = notificationType;
        return new ProjectNotification(notificationStatus, status.getDescription());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.Warning.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.Info.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

