/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.projectView.actions.UnmarkRootAction;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.project.CidrMarkRootActionsKt;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.workspaceModelBridge.OCExcludeWorkspaceModelRootsBuilder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J+\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/project/CidrUnmarkRootAction;", "Lcom/intellij/ide/projectView/actions/UnmarkRootAction;", "()V", "doUpdate", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "module", "Lcom/intellij/openapi/module/Module;", "selection", "Lcom/intellij/ide/projectView/actions/MarkRootActionBase$RootsSelection;", "getActionText", "", "getSelectedRootsCount", "", "isEnabled", "", "modifyRoots", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/module/Module;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "", "file", "entry", "Lcom/intellij/openapi/roots/ContentEntry;", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nCidrMarkRootActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrMarkRootActions.kt\ncom/jetbrains/cidr/project/CidrUnmarkRootAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1855#2,2:223\n*S KotlinDebug\n*F\n+ 1 CidrMarkRootActions.kt\ncom/jetbrains/cidr/project/CidrUnmarkRootAction\n*L\n147#1:223,2\n*E\n"})
public final class CidrUnmarkRootAction
extends UnmarkRootAction {
    protected void modifyRoots(@NotNull AnActionEvent e, @NotNull Module module, @NotNull VirtualFile[] files) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ApplicationManager.getApplication().runWriteAction(() -> CidrUnmarkRootAction.modifyRoots$lambda$0(module, files));
    }

    @NotNull
    protected Void modifyRoots(@NotNull VirtualFile file, @NotNull ContentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected String getActionText(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (module != null) {
            if (this.getSelectedRootsCount(module, selection) > 1) {
                return LangBundle.message((String)"mark.as.unmark.several", (Object[])new Object[0]);
            }
            return null;
        }
        return super.getActionText(e, null, selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (OCExcludeWorkspaceModelRootsBuilder.Companion.isEnabled()) {
            List list = selection.mySelectedExcludeRoots;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mySelectedExcludeRoots");
            if (!((Collection)list).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
        }
        super.doUpdate(e, module, selection);
    }

    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CidrMarkRootActionsKt.access$isSupported(selection, module) && this.getSelectedRootsCount(module, selection) > 0;
    }

    private final int getSelectedRootsCount(Module module, MarkRootActionBase.RootsSelection selection) {
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)moduleFileIndex, (String)"getFileIndex(...)");
        ModuleFileIndex fileIndex = moduleFileIndex;
        int count = 0;
        count = selection.mySelectedRoots.size() + selection.mySelectedExcludeRoots.size();
        List list = selection.mySelectedDirectories;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mySelectedDirectories");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (CidrMarkRootActionsKt.access$isLibraryRoot(fileIndex, it)) {
                ++count;
            }
            if (count > 1) continue;
        }
        return count;
    }

    private static final void modifyRoots$lambda$0(Module $module, VirtualFile[] $files) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CidrRootConfiguration.Companion.getInstance(project).removeRoots(ArraysKt.toList((Object[])$files));
    }
}

