/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CUDAToolkitInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCOutputParser;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001e\u0010 \u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0016J\u0018\u0010#\u001a\u0004\u0018\u00010\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001e\u0010$\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010*\u001a\u0004\u0018\u00010\u0016J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020\u0016H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Ljava/io/File;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "myVersion", "Lcom/intellij/openapi/util/Version;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addExtraSwitches", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "ccInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "originalSwitches", "cxxStandard", "", "adjustMSVCFlags", "", "switches", "collectInfo", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "extractExplicit", "filterDuplicateCCBin", "list", "filterOptions", "skipOptions", "", "fromCUDAArch", "getComputeCapability", "orig", "getHostCompiler", "parser", "Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCOutputParser;", "parseVersionString", "readVersion", "resolveCUDAInstallDirectory", "hostMachine", "Lcom/jetbrains/cidr/system/HostMachine;", "cudaInstallPath", "runNVCC", "supportsForwardingUnknownArguments", "", "syncRemoteCUDAHeaders", "cudaInstall", "Companion", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nNVCCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NVCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,460:1\n1#2:461\n1549#3:462\n1620#3,3:463\n959#3,7:466\n766#3:473\n857#3,2:474\n1774#3,4:476\n378#3,7:480\n1549#3:487\n1620#3,3:488\n1549#3:491\n1620#3,3:492\n37#4,2:495\n*S KotlinDebug\n*F\n+ 1 NVCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler\n*L\n119#1:462\n119#1:463,3\n137#1:466,7\n139#1:473\n139#1:474,2\n178#1:476,4\n182#1:480,7\n231#1:487\n231#1:488,3\n239#1:491\n239#1:492,3\n245#1:495,2\n*E\n"})
public final class NVCCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Version myVersion;
    @NotNull
    private static final Set<String> skipSwitches;

    public NVCCCompiler(@NotNull Project project, @NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        super(executable, workingDirectory, environment, tempFilesPool);
        this.project = project;
        this.myVersion = this.parseVersionString();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.listOf((Object)"--version"), (Function<? super ProcessOutput, String>)((Function)arg_0 -> NVCCCompiler.readVersion$lambda$0(readVersion.1.INSTANCE, arg_0)));
    }

    private final boolean supportsForwardingUnknownArguments() {
        Version version = this.myVersion;
        return version != null ? version.isOrGreaterThan(Integer.valueOf(10), Integer.valueOf(2), Integer.valueOf(19)) : false;
    }

    private final Version parseVersionString() {
        String string = this.readVersion();
        if (string == null) {
            return null;
        }
        String version = string;
        MatchResult matchResult = new Regex("^([0-9]+)\\.([0-9]+)\\.([0-9]+)$").matchEntire((CharSequence)version);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String major = (String)matchResult2.getMatch().getGroupValues().get(1);
        String minor = (String)matchResult2.getMatch().getGroupValues().get(2);
        String patch = (String)matchResult2.getMatch().getGroupValues().get(3);
        return new Version(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
    }

    private final String extractExplicit(List<String> switches) {
        String string;
        Object v0;
        block3: {
            Iterable iterable = switches;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"arch=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"sm_", (boolean)false, (int)2, null))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        String string2 = v0;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            int idx = StringsKt.indexOf$default((CharSequence)it, (String)"sm_", (int)0, (boolean)false, (int)6, null);
            String string3 = it.substring(idx, idx + 5);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final String fromCUDAArch(List<String> switches) {
        String string;
        Object v0;
        block3: {
            Iterable iterable = switches;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-D__CUDA_ARCH__", (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        String string2 = v0;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String subStr = StringsKt.dropLast((String)StringsKt.substringAfter$default((String)it, (String)"=", null, (int)2, null), (int)1);
            string = "sm_" + subStr;
        } else {
            string = null;
        }
        return string;
    }

    private final String getComputeCapability(List<String> switches, CidrCompilerSwitches orig) {
        Collection collection = switches;
        List<String> list = orig.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List switchList = CollectionsKt.plus((Collection)collection, (Iterable)list);
        String string = this.extractExplicit(switchList);
        if (string == null && (string = this.fromCUDAArch(switchList)) == null) {
            string = "sm_35";
        }
        return "--cuda-gpu-arch=" + string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> adjustMSVCFlags(List<String> switches) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = switches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? "-" + StringsKt.drop((String)it, (int)1) : it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches originalSwitches) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter((Object)originalSwitches, (String)"originalSwitches");
        return this.runNVCC(this.filterOptions(originalSwitches, SetsKt.emptySet()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)switches, (String)"switches");
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        List<String> list = switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        Iterable $this$takeWhile$iv = list;
        boolean $i$f$takeWhile22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            String it = (String)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"&&"))) break;
            list$iv.add(item$iv);
        }
        List list2 = list$iv;
        CidrCompilerSwitches cleanSwitches = new CidrCompilerSwitches(list2);
        Iterable $i$f$takeWhile22 = skipOptions;
        Set<String> set = skipSwitches;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set switchesToSkip = SetsKt.plus(set, (Iterable)((List)destination$iv$iv));
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>((Set<String>)switchesToSkip, skipOptions){
            private boolean skipOptionValue;
            final /* synthetic */ Set<String> $switchesToSkip;
            final /* synthetic */ Set<String> $skipOptions;
            {
                this.$switchesToSkip = $switchesToSkip;
                this.$skipOptions = $skipOptions;
            }

            public final boolean getSkipOptionValue() {
                return this.skipOptionValue;
            }

            public final void setSkipOptionValue(boolean bl) {
                this.skipOptionValue = bl;
            }

            @NotNull
            public Boolean apply(@NotNull String param, @Nullable String nextParam) {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    boolean isSwitch = this.$switchesToSkip.contains(param);
                    boolean tokenIsSwitch = StringsKt.startsWith$default((String)param, (String)"-", (boolean)false, (int)2, null);
                    if (this.$skipOptions.contains(param)) {
                        this.skipOptionValue = tokenIsSwitch;
                        return false;
                    }
                    if (this.skipOptionValue) {
                        this.skipOptionValue = false;
                        if (!isSwitch) {
                            return false;
                        }
                    }
                    if (isSwitch) {
                        this.skipOptionValue = true;
                        return false;
                    }
                    Iterable $this$any$iv = this.$switchesToSkip;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)param, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return false;
                }
                return true;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = cleanSwitches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
        Intrinsics.checkNotNullExpressionValue((Object)cidrCompilerSwitches, (String)"filterOptions(...)");
        return cidrCompilerSwitches;
    }

    private final List<String> filterDuplicateCCBin(List<String> list) {
        int n;
        block8: {
            int n2;
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (n2 <= 1) {
                return list;
            }
            List<String> $this$indexOfLast$iv = list;
            boolean $i$f$indexOfLast = false;
            ListIterator<String> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null))) continue;
                n = iterator$iv.nextIndex();
                break block8;
            }
            n = -1;
        }
        int lastIndex = n;
        List result2 = new ArrayList();
        boolean lastWasCCBin = false;
        int n3 = list.size();
        for (int idx = 0; idx < n3; ++idx) {
            String elem = list.get(idx);
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir=", (boolean)false, (int)2, null)) {
                if (idx != lastIndex) continue;
                result2.add(elem);
                continue;
            }
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir", (boolean)false, (int)2, null)) {
                lastWasCCBin = true;
                if (idx != lastIndex) continue;
                result2.add(elem);
                continue;
            }
            if (lastWasCCBin && lastIndex != idx - 1) continue;
            result2.add(elem);
        }
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getHostCompiler(NVCCOutputParser parser) {
        String string;
        String compiler = parser.getCompiler();
        Path path = parser.getFullCompilerPath(compiler);
        if (path == null) {
            return compiler;
        }
        Path fullCompiler = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(fullCompiler, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(fullCompiler, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                string = ((Object)fullCompiler).toString();
                return string;
            }
        }
        string = compiler;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompilerInfo runNVCC(CidrCompilerSwitches switches) throws ExecutionException {
        Path path;
        Object object;
        Path emptyFile = null;
        try {
            Collection collection;
            HostMachine host = this.myEnvironment.getHostMachine();
            Path path2 = host.getTempDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getTempDirectory(...)");
            Path tempDir = path2;
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", ".cu");
            Pair<GeneralCommandLine, String> pair = NVCCCompiler.runNVCC$createCompilerExecutionCommandLine(this, switches, emptyFile);
            GeneralCommandLine commandLine1 = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running: " + userFriendlyCommandLine1);
            ProcessOutput processOutput2 = OCCompilerBase.outCompilerRunner.run(commandLine1, this.myEnvironment);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"run(...)");
            ProcessOutput output = processOutput2;
            OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
            OCCompilerBase.LOG.debug("Got stderr:\n" + output.getStderr() + "\nstdout:\n" + output.getStdout());
            Collection collection2 = output.getStderrLines();
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = output.getStdoutLines();
            } else {
                collection = collection2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ifEmpty(...)");
            List outputLines = (List)collection;
            CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
            NVCCOutputParser outputParser = new NVCCOutputParser(outputLines, cidrToolEnvironment);
            String compiler = this.getHostCompiler(outputParser);
            List<String> compilerFlags = outputParser.getFlags();
            Path path3 = host.getPath(compiler, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getPath(...)");
            CidrToolEnvironment cidrToolEnvironment2 = this.myEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment2, (String)"myEnvironment");
            OCCompilerKind compKind = OCCompilerResolver.Companion.resolve(this.project, path3, cidrToolEnvironment2);
            if (Intrinsics.areEqual((Object)compKind, (Object)NVCCCompilerKind.INSTANCE)) {
                throw new ExecutionException(CidrProjectModelBundle.message("nvcc.should.not.invoke.itself", new Object[0]));
            }
            OCCompiler oCCompiler = compKind.getCompilerInstance(this.project, new File(compiler), this.myWorkingDirectory, this.myEnvironment, this.myTempFilesPool);
            Intrinsics.checkNotNull((Object)oCCompiler);
            OCCompiler comp = oCCompiler;
            CidrCompilerSwitches cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(compilerFlags).build();
            Intrinsics.checkNotNullExpressionValue((Object)cidrCompilerSwitches, (String)"build(...)");
            CidrCompilerSwitches resultSwitches = cidrCompilerSwitches;
            CompilerInfo compilerInfo = comp.collectInfo(CLanguageKind.CPP, resultSwitches);
            Intrinsics.checkNotNullExpressionValue((Object)compilerInfo, (String)"collectInfo(...)");
            CompilerInfo ccInfo = compilerInfo;
            CidrCompilerSwitches hostCompilerFlags = this.addExtraSwitches(ccInfo, switches, outputParser.getCxxStandard());
            Intrinsics.checkNotNull((Object)host);
            String cudaPath = this.resolveCUDAInstallDirectory(host, outputParser.getCUDAInstallDir());
            if (host.isRemote() && !host.isWsl() && ((CharSequence)cudaPath).length() > 0) {
                cudaPath = this.syncRemoteCUDAHeaders(host, cudaPath);
            }
            Map features = MapsKt.toMutableMap(ccInfo.getFeatures());
            features.put(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND, compKind);
            features.put(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS, hostCompilerFlags);
            object = features;
            OCCompilerFeatures.Type<CUDAToolkitInfo> type = OCCompilerFeatures.CUDA_TOOLKIT;
            Intrinsics.checkNotNullExpressionValue(type, (String)"CUDA_TOOLKIT");
            OCCompilerFeatures.Type<CUDAToolkitInfo> type2 = type;
            CUDAToolkitInfo cUDAToolkitInfo = new CUDAToolkitInfo(cudaPath, host.isWsl());
            object.put(type2, cUDAToolkitInfo);
            object = new CompilerInfo(switches, ccInfo.getDefines(), features, ccInfo.getHeadersSearchPaths(), ccInfo.getImplicitIncludes(), ccInfo.getPrecompiledIncludes(), ccInfo.getWarnings(), ccInfo.getCompilerExitCode());
            path = emptyFile;
        }
        catch (IOException e) {
            try {
                throw new ExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                block9: {
                    Path path4 = emptyFile;
                    if (path4 == null) break block9;
                    Path it = path4;
                    boolean bl = false;
                    this.myTempFilesPool.delete(it);
                }
                throw throwable;
            }
        }
        if (path != null) {
            Path it = path;
            boolean bl = false;
            this.myTempFilesPool.delete(it);
        }
        return object;
    }

    private final CidrCompilerSwitches addExtraSwitches(CompilerInfo ccInfo, CidrCompilerSwitches originalSwitches, String cxxStandard) {
        Object[] objectArray = new String[]{"-x", "-FI"};
        List<String> list = this.filterOptions(ccInfo.getSwitches(), SetsKt.mutableSetOf((Object[])objectArray)).getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List<String> switchesList = list;
        objectArray = new String[]{this.getComputeCapability(switchesList, originalSwitches)};
        List additionalArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        boolean hasCXXFlag = OCLanguageStandard.Companion.findLanguageStandard(switchesList) != null;
        if (((CharSequence)cxxStandard).length() > 0 && !hasCXXFlag) {
            ((Collection)additionalArgs).add(cxxStandard);
        }
        List allFlags = CollectionsKt.plus((Collection)this.adjustMSVCFlags(switchesList), (Iterable)additionalArgs);
        return new CidrCompilerSwitches(allFlags);
    }

    private final String resolveCUDAInstallDirectory(HostMachine hostMachine, String cudaInstallPath) {
        String string;
        if (((CharSequence)cudaInstallPath).length() > 0) {
            String string2 = FileUtil.toSystemIndependentName((String)cudaInstallPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            string = NVCCCompilerKt.access$toCanonicalPath(hostMachine, string2);
        } else if (hostMachine.getOSType().toOS() == OS.Linux) {
            string = "";
        } else {
            OCCompilerBase.LOG.debug("Could not find cuda install path on " + hostMachine.getOSType().name());
            string = "";
        }
        return string;
    }

    private final String syncRemoteCUDAHeaders(HostMachine hostMachine, String cudaInstall) {
        String string;
        Path path = hostMachine.getPath(cudaInstall, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path path2 = path;
        Object[] objectArray = hostMachine.toCanonicalPath(CollectionsKt.listOf((Object)FileUtil.toSystemIndependentName((String)((Object)path2.resolve("include")).toString())), true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toCanonicalPath(...)");
        Object[] includeDirectory = objectArray;
        List list = hostMachine.resolveAndCache(ArraysKt.toList((Object[])includeDirectory));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolveAndCache(...)");
        List resolvedPaths = list;
        if (resolvedPaths.isEmpty()) {
            string = "";
        } else {
            Path firstPath = Path.of((String)CollectionsKt.first((List)resolvedPaths), new String[0]);
            Path path3 = firstPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            string = ((Object)path3.toAbsolutePath()).toString();
        }
        return string;
    }

    private static final String readVersion$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair<GeneralCommandLine, String> runNVCC$createCompilerExecutionCommandLine(NVCCCompiler this$0, CidrCompilerSwitches $switches, Path parameter) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        GeneralCommandLine cl = new GeneralCommandLine();
        this$0.myEnvironment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        List<String> list = $switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List<String> switchesList = this$0.filterDuplicateCCBin(list);
        String[] stringArray = (String[])switchesList;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"-isystem", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"-isystem=", (boolean)false, (int)2, null)) {
                String string3 = it.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string = "-isystem=" + string3;
            } else {
                string = it;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"'", (String)"\"", (boolean)false, (int)4, null));
        }
        List extraFlags = (List)destination$iv$iv;
        cl.setExePath(this$0.getExecutable().getPath());
        cl.withWorkDirectory(this$0.myWorkingDirectory);
        Collection $this$toTypedArray$iv = extraFlags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        cl.addParameters(Arrays.copyOf(stringArray, stringArray.length));
        cl.addParameter("--dryrun");
        if (this$0.supportsForwardingUnknownArguments()) {
            cl.addParameter("-forward-unknown-to-host-compiler");
        }
        stringArray = new String[]{this$0.myEnvironment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())};
        cl.addParameters(stringArray);
        String string = cl.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        return new Pair((Object)cl, (Object)string);
    }

    static {
        Object[] objectArray = new String[]{"-o", "--output", "--output=", "--output-file", "--output-file=", "-M", "-MM", "-MF", "-MG", "-MP", "-MT", "-MQ", "-MD", "-MMD", "--generate-dependencies", "--generate-nonsystem-dependencies", "--dependency-output", "--generate-dependency-targets", "--generate-dependencies-with-compile", "--generate-nonsystem-dependencies-with-compile", "--threads", "-t"};
        skipSwitches = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler$Companion;", "", "()V", "skipSwitches", "", "", "getCCBinOption", "combinedCompilerFlags", "", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getCCBinOption(@NotNull List<String> combinedCompilerFlags) {
            Intrinsics.checkNotNullParameter(combinedCompilerFlags, (String)"combinedCompilerFlags");
            String cudaCCBinOption = null;
            int n = combinedCompilerFlags.size();
            for (int idx = 0; idx < n; ++idx) {
                String currentFlag = combinedCompilerFlags.get(idx);
                if (!StringsKt.startsWith$default((String)currentFlag, (String)"-ccbin", (boolean)false, (int)2, null)) {
                    if (!StringsKt.startsWith$default((String)currentFlag, (String)"--compiler-bindir", (boolean)false, (int)2, null)) continue;
                }
                cudaCCBinOption = StringsKt.contains$default((CharSequence)currentFlag, (CharSequence)"=", (boolean)false, (int)2, null) ? currentFlag : (idx + 1 < combinedCompilerFlags.size() ? "-ccbin=" + combinedCompilerFlags.get(idx + 1) : null);
                break;
            }
            return cudaCCBinOption;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

