/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\b\u0002\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature;", "", "command", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Command;", "key", "", "Lorg/jetbrains/annotations/NonNls;", "value", "(Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Command;Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$Command;", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Parser", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompilerFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompilerFeature.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n13#2:83\n*S KotlinDebug\n*F\n+ 1 GCCCompilerFeature.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature\n*L\n19#1:83\n*E\n"})
public final class GCCCompilerFeature {
    @NotNull
    public static final Parser Parser = new Parser(null);
    @NotNull
    private final GCCCompiler.Command command;
    @NotNull
    private final String key;
    @NotNull
    private final String value;
    @NotNull
    private static final Logger LOGGER;
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String COMMAND = "(?<command>\\w+?)";
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String KEY = "(?<key>[^=]+?)";
    @Language(value="RegExp")
    @NonNls
    @NotNull
    private static final String VALUE = "(?<value>.+?)";
    private static final Pattern COMMAND_PATTERN;

    public GCCCompilerFeature(@NotNull GCCCompiler.Command command, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.command = command;
        this.key = key;
        this.value = value;
    }

    @NotNull
    public final GCCCompiler.Command getCommand() {
        return this.command;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final GCCCompiler.Command component1() {
        return this.command;
    }

    @NotNull
    public final String component2() {
        return this.key;
    }

    @NotNull
    public final String component3() {
        return this.value;
    }

    @NotNull
    public final GCCCompilerFeature copy(@NotNull GCCCompiler.Command command, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new GCCCompilerFeature(command, key, value);
    }

    public static /* synthetic */ GCCCompilerFeature copy$default(GCCCompilerFeature gCCCompilerFeature, GCCCompiler.Command command, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            command = gCCCompilerFeature.command;
        }
        if ((n & 2) != 0) {
            string = gCCCompilerFeature.key;
        }
        if ((n & 4) != 0) {
            string2 = gCCCompilerFeature.value;
        }
        return gCCCompilerFeature.copy(command, string, string2);
    }

    @NotNull
    public String toString() {
        return "GCCCompilerFeature(command=" + this.command + ", key=" + this.key + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result2 = this.command.hashCode();
        result2 = result2 * 31 + this.key.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GCCCompilerFeature)) {
            return false;
        }
        GCCCompilerFeature gCCCompilerFeature = (GCCCompilerFeature)other;
        if (this.command != gCCCompilerFeature.command) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)gCCCompilerFeature.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)gCCCompilerFeature.value);
    }

    @JvmStatic
    @Nullable
    public static final GCCCompilerFeature parse(@Language(value="C") @NotNull String line) {
        return Parser.parse(line);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OCCompilerBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        COMMAND_PATTERN = Pattern.compile("^\\h*\\{\\h*int\\h+(?:__attribute__\\h*\\(\\h*\\(\\h*unused\\h*\\)\\h*\\))?\\h*\\Q____CIDR_command_\\E(?<command>\\w+?)\\h*,\\h*\\Q____CIDR_command_\\E(?<key>[^=]+?)\\h*=\\h*\\(\\h*(?:\\(\\h*void\\h*\\))?\\h*(?<value>.+?)\\h*,\\h*0\\h*\\)\\h*;\\h*}\\h*$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\r\u001a\u0004\u0018\u00010\u000e2\r\b\u0001\u0010\u000f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0010\u0010\t\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature$Parser;", "", "()V", "COMMAND", "", "COMMAND_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getCOMMAND_PATTERN$annotations", "KEY", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "VALUE", "parse", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerFeature;", "line", "Lorg/jetbrains/annotations/NonNls;", "intellij.cidr.projectModel"})
    public static final class Parser {
        private Parser() {
        }

        private static /* synthetic */ void getCOMMAND_PATTERN$annotations() {
        }

        @JvmStatic
        @Nullable
        public final GCCCompilerFeature parse(@Language(value="C") @NotNull String line) {
            GCCCompiler.Command command;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Matcher matcher = OCCompilerBase.matchSafely(COMMAND_PATTERN, line);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matchSafely(...)");
            Matcher matcher2 = matcher;
            if (!matcher2.find()) {
                return null;
            }
            String rawCommand = matcher2.group("command");
            try {
                Intrinsics.checkNotNull((Object)rawCommand);
                command = GCCCompiler.Command.valueOf(rawCommand);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Unexpected command: " + rawCommand);
                return null;
            }
            GCCCompiler.Command command2 = command;
            String key = matcher2.group("key");
            String value = matcher2.group("value");
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)value);
            return new GCCCompilerFeature(command2, key, value);
        }

        public /* synthetic */ Parser(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

